/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RunAll
implements Runnable {
    private final List<? extends ThrowableRunnable<?>> myActions;

    @SafeVarargs
    public RunAll(ThrowableRunnable<Throwable> ... actions) {
        if (actions == null) {
            RunAll.$$$reportNull$$$0(0);
        }
        this(ContainerUtil.newArrayList((Object[])actions));
    }

    private RunAll(@NotNull List<? extends ThrowableRunnable<?>> actions) {
        if (actions == null) {
            RunAll.$$$reportNull$$$0(1);
        }
        this.myActions = actions;
    }

    @SafeVarargs
    @Contract(pure=true)
    public final RunAll append(ThrowableRunnable<Throwable> ... actions) {
        if (actions == null) {
            RunAll.$$$reportNull$$$0(2);
        }
        return new RunAll(ContainerUtil.concat(this.myActions, (List)(actions.length == 1 ? Collections.singletonList(actions[0]) : ContainerUtilRt.newArrayList((Object[])actions))));
    }

    @Override
    public void run() {
        this.run(Collections.emptyList());
    }

    public void run(@NotNull List<? extends Throwable> suppressedExceptions) {
        if (suppressedExceptions == null) {
            RunAll.$$$reportNull$$$0(3);
        }
        List<Throwable> throwables = this.collectExceptions();
        throwables.addAll(0, suppressedExceptions);
        CompoundRuntimeException.throwIfNotEmpty(throwables);
    }

    @NotNull
    private List<Throwable> collectExceptions() {
        SmartList errors = new SmartList();
        for (ThrowableRunnable<?> action : this.myActions) {
            try {
                action.run();
            }
            catch (CompoundRuntimeException e) {
                errors.addAll(e.getExceptions());
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
        SmartList smartList = errors;
        if (smartList == null) {
            RunAll.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressedExceptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/RunAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/RunAll";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

