/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.Source;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.MultipleSourceTaskParameter;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.pdf.collection.InitialView;
import org.sejda.model.validation.constraint.NotEmpty;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

@SingleOutputAllowedExtensions
public class AttachmentsCollectionParameters
extends AbstractPdfOutputParameters
implements SingleOutputTaskParameters,
MultipleSourceTaskParameter {
    @NotNull
    private InitialView initialView = InitialView.TILES;
    @NotEmpty
    @Valid
    private final List<Source<?>> sourceList = new ArrayList();
    @Valid
    @NotNull
    private SingleTaskOutput output;

    public void addSources(Collection<? extends Source<?>> inputs) {
        this.sourceList.addAll(inputs);
    }

    @Override
    public void addSource(Source<?> input) {
        this.sourceList.add(input);
    }

    @Override
    public List<Source<?>> getSourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    public InitialView getInitialView() {
        return this.initialView;
    }

    public void setInitialView(InitialView initialView) {
        this.initialView = initialView;
    }

    @Override
    public SingleTaskOutput getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(SingleTaskOutput output) {
        this.output = output;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.initialView).append((Object)this.output).append(this.sourceList).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttachmentsCollectionParameters)) {
            return false;
        }
        AttachmentsCollectionParameters parameter = (AttachmentsCollectionParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.initialView, (Object)parameter.getInitialView()).append((Object)this.output, (Object)parameter.output).append(this.sourceList, parameter.getSourceList()).isEquals();
    }
}

