/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;

class Salt {
    private long salt;
    private static Salt instance = null;
    private static final LogAdapter logger = LogFactory.getLogger(Salt.class);

    protected Salt() {
        byte[] rnd = new byte[8];
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            sr.nextBytes(rnd);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.warn((Serializable)((Object)"Could not use SecureRandom. Using Random instead."));
            Random r = new Random();
            r.nextBytes(rnd);
        }
        this.salt = rnd[0];
        for (int i = 0; i < 7; ++i) {
            this.salt = this.salt * 256L + (long)rnd[i] + 128L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Initialized Salt to " + Long.toHexString(this.salt) + ".")));
        }
    }

    public static Salt getInstance() {
        if (instance == null) {
            instance = new Salt();
        }
        return instance;
    }

    public synchronized long getNext() {
        return this.salt++;
    }
}

