/*
 * Decompiled with CFR 0.152.
 */
package com.swiftype.appsearch;

import com.google.gson.reflect.TypeToken;
import com.swiftype.appsearch.ClientException;
import com.swiftype.appsearch.InvalidDocumentException;
import com.swiftype.appsearch.JsonTypes;
import com.swiftype.appsearch.Jwt;
import java.net.URI;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;

public class Client {
    private final String VERSION = "0.4.1";
    private final String baseUrl;
    private final String apiKey;

    public Client(String hostIdentifier, String apiKey) {
        this(hostIdentifier, apiKey, "https://%s.api.swiftype.com/api/as/v1/");
    }

    public Client(String hostIdentifier, String apiKey, String baseUrlFormatString) {
        this.baseUrl = String.format(baseUrlFormatString, hostIdentifier);
        this.apiKey = apiKey;
    }

    public Map<String, Object> search(String engineName, String query) throws ClientException {
        return this.search(engineName, query, Collections.emptyMap());
    }

    public Map<String, Object> search(String engineName, String query, Map<String, Object> options) throws ClientException {
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        reqBody.putAll(options);
        reqBody.put("query", query);
        return this.makeJsonRequest("GET", String.format("engines/%s/search", engineName), reqBody, JsonTypes.OBJECT);
    }

    public List<Map<String, Object>> multiSearch(String engineName, List<Map> queries) throws ClientException {
        HashMap<String, List<Map>> reqBody = new HashMap<String, List<Map>>();
        reqBody.put("queries", queries);
        return this.makeJsonRequest("POST", String.format("engines/%s/multi_search", engineName), reqBody, JsonTypes.ARRAY_OF_OBJECTS);
    }

    public Map<String, Object> querySuggestion(String engineName, String query) throws ClientException {
        return this.querySuggestion(engineName, query, Collections.emptyMap());
    }

    public Map<String, Object> querySuggestion(String engineName, String query, Map<String, Object> options) throws ClientException {
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        reqBody.putAll(options);
        reqBody.put("query", query);
        return this.makeJsonRequest("POST", String.format("engines/%s/query_suggestion", engineName), reqBody, JsonTypes.OBJECT);
    }

    public Map<String, Object> listEngines() throws ClientException {
        return this.listEngines(1, 20);
    }

    public Map<String, Object> listEngines(Integer current, Integer size) throws ClientException {
        HashMap<String, Integer> pageOptions = new HashMap<String, Integer>();
        pageOptions.put("current", current);
        pageOptions.put("size", size);
        HashMap<String, HashMap<String, Integer>> reqBody = new HashMap<String, HashMap<String, Integer>>();
        reqBody.put("page", pageOptions);
        return this.makeJsonRequest("GET", "engines", reqBody, JsonTypes.OBJECT);
    }

    public Map<String, Object> getEngine(String engineName) throws ClientException {
        return this.makeJsonRequest("GET", String.format("engines/%s", engineName), null, JsonTypes.OBJECT);
    }

    public Map<String, Object> createEngine(String engineName) throws ClientException {
        HashMap<String, String> reqBody = new HashMap<String, String>();
        reqBody.put("name", engineName);
        return this.makeJsonRequest("POST", "engines", reqBody, JsonTypes.OBJECT);
    }

    public Map<String, Boolean> destroyEngine(String engineName) throws ClientException {
        Map<String, Object> response = this.makeJsonRequest("DELETE", String.format("engines/%s", engineName), null, JsonTypes.OBJECT);
        HashMap<String, Boolean> convertedResponse = new HashMap<String, Boolean>();
        for (Map.Entry<String, Object> e : response.entrySet()) {
            convertedResponse.put(e.getKey(), (Boolean)e.getValue());
        }
        return convertedResponse;
    }

    public Map<String, Object> indexDocument(String engineName, Map<String, Object> document) throws ClientException {
        List<Map<String, Object>> documents = Arrays.asList(document);
        List<Map<String, Object>> response = this.indexDocuments(engineName, documents);
        Map<String, Object> documentIndexingStatus = response.get(0);
        List errors = (List)documentIndexingStatus.remove("errors");
        if (errors.size() > 0) {
            String errorMessage = String.format("Invalid document: %s", String.join((CharSequence)"; ", errors));
            throw new InvalidDocumentException(errorMessage);
        }
        return documentIndexingStatus;
    }

    public List<Map<String, Object>> indexDocuments(String engineName, List<Map<String, Object>> documents) throws ClientException {
        return this.makeJsonRequest("POST", String.format("engines/%s/documents", engineName), documents, JsonTypes.ARRAY_OF_OBJECTS);
    }

    public List<Map<String, Object>> getDocuments(String engineName, List<String> ids) throws ClientException {
        return this.makeJsonRequest("GET", String.format("engines/%s/documents", engineName), ids, JsonTypes.ARRAY_OF_OBJECTS);
    }

    public List<Map<String, Object>> destroyDocuments(String engineName, List<String> ids) throws ClientException {
        return this.makeJsonRequest("DELETE", String.format("engines/%s/documents", engineName), ids, JsonTypes.ARRAY_OF_OBJECTS);
    }

    public static String createSignedSearchKey(String apiKey, String apiKeyName, Map<String, Object> options) throws InvalidKeyException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.putAll(options);
        payload.put("api_key_name", apiKeyName);
        return Jwt.sign(apiKey, payload);
    }

    /*
     * Exception decompiling
     */
    <T> T makeJsonRequest(String httpMethod, String path, Object body, TypeToken<T> resultType) throws ClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String baseUrl() {
        return this.baseUrl;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static class HttpDynamicRequestWithBody
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        public HttpDynamicRequestWithBody(String method, String uri) {
            this.method = method;
            this.setURI(URI.create(uri));
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }
}

