"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var readdir = require("@mrmlnc/readdir-enhanced");
var reader_1 = require("./reader");
var ReaderSync = /** @class */ (function (_super) {
    __extends(ReaderSync, _super);
    function ReaderSync() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Returns founded paths.
     */
    ReaderSync.prototype.api = function (root, options) {
        return readdir.readdirSyncStat(root, options);
    };
    /**
     * Use sync API to read entries for Task.
     */
    ReaderSync.prototype.read = function (task) {
        var root = this.getRootDirectory(task);
        var options = this.getReaderOptions(task);
        try {
            var entries = this.api(root, options);
            return entries.map(this.transform, this);
        }
        catch (err) {
            if (this.isEnoentCodeError(err)) {
                return [];
            }
            throw err;
        }
    };
    return ReaderSync;
}(reader_1.default));
exports.default = ReaderSync;
