"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var interactions_1 = require("../utils/interactions");
var rendering_1 = require("../rendering/rendering");
var series_1 = require("../utils/series");
var utils_1 = require("../store/utils");
function getSeriesTooltipValues(tooltipValues, defaultValue) {
    // map from seriesKey to tooltipValue
    var seriesTooltipValues = new Map();
    // First tooltipValue is the header
    if (tooltipValues.length <= 1) {
        return seriesTooltipValues;
    }
    tooltipValues.slice(1).forEach(function (tooltipValue) {
        var seriesKey = tooltipValue.seriesKey, value = tooltipValue.value;
        seriesTooltipValues.set(seriesKey, defaultValue ? defaultValue : value);
    });
    return seriesTooltipValues;
}
exports.getSeriesTooltipValues = getSeriesTooltipValues;
function formatTooltip(searchIndexValue, spec, isXValue, isHighlighted, axisSpec) {
    var id = spec.id;
    var color = searchIndexValue.color, _a = searchIndexValue.value, x = _a.x, y = _a.y, accessor = _a.accessor, seriesKey = searchIndexValue.geometryId.seriesKey;
    var seriesKeyAsString = series_1.getColorValuesAsString(seriesKey, id);
    var name;
    if (seriesKey.length > 0) {
        name = seriesKey.join(' - ');
    }
    else {
        name = spec.name || "" + spec.id;
    }
    var value = isXValue ? x : y;
    return {
        seriesKey: seriesKeyAsString,
        name: name,
        value: axisSpec ? axisSpec.tickFormat(value) : emptyFormatter(value),
        color: color,
        isHighlighted: isXValue ? false : isHighlighted,
        isXValue: isXValue,
        yAccessor: accessor,
    };
}
exports.formatTooltip = formatTooltip;
function emptyFormatter(value) {
    return value;
}
function getTooltipAndHighlightFromXValue(axisCursorPosition, seriesSpecs, axesSpecs, geometriesIndex, xValue, isActiveChart, tooltipType, chartRotation, yScales, tooltipHeaderFormatter) {
    // get the elements on at this cursor position
    var elements = geometriesIndex.get(xValue.value);
    // if no element, hide everything
    if (!elements || elements.length === 0) {
        return;
    }
    // build the tooltip value list
    var xValueInfo = null;
    var highlightedGeometries = [];
    var tooltipData = elements.reduce(function (acc, indexedGeometry) {
        var specId = indexedGeometry.geometryId.specId;
        var spec = seriesSpecs.get(specId);
        // safe guard check
        if (!spec) {
            return acc;
        }
        var _a = utils_1.getAxesSpecForSpecId(axesSpecs, spec.groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
        // yScales is ensured by the enclosing if
        var yScale = yScales.get(spec.groupId);
        if (!yScale) {
            return acc;
        }
        // check if the pointer is on the geometry
        var isHighlighted = false;
        if (isActiveChart && rendering_1.isPointOnGeometry(axisCursorPosition.x, axisCursorPosition.y, indexedGeometry)) {
            isHighlighted = true;
            highlightedGeometries.push(indexedGeometry);
        }
        // if it's a follow tooltip, and no element is highlighted
        // not add that element into the tooltip list
        if (!isHighlighted && interactions_1.isFollowTooltipType(tooltipType)) {
            return acc;
        }
        // format the tooltip values
        var yAxisFormatSpec = [0, 180].includes(chartRotation) ? yAxis : xAxis;
        var formattedTooltip = formatTooltip(indexedGeometry, spec, false, isHighlighted, yAxisFormatSpec);
        // format only one time the x value
        if (!xValueInfo) {
            // if we have a tooltipHeaderFormatter, then don't pass in the xAxis as the user will define a formatter
            var xAxisFormatSpec = [0, 180].includes(chartRotation) ? xAxis : yAxis;
            var formatterAxis = tooltipHeaderFormatter ? undefined : xAxisFormatSpec;
            xValueInfo = formatTooltip(indexedGeometry, spec, true, false, formatterAxis);
            return __spread([xValueInfo], acc, [formattedTooltip]);
        }
        return __spread(acc, [formattedTooltip]);
    }, []);
    return {
        tooltipData: tooltipData,
        highlightedGeometries: highlightedGeometries,
    };
}
exports.getTooltipAndHighlightFromXValue = getTooltipAndHighlightFromXValue;
//# sourceMappingURL=tooltip.js.map