"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../store/utils");
exports.DEFAULT_SNAP_POSITION_BAND = 1;
function getSnapPosition(value, scale, totalBarsInCluster) {
    if (totalBarsInCluster === void 0) { totalBarsInCluster = 1; }
    var position = scale.scale(value);
    if (position === undefined) {
        return;
    }
    if (scale.bandwidth > 0) {
        var band = scale.bandwidth / (1 - scale.barsPadding);
        var halfPadding = (band - scale.bandwidth) / 2;
        return {
            position: position - halfPadding * totalBarsInCluster,
            band: band * totalBarsInCluster,
        };
    }
    else {
        return {
            position: position,
            band: exports.DEFAULT_SNAP_POSITION_BAND,
        };
    }
}
exports.getSnapPosition = getSnapPosition;
function getCursorLinePosition(chartRotation, chartDimensions, cursorPosition) {
    var left = chartDimensions.left, top = chartDimensions.top, width = chartDimensions.width, height = chartDimensions.height;
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    if (isHorizontalRotated) {
        var crosshairTop = cursorPosition.y + top;
        return {
            left: left,
            width: width,
            top: crosshairTop,
            height: 0,
        };
    }
    else {
        var crosshairLeft = cursorPosition.x + left;
        return {
            top: top,
            left: crosshairLeft,
            width: 0,
            height: height,
        };
    }
}
exports.getCursorLinePosition = getCursorLinePosition;
function getCursorBandPosition(chartRotation, chartDimensions, cursorPosition, invertedValue, snapEnabled, xScale, totalBarsInCluster) {
    var top = chartDimensions.top, left = chartDimensions.left, width = chartDimensions.width, height = chartDimensions.height;
    var x = cursorPosition.x, y = cursorPosition.y;
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    var chartWidth = isHorizontalRotated ? width : height;
    var chartHeight = isHorizontalRotated ? height : width;
    if (x > chartWidth || y > chartHeight || x < 0 || y < 0 || !invertedValue.withinBandwidth) {
        return {
            top: -1,
            left: -1,
            width: 0,
            height: 0,
            visible: false,
        };
    }
    var snappedPosition = getSnapPosition(invertedValue.value, xScale, totalBarsInCluster);
    if (!snappedPosition) {
        return {
            top: -1,
            left: -1,
            width: 0,
            height: 0,
            visible: false,
        };
    }
    var position = snappedPosition.position, band = snappedPosition.band;
    var bandOffset = xScale.bandwidth > 0 ? band : 0;
    if (isHorizontalRotated) {
        var adjustedLeft = snapEnabled ? position : cursorPosition.x;
        var leftPosition = chartRotation === 0 ? left + adjustedLeft : left + width - adjustedLeft - bandOffset;
        var adjustedWidth = band;
        if (band > 1 && leftPosition + band > left + width) {
            adjustedWidth = left + width - leftPosition;
        }
        else if (band > 1 && leftPosition < left) {
            adjustedWidth = band - (left - leftPosition);
            leftPosition = left;
        }
        return {
            top: top,
            left: leftPosition,
            width: adjustedWidth,
            height: height,
            visible: true,
        };
    }
    else {
        var adjustedTop = snapEnabled ? position : cursorPosition.x;
        var topPosition = chartRotation === 90 ? top + adjustedTop : height + top - adjustedTop - bandOffset;
        var adjustedHeight = band;
        if (band > 1 && topPosition + band > top + height) {
            adjustedHeight = band - (topPosition + band - (top + height));
        }
        else if (band > 1 && topPosition < top) {
            adjustedHeight = band - (top - topPosition);
            topPosition = top;
        }
        return {
            top: topPosition,
            left: left,
            width: width,
            height: adjustedHeight,
            visible: true,
        };
    }
}
exports.getCursorBandPosition = getCursorBandPosition;
function getTooltipPosition(chartDimensions, chartRotation, cursorBandPosition, cursorPosition, isSingleValueXScale) {
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    var hPosition = getHorizontalTooltipPosition(cursorPosition.x, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale);
    var vPosition = getVerticalTooltipPosition(cursorPosition.y, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale);
    var xTranslation = "translateX(" + hPosition.position + "px) translateX(-" + hPosition.offset + "%)";
    var yTranslation = "translateY(" + vPosition.position + "px) translateY(-" + vPosition.offset + "%)";
    return xTranslation + " " + yTranslation;
}
exports.getTooltipPosition = getTooltipPosition;
function getHorizontalTooltipPosition(cursorXPosition, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale, padding) {
    if (padding === void 0) { padding = 20; }
    if (isHorizontalRotated) {
        if (isSingleValueXScale) {
            return {
                offset: 0,
                position: cursorBandPosition.left,
            };
        }
        if (cursorXPosition <= chartDimensions.width / 2) {
            return {
                offset: 0,
                position: cursorBandPosition.left + cursorBandPosition.width + padding,
            };
        }
        else {
            return {
                offset: 100,
                position: cursorBandPosition.left - padding,
            };
        }
    }
    else {
        if (cursorXPosition <= chartDimensions.width / 2) {
            return {
                offset: 0,
                position: chartDimensions.left + cursorXPosition,
            };
        }
        else {
            return {
                offset: 100,
                position: chartDimensions.left + cursorXPosition,
            };
        }
    }
}
exports.getHorizontalTooltipPosition = getHorizontalTooltipPosition;
function getVerticalTooltipPosition(cursorYPosition, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale, padding) {
    if (padding === void 0) { padding = 20; }
    if (isHorizontalRotated) {
        if (cursorYPosition <= chartDimensions.height / 2) {
            return {
                offset: 0,
                position: cursorYPosition + chartDimensions.top,
            };
        }
        else {
            return {
                offset: 100,
                position: cursorYPosition + chartDimensions.top,
            };
        }
    }
    else {
        if (isSingleValueXScale) {
            return {
                offset: 0,
                position: cursorBandPosition.top,
            };
        }
        if (cursorYPosition <= chartDimensions.height / 2) {
            return {
                offset: 0,
                position: cursorBandPosition.top + cursorBandPosition.height + padding,
            };
        }
        else {
            return {
                offset: 100,
                position: cursorBandPosition.top - padding,
            };
        }
    }
}
exports.getVerticalTooltipPosition = getVerticalTooltipPosition;
//# sourceMappingURL=crosshair_utils.js.map