/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import org.jboss.as.clustering.infinispan.subsystem.StoreServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.infinispan.client.InfinispanClientRequirement;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class HotRodStoreServiceConfigurator
extends StoreServiceConfigurator<HotRodStoreConfiguration, HotRodStoreConfigurationBuilder> {
    private volatile SupplierDependency<RemoteCacheContainer> remoteCacheContainer;
    private volatile String cacheConfiguration;

    HotRodStoreServiceConfigurator(PathAddress address) {
        super(address, HotRodStoreConfigurationBuilder.class);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.cacheConfiguration = HotRodStoreResourceDefinition.Attribute.CACHE_CONFIGURATION.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        String remoteCacheContainerName = HotRodStoreResourceDefinition.Attribute.REMOTE_CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.remoteCacheContainer = new ServiceSupplierDependency(InfinispanClientRequirement.REMOTE_CONTAINER.getServiceName(context, remoteCacheContainerName));
        return super.configure(context, model);
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(this.remoteCacheContainer.register(builder));
    }

    @Override
    public void accept(HotRodStoreConfigurationBuilder builder) {
        builder.cacheConfiguration(this.cacheConfiguration).remoteCacheContainer((RemoteCacheContainer)this.remoteCacheContainer.get());
    }
}

