/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.OriginTrackedMetadata;
import io.smallrye.metrics.interceptors.MetricName;
import java.util.SortedMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MetricProducer {
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry applicationRegistry;
    @Inject
    private MetricName metricName;

    @Produces
    <T> Gauge<T> getGauge(InjectionPoint ip) {
        return () -> {
            SortedMap gauges = this.applicationRegistry.getGauges();
            String name = this.metricName.of(ip);
            return ((Gauge)gauges.get(name)).getValue();
        };
    }

    @Produces
    Counter getCounter(InjectionPoint ip) {
        return this.applicationRegistry.counter(this.getMetadata(ip, MetricType.COUNTER));
    }

    @Produces
    Histogram getHistogram(InjectionPoint ip) {
        return this.applicationRegistry.histogram(this.getMetadata(ip, MetricType.HISTOGRAM));
    }

    @Produces
    Meter getMeter(InjectionPoint ip) {
        return this.applicationRegistry.meter(this.getMetadata(ip, MetricType.METERED));
    }

    @Produces
    Timer getTimer(InjectionPoint ip) {
        return this.applicationRegistry.timer(this.getMetadata(ip, MetricType.TIMER));
    }

    private Metadata getMetadata(InjectionPoint ip, MetricType type) {
        OriginTrackedMetadata metadata = new OriginTrackedMetadata(ip, this.metricName.of(ip), type);
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null) {
            if (!metric.unit().isEmpty()) {
                metadata.setUnit(metric.unit());
            }
            if (!metric.description().isEmpty()) {
                metadata.setDescription(metric.description());
            }
            if (!metric.displayName().isEmpty()) {
                metadata.setDisplayName(metric.displayName());
            }
            if (metric.tags().length > 0) {
                for (String tag : metric.tags()) {
                    metadata.addTags(tag);
                }
            }
        }
        return metadata;
    }
}

