#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-term
version: 1.4.1
id: tamarin-prover-term-1.4.1-F2mCbNyHqb5DXr8EUeY1r6
key: tamarin-prover-term-1.4.1-F2mCbNyHqb5DXr8EUeY1r6
license: LicenseRef-GPL
copyright: Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018
maintainer: Simon Meier <simon.meier@inf.ethz.ch>,
            Jannik Dreier <research@jannikdreier.net>,
            Ralf Sasse <ralf.sasse@gmail.com>
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>,
        Jannik Dreier <research@jannikdreier.net>,
        Ralf Sasse <ralf.sasse@gmail.com>
homepage: https://tamarin-prover.github.io/
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.
category: Theorem Provers
abi: 71ad2ca2810e91700692c0a537d94526
exposed: True
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm
hidden-modules: Term.Term Term.Term.Classes Term.Term.Raw
                Term.Term.FunctionSymbols Term.Narrowing.Narrow
                Term.Substitution.SubstVFree Term.Substitution.SubstVFresh
import-dirs: /usr/lib/ghc-8.6.5/site-local/tamarin-prover-term-1.4.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/tamarin-prover-term-1.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/tamarin-prover-term-1.4.1
hs-libraries: HStamarin-prover-term-1.4.1-F2mCbNyHqb5DXr8EUeY1r6
depends:
    HUnit-1.6.0.0-JbqplLUCHWj8gC9WuQWK9
    attoparsec-0.13.2.3-C8ToaI6DNPR6ujzYigEqDi base-4.12.0.0
    binary-0.8.6.0 bytestring-0.10.8.2 containers-0.6.0.1
    deepseq-1.4.4.0 dlist-0.8.0.7-4YlHXedX3EE3dGnI3L89Bl mtl-2.2.2
    process-1.6.5.0 safe-0.3.17-43oyx4B630gDZMbTh3Ttji
    tamarin-prover-utils-1.4.1-7HSvS1Tg6Gz8e2s0bGIbCk
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

