# Copyright (c) 2014-2016 Cedric Bellegarde <cedric.bellegarde@adishatz.org>
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

import sys
# Make sure we'll find the pygobject module, even in JHBuild
sys.path.insert(1, '/usr/lib/python3.7')
# Make sure we'll find the eolie modules, even in JHBuild
sys.path.insert(1, '/usr/lib/python3.7/site-packages')

from gi.repository import Gio

from eolie.extension_forms import FormsExtension
from eolie.extension_adblock import AdblockExtension
from eolie.extension_jsblock import JSblockExtension
from eolie.extension_proxy import ProxyExtension
from eolie.database_adblock import DatabaseAdblock
from eolie.database_exceptions import DatabaseExceptions
from eolie.settings import Settings


class Application(Gio.Application):
    def new():
        """
            Return a new application object
        """
        app = Gio.Application.new(None, Gio.ApplicationFlags.IS_SERVICE)
        app.__class__ = Application
        app.cursors = {}
        app.settings = Settings.new()
        app.adblock = DatabaseAdblock()
        app.adblock_exceptions = DatabaseExceptions("adblock")
        app.js_exceptions = DatabaseExceptions("js")
        return app


app = Application.new()


def initialize(extension, arguments):
    """
        Connect to page created
        @param extension as WebKit2WebExtension.WebExtension
    """
    AdblockExtension(extension)
    jsblock = JSblockExtension(extension)
    forms = FormsExtension(extension)
    ProxyExtension(extension, forms, jsblock)
