/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.MovFnPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class MovFnPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<MovFnPipelineAggregationBuilder> {
    public static final String NAME = "moving_fn";
    private static final ParseField WINDOW = new ParseField("window", new String[0]);
    private static final ParseField SHIFT = new ParseField("shift", new String[0]);
    private final Script script;
    private final String bucketsPathString;
    private String format = null;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    private int window;
    private int shift;
    private static final Function<String, ConstructingObjectParser<MovFnPipelineAggregationBuilder, Void>> PARSER = name -> {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, false, o -> new MovFnPipelineAggregationBuilder((String)name, (String)o[0], (Script)o[1], (Integer)o[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> Script.parse(p), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        parser.declareInt(ConstructingObjectParser.constructorArg(), WINDOW);
        parser.declareInt(MovFnPipelineAggregationBuilder::setShift, SHIFT);
        parser.declareString(MovFnPipelineAggregationBuilder::format, PipelineAggregator.Parser.FORMAT);
        parser.declareField(MovFnPipelineAggregationBuilder::gapPolicy, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return BucketHelpers.GapPolicy.parse(p.text().toLowerCase(Locale.ROOT), p.getTokenLocation());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, PipelineAggregator.Parser.GAP_POLICY, ObjectParser.ValueType.STRING);
        return parser;
    };

    public MovFnPipelineAggregationBuilder(String name, String bucketsPath, Script script, int window) {
        super(name, NAME, new String[]{bucketsPath});
        this.bucketsPathString = bucketsPath;
        this.script = script;
        if (window <= 0) {
            throw new IllegalArgumentException("[" + WINDOW.getPreferredName() + "] must be a positive, non-zero integer.");
        }
        this.window = window;
    }

    public MovFnPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.bucketsPathString = in.readString();
        this.script = new Script(in);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.window = in.readInt();
        this.shift = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readInt() : 0;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.bucketsPathString);
        this.script.writeTo(out);
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
        out.writeInt(this.window);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeInt(this.shift);
        }
    }

    public MovFnPipelineAggregationBuilder format(String format) {
        if (Strings.isNullOrEmpty(format)) {
            throw new IllegalArgumentException("[" + PipelineAggregator.Parser.FORMAT.getPreferredName() + "] must not be null or an empty string.");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    public MovFnPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[" + PipelineAggregator.Parser.GAP_POLICY.getPreferredName() + "] must not be null.");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int window) {
        if (window <= 0) {
            throw new IllegalArgumentException("[" + WINDOW.getPreferredName() + "] must be a positive, non-zero integer.");
        }
        this.window = window;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    @Override
    public void doValidate(AggregatorFactory parent, Collection<AggregationBuilder> aggFactories, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
        if (this.window <= 0) {
            throw new IllegalArgumentException("[" + WINDOW.getPreferredName() + "] must be a positive, non-zero integer.");
        }
        MovFnPipelineAggregationBuilder.validateSequentiallyOrderedParentAggs(parent, NAME, this.name);
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) {
        return new MovFnPipelineAggregator(this.name, this.bucketsPathString, this.script, this.window, this.shift, this.formatter(), this.gapPolicy, metaData);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName(), this.bucketsPathString);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), (ToXContent)this.script);
        if (this.format != null) {
            builder.field(PipelineAggregator.Parser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(PipelineAggregator.Parser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        builder.field(WINDOW.getPreferredName(), this.window);
        builder.field(SHIFT.getPreferredName(), this.shift);
        return builder;
    }

    public static MovFnPipelineAggregationBuilder parse(String aggName, XContentParser parser) {
        return (MovFnPipelineAggregationBuilder)PARSER.apply(aggName).apply(parser, null);
    }

    static MovFnPipelineAggregationBuilder parse(XContentParser parser) throws IOException {
        parser.nextToken();
        if (parser.currentToken().equals((Object)XContentParser.Token.START_OBJECT)) {
            parser.nextToken();
            if (parser.currentToken().equals((Object)XContentParser.Token.FIELD_NAME)) {
                String aggName = parser.currentName();
                parser.nextToken();
                parser.nextToken();
                return (MovFnPipelineAggregationBuilder)PARSER.apply(aggName).apply(parser, null);
            }
        }
        throw new IllegalStateException("Expected aggregation name but none found");
    }

    @Override
    protected boolean overrideBucketsPath() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketsPathString, this.script, this.format, this.gapPolicy, this.window, this.shift);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MovFnPipelineAggregationBuilder other = (MovFnPipelineAggregationBuilder)obj;
        return Objects.equals(this.bucketsPathString, other.bucketsPathString) && Objects.equals(this.script, other.script) && Objects.equals(this.format, other.format) && Objects.equals(this.gapPolicy, other.gapPolicy) && Objects.equals(this.window, other.window) && Objects.equals(this.shift, other.shift);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

