/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.node.AStatement;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Method;

public final class SFunction
extends AStatement {
    private final String rtnTypeStr;
    public final String name;
    private final List<String> paramTypeStrs;
    private final List<String> paramNameStrs;
    private final List<AStatement> statements;
    public final boolean synthetic;
    private CompilerSettings settings;
    Class<?> returnType;
    List<Class<?>> typeParameters;
    MethodType methodType;
    Method method;
    List<Locals.Parameter> parameters = new ArrayList<Locals.Parameter>();
    private Locals.Variable loop = null;

    public SFunction(Location location, String rtnType, String name, List<String> paramTypes, List<String> paramNames, List<AStatement> statements, boolean synthetic) {
        super(location);
        this.rtnTypeStr = Objects.requireNonNull(rtnType);
        this.name = Objects.requireNonNull(name);
        this.paramTypeStrs = Collections.unmodifiableList(paramTypes);
        this.paramNameStrs = Collections.unmodifiableList(paramNames);
        this.statements = Collections.unmodifiableList(statements);
        this.synthetic = synthetic;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        for (AStatement statement : this.statements) {
            statement.storeSettings(settings);
        }
        this.settings = settings;
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AStatement statement : this.statements) {
            statement.extractVariables(new HashSet<String>());
        }
    }

    void generateSignature(PainlessLookup painlessLookup) {
        this.returnType = painlessLookup.canonicalTypeNameToType(this.rtnTypeStr);
        if (this.returnType == null) {
            throw this.createError(new IllegalArgumentException("Illegal return type [" + this.rtnTypeStr + "] for function [" + this.name + "]."));
        }
        if (this.paramTypeStrs.size() != this.paramNameStrs.size()) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        Class[] paramClasses = new Class[this.paramTypeStrs.size()];
        ArrayList paramTypes = new ArrayList();
        for (int param = 0; param < this.paramTypeStrs.size(); ++param) {
            Class<?> paramType = painlessLookup.canonicalTypeNameToType(this.paramTypeStrs.get(param));
            if (paramType == null) {
                throw this.createError(new IllegalArgumentException("Illegal parameter type [" + this.paramTypeStrs.get(param) + "] for function [" + this.name + "]."));
            }
            paramClasses[param] = PainlessLookupUtility.typeToJavaType(paramType);
            paramTypes.add(paramType);
            this.parameters.add(new Locals.Parameter(this.location, this.paramNameStrs.get(param), paramType));
        }
        this.typeParameters = paramTypes;
        this.methodType = MethodType.methodType(PainlessLookupUtility.typeToJavaType(this.returnType), paramClasses);
        this.method = new Method(this.name, MethodType.methodType(PainlessLookupUtility.typeToJavaType(this.returnType), paramClasses).toMethodDescriptorString());
    }

    @Override
    void analyze(Locals locals) {
        if (this.statements == null || this.statements.isEmpty()) {
            throw this.createError(new IllegalArgumentException("Cannot generate an empty function [" + this.name + "]."));
        }
        locals = Locals.newLocalScope(locals);
        AStatement last = this.statements.get(this.statements.size() - 1);
        for (AStatement statement : this.statements) {
            if (this.allEscape) {
                throw this.createError(new IllegalArgumentException("Unreachable statement."));
            }
            statement.lastSource = statement == last;
            statement.analyze(locals);
            this.methodEscape = statement.methodEscape;
            this.allEscape = statement.allEscape;
        }
        if (!this.methodEscape && this.returnType != Void.TYPE) {
            throw this.createError(new IllegalArgumentException("Not all paths provide a return value for method [" + this.name + "]."));
        }
        if (this.settings.getMaxLoopCounter() > 0) {
            this.loop = locals.getVariable(null, "#loop");
        }
    }

    void write(ClassVisitor writer, CompilerSettings settings, Globals globals) {
        int access = 9;
        if (this.synthetic) {
            access |= 0x1000;
        }
        MethodWriter function = new MethodWriter(access, this.method, writer, globals.getStatements(), settings);
        function.visitCode();
        this.write(function, globals);
        function.endMethod();
    }

    @Override
    void write(MethodWriter function, Globals globals) {
        if (this.settings.getMaxLoopCounter() > 0) {
            function.push(this.settings.getMaxLoopCounter());
            function.visitVarInsn(54, this.loop.getSlot());
        }
        for (AStatement statement : this.statements) {
            statement.write(function, globals);
        }
        if (!this.methodEscape) {
            if (this.returnType == Void.TYPE) {
                function.returnValue();
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    @Override
    public String toString() {
        ArrayList<String> description = new ArrayList<String>();
        description.add(this.rtnTypeStr);
        description.add(this.name);
        if (!(this.paramTypeStrs.isEmpty() && this.paramNameStrs.isEmpty())) {
            description.add(this.joinWithName("Args", this.pairwiseToString(this.paramTypeStrs, this.paramNameStrs), Collections.emptyList()));
        }
        return this.multilineToString(description, this.statements);
    }
}

