/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.css;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.internal.css.RGBColorImpl;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.core.theme.css.CSSStyle;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

public class CSSDocumentHandler
implements DocumentHandler {
    private final List<IStyle> list = new ArrayList<IStyle>();
    private CSSStyle currentStyle;

    public void comment(String arg0) throws CSSException {
    }

    public void endDocument(InputSource arg0) throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void endMedia(SACMediaList arg0) throws CSSException {
    }

    public void endPage(String arg0, String arg1) throws CSSException {
    }

    public void endSelector(SelectorList selector) throws CSSException {
        this.currentStyle = null;
    }

    public void ignorableAtRule(String arg0) throws CSSException {
    }

    public void importStyle(String arg0, SACMediaList arg1, String arg2) throws CSSException {
    }

    public void namespaceDeclaration(String arg0, String arg1) throws CSSException {
    }

    public void property(String name, LexicalUnit value, boolean arg2) throws CSSException {
        if (this.currentStyle != null) {
            if ("color".equals(name)) {
                this.currentStyle.setColor(this.createRGB(value));
            } else if ("background-color".equals(name)) {
                this.currentStyle.setBackgroundColor(this.createRGB(value));
            } else if ("font-weight".equals(name)) {
                this.currentStyle.setBold(value.getStringValue().toUpperCase().contains("BOLD"));
            } else if ("font-style".equals(name)) {
                this.currentStyle.setItalic(value.getStringValue().toUpperCase().contains("ITALIC"));
            }
            if ("text-decoration".equals(name)) {
                String decoration = value.getStringValue().toUpperCase();
                if (decoration.contains("UNDERLINE")) {
                    this.currentStyle.setUnderline(true);
                }
                if (decoration.contains("LINE-THROUGH")) {
                    this.currentStyle.setStrikeThrough(true);
                }
            }
        }
    }

    private RGB createRGB(LexicalUnit value) {
        RGBColorImpl rgbColor = new RGBColorImpl(value);
        int green = (int)rgbColor.getGreen().getFloatValue((short)1);
        int red = (int)rgbColor.getRed().getFloatValue((short)1);
        int blue = (int)rgbColor.getBlue().getFloatValue((short)1);
        return new RGB(red, green, blue);
    }

    public void startDocument(InputSource arg0) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void startMedia(SACMediaList arg0) throws CSSException {
    }

    public void startPage(String arg0, String arg1) throws CSSException {
    }

    public void startSelector(SelectorList selector) throws CSSException {
        this.currentStyle = new CSSStyle(selector);
        this.list.add(this.currentStyle);
    }

    public List<IStyle> getList() {
        return this.list;
    }
}

