/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class HTMLPrinter {
    private HTMLPrinter() {
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    public static String convertToHTMLContent(String content) {
        content = HTMLPrinter.replace(content, '<', "&lt;");
        return HTMLPrinter.replace(content, '>', "&gt;");
    }

    public static String read(Reader rd) {
        StringBuffer buffer = new StringBuffer();
        char[] readBuffer = new char[2048];
        try {
            int n = rd.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = rd.read(readBuffer);
            }
            return buffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuffer buffer, int position, RGB bgRGB) {
        if (bgRGB == null) {
            HTMLPrinter.insertPageProlog(buffer, position);
        } else {
            StringBuffer pageProlog = new StringBuffer(60);
            pageProlog.append("<html><body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(pageProlog, bgRGB);
            pageProlog.append("\"><font size=-1>");
            buffer.insert(position, pageProlog.toString());
        }
    }

    private static void appendColor(StringBuffer buffer, RGB rgb) {
        buffer.append('#');
        buffer.append(Integer.toHexString(rgb.red));
        buffer.append(Integer.toHexString(rgb.green));
        buffer.append(Integer.toHexString(rgb.blue));
    }

    public static void insertPageProlog(StringBuffer buffer, int position) {
        Display display;
        RGB bgColor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (display = window.getShell().getDisplay()) != null && !display.isDisposed()) {
            bgColor = display.getSystemColor(29).getRGB();
        }
        if (bgColor == null) {
            bgColor = new RGB(255, 255, 225);
        }
        HTMLPrinter.insertPageProlog(buffer, position, bgColor);
    }

    public static void addPageProlog(StringBuffer buffer) {
        HTMLPrinter.insertPageProlog(buffer, buffer.length());
    }

    public static void addPageEpilog(StringBuffer buffer) {
        buffer.append("</font></body></html>");
    }

    public static void startBulletList(StringBuffer buffer) {
        buffer.append("<ul>");
    }

    public static void endBulletList(StringBuffer buffer) {
        buffer.append("</ul>");
    }

    public static void addBullet(StringBuffer buffer, String bullet) {
        if (bullet != null) {
            buffer.append("<li>");
            buffer.append(bullet);
            buffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuffer buffer, String header) {
        if (header != null) {
            buffer.append("<h5>");
            buffer.append(header);
            buffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuffer buffer, String paragraph) {
        if (paragraph != null) {
            buffer.append("<p>");
            buffer.append(paragraph);
        }
    }

    public static void addParagraph(StringBuffer buffer, Reader paragraphReader) {
        if (paragraphReader != null) {
            HTMLPrinter.addParagraph(buffer, HTMLPrinter.read(paragraphReader));
        }
    }
}

