/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core.commands;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.commands.AbstractRemoteCommand;

public class FetchInfoCommand
extends AbstractRemoteCommand<IFileInfo> {
    private final IPath fRemotePath;

    public FetchInfoCommand(JSchConnection connection, IPath path) {
        super(connection);
        this.fRemotePath = path;
    }

    @Override
    public IFileInfo getResult(IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        AbstractRemoteCommand.SftpCallable<SftpATTRS> c = new AbstractRemoteCommand.SftpCallable<SftpATTRS>((AbstractRemoteCommand)this){

            @Override
            public SftpATTRS call() throws JSchException, SftpException {
                return this.getChannel().lstat(FetchInfoCommand.this.fRemotePath.toString());
            }
        };
        try {
            SftpATTRS attrs = (SftpATTRS)c.getResult((IProgressMonitor)subMon.newChild(10));
            return this.convertToFileInfo(this.fRemotePath, attrs, (IProgressMonitor)subMon.newChild(10));
        }
        catch (SftpException e) {
            if (e.id == 2) {
                FileInfo info = new FileInfo(this.fRemotePath.lastSegment());
                info.setExists(false);
                return info;
            }
            throw new RemoteConnectionException(e.getMessage());
        }
    }
}

