/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IStringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.wst.jsdt.internal.compiler.impl.StringConstant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal
implements IStringLiteral {
    char[] source;
    int lineNumber;

    public StringLiteral(char[] token, int start, int end, int lineNumber) {
        this(start, end);
        this.source = token;
        this.lineNumber = lineNumber - 1;
    }

    public StringLiteral(int s, int e) {
        super(s, e);
    }

    @Override
    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(StringLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral lit) {
        return new StringLiteralConcatenation(this, lit);
    }

    @Override
    public TypeBinding literalType(BlockScope scope) {
        return scope.getJavaLangString();
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('\"');
        int i = 0;
        while (i < this.source.length) {
            switch (this.source[i]) {
                case '\b': {
                    output.append("\\b");
                    break;
                }
                case '\t': {
                    output.append("\\t");
                    break;
                }
                case '\n': {
                    output.append("\\n");
                    break;
                }
                case '\f': {
                    output.append("\\f");
                    break;
                }
                case '\r': {
                    output.append("\\r");
                    break;
                }
                case '\"': {
                    output.append("\\\"");
                    break;
                }
                case '\'': {
                    output.append("\\'");
                    break;
                }
                case '\\': {
                    output.append("\\\\");
                    break;
                }
                default: {
                    output.append(this.source[i]);
                }
            }
            ++i;
        }
        output.append('\"');
        return output;
    }

    @Override
    public char[] source() {
        return this.source;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 98;
    }
}

