/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.submodule;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;

public class SubmoduleWalk
implements AutoCloseable {
    private final Repository repository;
    private final TreeWalk walk;
    private StoredConfig repoConfig;
    private AbstractTreeIterator rootTree;
    private Config modulesConfig;
    private String path;
    private Map<String, String> pathToName;

    public static SubmoduleWalk forIndex(Repository repository) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            DirCache index2 = repository.readDirCache();
            generator.setTree(new DirCacheIterator(index2));
        }
        catch (IOException e2) {
            generator.close();
            throw e2;
        }
        return generator;
    }

    public static SubmoduleWalk forPath(Repository repository, AnyObjectId treeId, String path2) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            generator.setTree(treeId);
            PathFilter filter2 = PathFilter.create(path2);
            generator.setFilter(filter2);
            generator.setRootTree(treeId);
            while (generator.next()) {
                if (!filter2.isDone(generator.walk)) continue;
                return generator;
            }
        }
        catch (IOException e2) {
            generator.close();
            throw e2;
        }
        generator.close();
        return null;
    }

    public static SubmoduleWalk forPath(Repository repository, AbstractTreeIterator iterator, String path2) throws IOException {
        SubmoduleWalk generator = new SubmoduleWalk(repository);
        try {
            generator.setTree(iterator);
            PathFilter filter2 = PathFilter.create(path2);
            generator.setFilter(filter2);
            generator.setRootTree(iterator);
            while (generator.next()) {
                if (!filter2.isDone(generator.walk)) continue;
                return generator;
            }
        }
        catch (IOException e2) {
            generator.close();
            throw e2;
        }
        generator.close();
        return null;
    }

    public static File getSubmoduleDirectory(Repository parent, String path2) {
        return new File(parent.getWorkTree(), path2);
    }

    public static Repository getSubmoduleRepository(Repository parent, String path2) throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(parent.getWorkTree(), path2, parent.getFS());
    }

    public static Repository getSubmoduleRepository(File parent, String path2) throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(parent, path2, FS.DETECTED);
    }

    public static Repository getSubmoduleRepository(File parent, String path2, FS fs) throws IOException {
        File subWorkTree = new File(parent, path2);
        if (!subWorkTree.isDirectory()) {
            return null;
        }
        File workTree = new File(parent, path2);
        try {
            return ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setMustExist(true)).setFS(fs)).setWorkTree(workTree)).build();
        }
        catch (RepositoryNotFoundException e2) {
            return null;
        }
    }

    public static String getSubmoduleRemoteUrl(Repository parent, String url) throws IOException {
        String remoteUrl;
        if (!url.startsWith("./") && !url.startsWith("../")) {
            return url;
        }
        String remoteName = null;
        Ref ref2 = parent.exactRef("HEAD");
        if (ref2 != null) {
            if (ref2.isSymbolic()) {
                ref2 = ref2.getLeaf();
            }
            remoteName = parent.getConfig().getString("branch", Repository.shortenRefName(ref2.getName()), "remote");
        }
        if (remoteName == null) {
            remoteName = "origin";
        }
        if ((remoteUrl = parent.getConfig().getString("remote", remoteName, "url")) == null) {
            remoteUrl = parent.getWorkTree().getAbsolutePath();
            if ('\\' == File.separatorChar) {
                remoteUrl = remoteUrl.replace('\\', '/');
            }
        }
        if (remoteUrl.charAt(remoteUrl.length() - 1) == '/') {
            remoteUrl = remoteUrl.substring(0, remoteUrl.length() - 1);
        }
        int separator = 47;
        String submoduleUrl = url;
        while (submoduleUrl.length() > 0) {
            if (submoduleUrl.startsWith("./")) {
                submoduleUrl = submoduleUrl.substring(2);
                continue;
            }
            if (!submoduleUrl.startsWith("../")) break;
            int lastSeparator = remoteUrl.lastIndexOf(47);
            if (lastSeparator < 1) {
                lastSeparator = remoteUrl.lastIndexOf(58);
                separator = 58;
            }
            if (lastSeparator < 1) {
                throw new IOException(MessageFormat.format(JGitText.get().submoduleParentRemoteUrlInvalid, remoteUrl));
            }
            remoteUrl = remoteUrl.substring(0, lastSeparator);
            submoduleUrl = submoduleUrl.substring(3);
        }
        return remoteUrl + (char)separator + submoduleUrl;
    }

    public SubmoduleWalk(Repository repository) throws IOException {
        this.repository = repository;
        this.repoConfig = repository.getConfig();
        this.walk = new TreeWalk(repository);
        this.walk.setRecursive(true);
    }

    public SubmoduleWalk setModulesConfig(Config config) {
        this.modulesConfig = config;
        this.loadPathNames();
        return this;
    }

    public SubmoduleWalk setRootTree(AbstractTreeIterator tree) {
        this.rootTree = tree;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    public SubmoduleWalk setRootTree(AnyObjectId id) throws IOException {
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(this.walk.getObjectReader(), id);
        this.rootTree = p;
        this.modulesConfig = null;
        this.pathToName = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmoduleWalk loadModulesConfig() throws IOException, ConfigInvalidException {
        if (this.rootTree == null) {
            File modulesFile = new File(this.repository.getWorkTree(), ".gitmodules");
            FileBasedConfig config = new FileBasedConfig(modulesFile, this.repository.getFS());
            config.load();
            this.modulesConfig = config;
            this.loadPathNames();
        } else {
            try (TreeWalk configWalk = new TreeWalk(this.repository);){
                configWalk.addTree(this.rootTree);
                int idx = 0;
                while (!this.rootTree.first()) {
                    this.rootTree.back(1);
                    ++idx;
                }
                try {
                    configWalk.setRecursive(false);
                    PathFilter filter2 = PathFilter.create(".gitmodules");
                    configWalk.setFilter(filter2);
                    while (configWalk.next()) {
                        if (!filter2.isDone(configWalk)) continue;
                        this.modulesConfig = new BlobBasedConfig(null, this.repository, configWalk.getObjectId(0));
                        this.loadPathNames();
                        SubmoduleWalk submoduleWalk = this;
                        return submoduleWalk;
                    }
                    this.modulesConfig = new Config();
                    this.pathToName = null;
                }
                finally {
                    if (idx > 0) {
                        this.rootTree.next(idx);
                    }
                }
            }
        }
        return this;
    }

    private void loadPathNames() {
        this.pathToName = null;
        if (this.modulesConfig != null) {
            HashMap<String, String> pathNames = new HashMap<String, String>();
            for (String name2 : this.modulesConfig.getSubsections("submodule")) {
                pathNames.put(this.modulesConfig.getString("submodule", name2, "path"), name2);
            }
            this.pathToName = pathNames;
        }
    }

    public static boolean containsGitModulesFile(Repository repository) throws IOException {
        if (repository.isBare()) {
            return false;
        }
        File modulesFile = new File(repository.getWorkTree(), ".gitmodules");
        return modulesFile.exists();
    }

    private void lazyLoadModulesConfig() throws IOException, ConfigInvalidException {
        if (this.modulesConfig == null) {
            this.loadModulesConfig();
        }
    }

    private String getModuleName(String modulePath) {
        String name2 = this.pathToName != null ? this.pathToName.get(modulePath) : null;
        return name2 != null ? name2 : modulePath;
    }

    public SubmoduleWalk setFilter(TreeFilter filter2) {
        this.walk.setFilter(filter2);
        return this;
    }

    public SubmoduleWalk setTree(AbstractTreeIterator iterator) throws CorruptObjectException {
        this.walk.addTree(iterator);
        return this;
    }

    public SubmoduleWalk setTree(AnyObjectId treeId) throws IOException {
        this.walk.addTree(treeId);
        return this;
    }

    public SubmoduleWalk reset() {
        this.repoConfig = this.repository.getConfig();
        this.modulesConfig = null;
        this.pathToName = null;
        this.walk.reset();
        return this;
    }

    public File getDirectory() {
        return SubmoduleWalk.getSubmoduleDirectory(this.repository, this.path);
    }

    public boolean next() throws IOException {
        while (this.walk.next()) {
            if (FileMode.GITLINK != this.walk.getFileMode(0)) continue;
            this.path = this.walk.getPathString();
            return true;
        }
        this.path = null;
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public String getModuleName() {
        return this.getModuleName(this.path);
    }

    public ObjectId getObjectId() {
        return this.walk.getObjectId(0);
    }

    public String getModulesPath() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "path");
    }

    public String getConfigUrl() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getModulesUrl() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "url");
    }

    public String getConfigUpdate() throws IOException, ConfigInvalidException {
        return this.repoConfig.getString("submodule", this.getModuleName(), "update");
    }

    public String getModulesUpdate() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return this.modulesConfig.getString("submodule", this.getModuleName(), "update");
    }

    public IgnoreSubmoduleMode getModulesIgnore() throws IOException, ConfigInvalidException {
        this.lazyLoadModulesConfig();
        return (IgnoreSubmoduleMode)this.modulesConfig.getEnum(IgnoreSubmoduleMode.values(), "submodule", this.getModuleName(), "ignore", IgnoreSubmoduleMode.NONE);
    }

    public Repository getRepository() throws IOException {
        return SubmoduleWalk.getSubmoduleRepository(this.repository, this.path);
    }

    public ObjectId getHead() throws IOException {
        Repository subRepo = this.getRepository();
        if (subRepo == null) {
            return null;
        }
        try {
            ObjectId objectId = subRepo.resolve("HEAD");
            return objectId;
        }
        finally {
            subRepo.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeadRef() throws IOException {
        Repository subRepo = this.getRepository();
        if (subRepo == null) {
            return null;
        }
        try {
            Ref head = subRepo.exactRef("HEAD");
            String string2 = head != null ? head.getLeaf().getName() : null;
            return string2;
        }
        finally {
            subRepo.close();
        }
    }

    public String getRemoteUrl() throws IOException, ConfigInvalidException {
        String url = this.getModulesUrl();
        return url != null ? SubmoduleWalk.getSubmoduleRemoteUrl(this.repository, url) : null;
    }

    @Override
    public void close() {
        this.walk.close();
    }

    public static enum IgnoreSubmoduleMode {
        ALL,
        DIRTY,
        UNTRACKED,
        NONE;

    }
}

