/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { ReplaySubject } from 'rxjs';
import { BlockUIActions } from '../constants/block-ui-actions.constant';
import { BlockUIDefaultName } from '../constants/block-ui-default-name.constant';
var BlockUIInstanceService = /** @class */ (function () {
    function BlockUIInstanceService() {
        this.blockUISettings = {};
        this.blockUIInstances = {};
        this.blockUISubject = new ReplaySubject();
        this.blockUIObservable = this.blockUISubject.asObservable();
        this.blockUIObservable.subscribe(this.blockUIMiddleware.bind(this));
    }
    /**
     * @return {?}
     */
    BlockUIInstanceService.prototype.getSettings = /**
     * @return {?}
     */
    function () {
        return this.blockUISettings;
    };
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIInstanceService.prototype.updateSettings = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        this.blockUISettings = tslib_1.__assign({}, this.blockUISettings, settings);
    };
    /**
     * @param {?=} name
     * @return {?}
     */
    BlockUIInstanceService.prototype.decorate = /**
     * @param {?=} name
     * @return {?}
     */
    function (name) {
        if (name === void 0) { name = BlockUIDefaultName; }
        var /** @type {?} */ blockUI = /** @type {?} */ ({
            name: name,
            isActive: false,
            blockCount: 0,
            start: this.dispatch(this.blockUISubject, BlockUIActions.START, name),
            update: this.dispatch(this.blockUISubject, BlockUIActions.UPDATE, name),
            stop: this.dispatch(this.blockUISubject, BlockUIActions.STOP, name),
            reset: this.dispatch(this.blockUISubject, BlockUIActions.RESET, name),
            unsubscribe: this.dispatch(this.blockUISubject, BlockUIActions.UNSUBSCRIBE, name)
        });
        this.blockUIInstances[name] = this.blockUIInstances[name] || blockUI;
        return blockUI;
    };
    /**
     * @return {?}
     */
    BlockUIInstanceService.prototype.observe = /**
     * @return {?}
     */
    function () {
        return this.blockUIObservable;
    };
    /**
     * @param {?} __0
     * @return {?}
     */
    BlockUIInstanceService.prototype.blockUIMiddleware = /**
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var action = _a.action, name = _a.name;
        var /** @type {?} */ isActive = null;
        switch (action) {
            case (BlockUIActions.START):
                isActive = true;
                break;
            case (BlockUIActions.STOP):
            case (BlockUIActions.RESET):
                isActive = false;
                break;
        }
        if (isActive !== null) {
            this.blockUIInstances[name].isActive = isActive;
        }
    };
    /**
     * @param {?} subject
     * @param {?} action
     * @param {?=} name
     * @return {?}
     */
    BlockUIInstanceService.prototype.dispatch = /**
     * @param {?} subject
     * @param {?} action
     * @param {?=} name
     * @return {?}
     */
    function (subject, action, name) {
        if (name === void 0) { name = BlockUIDefaultName; }
        return function (message) {
            subject.next({
                name: name,
                action: action,
                message: message
            });
        };
    };
    BlockUIInstanceService.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    BlockUIInstanceService.ctorParameters = function () { return []; };
    return BlockUIInstanceService;
}());
export { BlockUIInstanceService };
function BlockUIInstanceService_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIInstanceService.prototype.blockUISettings;
    /** @type {?} */
    BlockUIInstanceService.prototype.blockUIInstances;
    /** @type {?} */
    BlockUIInstanceService.prototype.blockUISubject;
    /** @type {?} */
    BlockUIInstanceService.prototype.blockUIObservable;
}

//# sourceMappingURL=data:application/json;base64,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