'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.worker = worker;

function _exit() {
  const data = _interopRequireDefault(require('exit'));

  _exit = function _exit() {
    return data;
  };

  return data;
}

function _fs() {
  const data = _interopRequireDefault(require('fs'));

  _fs = function _fs() {
    return data;
  };

  return data;
}

var _generateEmptyCoverage = _interopRequireDefault(
  require('../generateEmptyCoverage')
);

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
// Make sure uncaught errors are logged before we exit.
process.on('uncaughtException', err => {
  console.error(err.stack);
  (0, _exit().default)(1);
});

function worker({config, globalConfig, path}) {
  return (0, _generateEmptyCoverage.default)(
    _fs().default.readFileSync(path, 'utf8'),
    path,
    globalConfig,
    config
  );
}
