/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahEra;
import java.time.chrono.IsoEra;
import java.time.chrono.JapaneseDate;
import java.time.chrono.JapaneseEra;
import java.time.chrono.MinguoDate;
import java.time.chrono.MinguoEra;
import java.time.chrono.ThaiBuddhistDate;
import java.time.chrono.ThaiBuddhistEra;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Optional;

@BugPattern(name="TemporalAccessorGetChronoField", summary="TemporalAccessor.get() only works for certain values of ChronoField.", explanation="TemporalAccessor.get(ChronoField) only works for certain values of ChronoField. E.g., DayOfWeek only supports DAY_OF_WEEK. All other values are guaranteed to throw a UnsupportedTemporalTypeException.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.NO_FIX)
public final class TemporalAccessorGetChronoField
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ZoneId ARBITRARY_ZONE = ZoneId.of("America/Los_Angeles");
    private static final ImmutableList<TemporalAccessor> TEMPORAL_ACCESSOR_INSTANCES = ImmutableList.of((Object)DayOfWeek.MONDAY, (Object)HijrahDate.now(ARBITRARY_ZONE), (Object)HijrahEra.AH, (Object)Instant.now(), (Object)IsoEra.CE, (Object)JapaneseDate.now(ARBITRARY_ZONE), (Object)JapaneseEra.SHOWA, (Object)LocalDate.now(ARBITRARY_ZONE), (Object)LocalDateTime.now(ARBITRARY_ZONE), (Object)LocalTime.now(ARBITRARY_ZONE), (Object)MinguoDate.now(ARBITRARY_ZONE), (Object)MinguoEra.ROC, (Object[])new TemporalAccessor[]{Month.MAY, MonthDay.now(ARBITRARY_ZONE), OffsetDateTime.now(ARBITRARY_ZONE), OffsetTime.now(ARBITRARY_ZONE), ThaiBuddhistDate.now(ARBITRARY_ZONE), ThaiBuddhistEra.BE, Year.now(ARBITRARY_ZONE), YearMonth.now(ARBITRARY_ZONE), ZonedDateTime.now(ARBITRARY_ZONE), ZoneOffset.ofHours(8)});
    private static final ImmutableListMultimap<Class<?>, ChronoField> UNSUPPORTED = TemporalAccessorGetChronoField.buildUnsupported();
    private static final ImmutableMap<Matcher<ExpressionTree>, Class<?>> MATCHER_MAP = TemporalAccessorGetChronoField.buildMatcherMap();

    private static ImmutableListMultimap<Class<?>, ChronoField> buildUnsupported() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (TemporalAccessor temporalAccessor : TEMPORAL_ACCESSOR_INSTANCES) {
            for (ChronoField chronoField : ChronoField.values()) {
                if (temporalAccessor.isSupported(chronoField)) continue;
                builder.put(temporalAccessor.getClass(), (Object)chronoField);
            }
        }
        return builder.build();
    }

    private static ImmutableMap<Matcher<ExpressionTree>, Class<?>> buildMatcherMap() {
        ImmutableMap.Builder matchers = ImmutableMap.builder();
        for (Class clazz : UNSUPPORTED.keySet()) {
            matchers.put((Object)Matchers.instanceMethod().onExactClass(clazz.getName()).namedAnyOf(new String[]{"get", "getLong"}).withParameters(new String[]{"java.time.temporal.TemporalField"}), (Object)clazz);
        }
        return matchers.build();
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (Map.Entry entry : MATCHER_MAP.entrySet()) {
            if (!((Matcher)entry.getKey()).matches((Tree)tree, state)) continue;
            return TemporalAccessorGetChronoField.isDefinitelyInvalidChronoField(tree, (Iterable<ChronoField>)UNSUPPORTED.get(entry.getValue())) ? this.describeMatch(tree) : Description.NO_MATCH;
        }
        return Description.NO_MATCH;
    }

    private static boolean isDefinitelyInvalidChronoField(MethodInvocationTree tree, Iterable<ChronoField> invalidChronoFields) {
        Optional<String> constant = TemporalAccessorGetChronoField.getEnumName((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()));
        if (constant.isPresent()) {
            for (ChronoField invalidChronoField : invalidChronoFields) {
                if (!constant.get().equals(invalidChronoField.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<String> getEnumName(ExpressionTree chronoField) {
        if (chronoField instanceof IdentifierTree) {
            return Optional.of(((IdentifierTree)chronoField).getName().toString());
        }
        if (chronoField instanceof MemberSelectTree) {
            return Optional.of(((MemberSelectTree)chronoField).getIdentifier().toString());
        }
        return Optional.empty();
    }
}

