/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.auto.value.AutoValue;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.CompatibleWith;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.EqualsIncompatibleType;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AutoValue_IncompatibleArgumentType_RequiredType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeParameterElement;

@BugPattern(name="IncompatibleArgumentType", summary="Passing argument to a generic method with an incompatible type.", severity=BugPattern.SeverityLevel.ERROR)
public class IncompatibleArgumentType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Type calledMethodType = ASTHelpers.getType((Tree)methodInvocationTree.getMethodSelect());
        Type calledClazzType = ASTHelpers.getReceiverType((ExpressionTree)methodInvocationTree);
        java.util.List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        Symbol.MethodSymbol declaredMethod = ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree);
        if (arguments.isEmpty() || declaredMethod == null) {
            return Description.NO_MATCH;
        }
        ArrayList<Object> requiredTypesAtCallSite = new ArrayList<Object>(Collections.nCopies(arguments.size(), null));
        Types types = state.getTypes();
        if (!this.populateTypesToEnforce(declaredMethod, calledMethodType, calledClazzType, requiredTypesAtCallSite, state)) {
            Symbol.MethodSymbol method;
            Iterator iterator = ASTHelpers.findSuperMethods((Symbol.MethodSymbol)declaredMethod, (Types)types).iterator();
            while (iterator.hasNext() && !this.populateTypesToEnforce(method = (Symbol.MethodSymbol)iterator.next(), calledMethodType, calledClazzType, requiredTypesAtCallSite, state)) {
            }
        }
        this.reportAnyViolations(arguments, requiredTypesAtCallSite, state);
        return Description.NO_MATCH;
    }

    private void reportAnyViolations(java.util.List<? extends ExpressionTree> arguments, java.util.List<RequiredType> requiredArgumentTypes, VisitorState state) {
        Types types = state.getTypes();
        for (int i = 0; i < requiredArgumentTypes.size(); ++i) {
            EqualsIncompatibleType.TypeCompatibilityReport report;
            RequiredType requiredType = requiredArgumentTypes.get(i);
            if (requiredType == null) continue;
            ExpressionTree argument = arguments.get(i);
            Type argType = ASTHelpers.getType((Tree)argument);
            if (requiredType.type() == null || (report = EqualsIncompatibleType.compatibilityOfTypes(requiredType.type(), argType, state)).compatible()) continue;
            state.reportMatch(this.describeViolation(argument, argType, requiredType.type(), types));
        }
    }

    private Description describeViolation(ExpressionTree argument, Type argType, Type requiredType, Types types) {
        String targetType;
        String sourceType = Signatures.prettyType((Type)argType);
        if (sourceType.equals(targetType = Signatures.prettyType((Type)ASTHelpers.getUpperBound((Type)requiredType, (Types)types)))) {
            sourceType = argType.toString();
            targetType = requiredType.toString();
        }
        String msg = String.format("Argument '%s' should not be passed to this method. Its type %s is not compatible with the required type: %s.", argument, sourceType, targetType);
        return this.buildDescription(argument).setMessage(msg).build();
    }

    @CheckReturnValue
    private boolean populateTypesToEnforce(Symbol.MethodSymbol declaredMethod, Type calledMethodType, Type calledReceiverType, java.util.List<RequiredType> argumentTypeRequirements, VisitorState state) {
        boolean foundAnyTypeToEnforce = false;
        List<Symbol.VarSymbol> params = declaredMethod.params();
        for (int i = 0; i < params.size(); ++i) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)params.get(i);
            CompatibleWith anno = (CompatibleWith)ASTHelpers.getAnnotation((Symbol)varSymbol, CompatibleWith.class);
            if (anno == null) continue;
            foundAnyTypeToEnforce = true;
            RequiredType requiredType = this.resolveRequiredTypeForThisCall(state, calledMethodType, calledReceiverType, declaredMethod, anno.value());
            if (declaredMethod.isVarArgs() && i == params.size() - 1) {
                if (i >= argumentTypeRequirements.size()) break;
                for (int j = i; j < argumentTypeRequirements.size(); ++j) {
                    argumentTypeRequirements.set(j, requiredType);
                }
                continue;
            }
            argumentTypeRequirements.set(i, requiredType);
        }
        return foundAnyTypeToEnforce;
    }

    @Nullable
    @CheckReturnValue
    private RequiredType resolveRequiredTypeForThisCall(VisitorState state, Type calledMethodType, Type calledReceiverType, Symbol.MethodSymbol declaredMethod, String typeArgName) {
        RequiredType requiredType = this.resolveTypeFromGenericMethod(calledMethodType, declaredMethod, typeArgName);
        if (requiredType == null) {
            requiredType = this.resolveTypeFromClass(calledReceiverType, (Symbol.ClassSymbol)declaredMethod.owner, typeArgName, state);
        }
        return requiredType;
    }

    private RequiredType resolveTypeFromGenericMethod(Type calledMethodType, Symbol.MethodSymbol declaredMethod, String typeArgName) {
        int tyargIndex = IncompatibleArgumentType.findTypeArgInList(declaredMethod, typeArgName);
        return tyargIndex == -1 ? null : RequiredType.create(IncompatibleArgumentType.getTypeFromTypeMapping(calledMethodType, typeArgName));
    }

    private static Type getTypeFromTypeMapping(Type m, String namedTypeArg) {
        try {
            Field substField = m.getClass().getDeclaredField("this$0");
            substField.setAccessible(true);
            Object subst = substField.get(m);
            Field fromField = subst.getClass().getDeclaredField("from");
            Field toField = subst.getClass().getDeclaredField("to");
            fromField.setAccessible(true);
            toField.setAccessible(true);
            java.util.List types = (java.util.List)fromField.get(subst);
            java.util.List calledTypes = (java.util.List)toField.get(subst);
            for (int i = 0; i < types.size(); ++i) {
                Type type = (Type)types.get(i);
                if (!type.toString().equals(namedTypeArg)) continue;
                return (Type)calledTypes.get(i);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private RequiredType resolveTypeFromClass(Type calledType, Symbol.ClassSymbol clazzSymbol, String typeArgName, VisitorState state) {
        int tyargIndex = IncompatibleArgumentType.findTypeArgInList(clazzSymbol, typeArgName);
        if (tyargIndex != -1) {
            return RequiredType.create(AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(calledType, clazzSymbol, tyargIndex, state.getTypes()));
        }
        while (clazzSymbol.isInner()) {
            Symbol.ClassSymbol encloser = clazzSymbol.owner.enclClass();
            calledType = calledType.getEnclosingType();
            tyargIndex = IncompatibleArgumentType.findTypeArgInList(encloser, typeArgName);
            if (tyargIndex != -1) {
                if (calledType.getTypeArguments().isEmpty()) {
                    return null;
                }
                return RequiredType.create(calledType.getTypeArguments().get(tyargIndex));
            }
            clazzSymbol = encloser;
        }
        return null;
    }

    private static int findTypeArgInList(Parameterizable hasTypeParams, String typeArgName) {
        java.util.List<? extends TypeParameterElement> typeParameters = hasTypeParams.getTypeParameters();
        for (int i = 0; i < typeParameters.size(); ++i) {
            if (!typeParameters.get(i).getSimpleName().contentEquals(typeArgName)) continue;
            return i;
        }
        return -1;
    }

    @AutoValue
    static abstract class RequiredType {
        RequiredType() {
        }

        @Nullable
        abstract Type type();

        static RequiredType create(Type type) {
            return new AutoValue_IncompatibleArgumentType_RequiredType(type);
        }
    }
}

