/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ArgumentChangeFinder;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.CreatesDuplicateCallHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.EnclosedByReverseHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.InvocationInfo;
import com.google.errorprone.bugpatterns.argumentselectiondefects.LowInformationNameHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Matchers;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NameInCommentHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.google.errorprone.bugpatterns.argumentselectiondefects.PenaltyThresholdHeuristic;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.names.NeedlemanWunschEditDistance;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.function.Function;

@BugPattern(name="ArgumentSelectionDefectChecker", summary="Arguments are in the wrong order or could be commented for clarity.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ArgumentSelectionDefectChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private final ArgumentChangeFinder argumentchangeFinder;

    public ArgumentSelectionDefectChecker() {
        this(ArgumentChangeFinder.builder().setDistanceFunction(ArgumentSelectionDefectChecker.buildDefaultDistanceFunction()).addHeuristic(new LowInformationNameHeuristic()).addHeuristic(new PenaltyThresholdHeuristic()).addHeuristic(new EnclosedByReverseHeuristic()).addHeuristic(new CreatesDuplicateCallHeuristic()).addHeuristic(new NameInCommentHeuristic()).build());
    }

    @VisibleForTesting
    ArgumentSelectionDefectChecker(ArgumentChangeFinder argumentChangeFinder) {
        this.argumentchangeFinder = argumentChangeFinder;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (Matchers.ASSERT_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.visitNewClassOrMethodInvocation(InvocationInfo.createFromMethodInvocation(tree, symbol, state));
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((NewClassTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (Matchers.AUTOVALUE_CONSTRUCTOR.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.visitNewClassOrMethodInvocation(InvocationInfo.createFromNewClass(tree, symbol, state));
    }

    private Description visitNewClassOrMethodInvocation(InvocationInfo invocationInfo) {
        Changes changes = this.argumentchangeFinder.findChanges(invocationInfo);
        if (changes.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(invocationInfo.tree()).setMessage(changes.describe(invocationInfo));
        description.addFix((Fix)changes.buildCommentArgumentsFix(invocationInfo));
        description.addFix((Fix)changes.buildPermuteArgumentsFix(invocationInfo));
        return description.build();
    }

    private static final Function<ParameterPair, Double> buildDefaultDistanceFunction() {
        return new Function<ParameterPair, Double>(){

            @Override
            public Double apply(ParameterPair pair) {
                if (pair.formal().isNullLiteral() || pair.actual().isNullLiteral()) {
                    return 0.0;
                }
                if (!pair.formal().isUnknownName() && !pair.actual().isUnknownName()) {
                    String normalizedSource = NamingConventions.convertToLowerUnderscore((String)pair.formal().name());
                    String normalizedTarget = NamingConventions.convertToLowerUnderscore((String)pair.actual().name());
                    return NeedlemanWunschEditDistance.getNormalizedEditDistance((String)normalizedSource, (String)normalizedTarget, (boolean)false, (int)8, (int)8, (int)1);
                }
                return pair.formal().index() == pair.actual().index() ? 0.0 : Double.POSITIVE_INFINITY;
            }
        };
    }
}

