/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="RandomModInteger", summary="Use Random.nextInt(int).  Random.nextInt() % n can have negative results", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class RandomModInteger
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Matcher<ExpressionTree> RANDOM_NEXT_INT = Matchers.instanceMethod().onDescendantOf("java.util.Random").withSignature("nextInt()");

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.REMAINDER && tree.getLeftOperand() instanceof MethodInvocationTree && RANDOM_NEXT_INT.matches((Tree)tree.getLeftOperand(), state)) {
            ExpressionTree randomExpr = ASTHelpers.getReceiver((ExpressionTree)tree.getLeftOperand());
            ExpressionTree modulus = tree.getRightOperand();
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)String.format("%s.nextInt(%s)", state.getSourceForNode((Tree)randomExpr), state.getSourceForNode((Tree)modulus))));
        }
        return Description.NO_MATCH;
    }
}

