/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@BugPattern(name="PreconditionsCheckNotNullPrimitive", summary="First argument to `Preconditions.checkNotNull()` is a primitive rather than an object reference", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class PreconditionsCheckNotNullPrimitive
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.argument((int)0, (Matcher)Matchers.isPrimitiveType())}).matches((Tree)methodInvocationTree, state)) {
            return this.describe(methodInvocationTree, state);
        }
        return Description.NO_MATCH;
    }

    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ExpressionTree arg1 = methodInvocationTree.getArguments().get(0);
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return this.describeMatch(arg1, (Fix)SuggestedFix.replace((Tree)methodInvocationTree, (String)state.getSourceForNode((Tree)arg1)));
        }
        if (arg1.getKind() == Tree.Kind.EQUAL_TO || arg1.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            BinaryTree binaryExpr = (BinaryTree)arg1;
            if (binaryExpr.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL) {
                return this.describeMatch(arg1, (Fix)SuggestedFix.replace((Tree)arg1, (String)state.getSourceForNode((Tree)binaryExpr.getRightOperand())));
            }
            if (binaryExpr.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
                return this.describeMatch(arg1, (Fix)SuggestedFix.replace((Tree)arg1, (String)state.getSourceForNode((Tree)binaryExpr.getLeftOperand())));
            }
        }
        if ((arg1 instanceof BinaryTree || arg1.getKind() == Tree.Kind.METHOD_INVOCATION || arg1.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) && ((JCTree.JCExpression)arg1).type == state.getSymtab().booleanType) {
            return this.describeMatch(arg1, this.createCheckArgumentOrStateCall(methodInvocationTree, state, arg1));
        }
        return this.describeMatch(arg1, (Fix)SuggestedFix.delete((Tree)parent));
    }

    private Fix createCheckArgumentOrStateCall(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree arg1) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String replacementMethod = "checkState";
        if (PreconditionsCheckNotNullPrimitive.hasMethodParameter(state.getPath(), arg1)) {
            replacementMethod = "checkArgument";
        }
        StringBuilder replacement = new StringBuilder();
        if (methodInvocationTree.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER) {
            fix.addStaticImport("com.google.common.base.Preconditions." + replacementMethod);
        } else {
            replacement.append("Preconditions.");
        }
        replacement.append(replacementMethod).append('(');
        Joiner.on((String)", ").appendTo(replacement, methodInvocationTree.getArguments());
        replacement.append(")");
        fix.replace((Tree)methodInvocationTree, replacement.toString());
        return fix.build();
    }

    private static boolean hasMethodParameter(TreePath path, ExpressionTree tree) {
        HashSet<Symbol> symbols = new HashSet<Symbol>();
        for (IdentifierTree ident : PreconditionsCheckNotNullPrimitive.getVariableUses(tree)) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)ident);
            if (!symbol.isLocal()) continue;
            symbols.add(symbol);
        }
        while (path != null && !(path.getLeaf() instanceof MethodTree)) {
            path = path.getParentPath();
        }
        if (path == null) {
            throw new IllegalStateException("Should have an enclosing method declaration");
        }
        MethodTree methodDecl = (MethodTree)path.getLeaf();
        for (VariableTree variableTree : methodDecl.getParameters()) {
            if (!symbols.contains(ASTHelpers.getSymbol((VariableTree)variableTree))) continue;
            return true;
        }
        return false;
    }

    static List<IdentifierTree> getVariableUses(ExpressionTree tree) {
        final ArrayList<IdentifierTree> freeVars = new ArrayList<IdentifierTree>();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void v) {
                if (((JCTree.JCIdent)node).sym instanceof Symbol.VarSymbol) {
                    freeVars.add(node);
                }
                return (Void)super.visitIdentifier(node, v);
            }
        }.scan(tree, null);
        return freeVars;
    }
}

