/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="NonFinalCompileTimeConstant", summary="@CompileTimeConstant parameters should be final or effectively final", severity=BugPattern.SeverityLevel.ERROR)
public class NonFinalCompileTimeConstant
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        for (VariableTree variableTree : tree.getParameters()) {
            Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)variableTree);
            if (sym == null || !CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)sym) || (sym.flags() & 0x10L) == 16L || (sym.flags() & 0x20000000000L) == 0x20000000000L) continue;
            return this.describeMatch(variableTree);
        }
        return Description.NO_MATCH;
    }
}

