/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.Tree;

@BugPattern(name="EmptyIf", altNames={"empty"}, summary="Empty statement after if", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class EmptyIfStatement
extends BugChecker
implements BugChecker.EmptyStatementTreeMatcher {
    public Description matchEmptyStatement(EmptyStatementTree tree, VisitorState state) {
        boolean matches = false;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent.getKind() == Tree.Kind.IF) {
            IfTree parentAsIf = (IfTree)parent;
            boolean bl = matches = parentAsIf.getThenStatement() instanceof EmptyStatementTree && parentAsIf.getElseStatement() == null;
        }
        if (!matches) {
            return Description.NO_MATCH;
        }
        boolean nextStmtIsNull = Matchers.parentNode((Matcher)Matchers.nextStatement((Matcher)Matchers.isSame(null))).matches((Tree)tree, state);
        assert (state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.IF);
        IfTree ifParent = (IfTree)state.getPath().getParentPath().getLeaf();
        if (nextStmtIsNull) {
            return this.describeMatch(parent, (Fix)SuggestedFix.delete((Tree)parent));
        }
        return this.describeMatch(ifParent.getThenStatement(), (Fix)SuggestedFix.delete((Tree)ifParent.getThenStatement()));
    }
}

