/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

public abstract class AbstractToString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.IdentifierTreeMatcher,
BugChecker.MemberSelectTreeMatcher {
    private static final Matcher<ExpressionTree> TO_STRING = Matchers.instanceMethod().onDescendantOf("java.lang.Object").withSignature("toString()");
    private static final Matcher<ExpressionTree> PRINT_STRING = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.io.PrintStream").withSignature("print(java.lang.Object)"), Matchers.instanceMethod().onDescendantOf("java.io.PrintStream").withSignature("println(java.lang.Object)"), Matchers.instanceMethod().onDescendantOf("java.lang.StringBuilder").withSignature("append(java.lang.Object)")});
    private static final Matcher<ExpressionTree> VALUE_OF = Matchers.staticMethod().onClass("java.lang.String").withSignature("valueOf(java.lang.Object)");

    protected abstract TypePredicate typePredicate();

    protected abstract Optional<Fix> implicitToStringFix(ExpressionTree var1, VisitorState var2);

    protected Optional<String> descriptionMessageForDefaultMatch(Type type, VisitorState state) {
        return Optional.absent();
    }

    protected abstract Optional<Fix> toStringFix(Tree var1, ExpressionTree var2, VisitorState var3);

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.checkToString(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.checkToString(tree, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        Type receiverType = ASTHelpers.getType((Tree)receiver);
        if (TO_STRING.matches((Tree)tree, state) && this.typePredicate().apply(receiverType, state)) {
            return this.maybeFix(tree, state, receiverType, this.toStringFix(tree, receiver, state));
        }
        return this.checkToString(tree, state);
    }

    private Description checkToString(ExpressionTree tree, VisitorState state) {
        Optional<Fix> fix;
        Tree parent;
        ToStringKind toStringKind;
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (!(sym instanceof Symbol.VarSymbol) && !(sym instanceof Symbol.MethodSymbol)) {
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getType((Tree)tree);
        if (type instanceof Type.MethodType) {
            type = type.getReturnType();
        }
        if ((toStringKind = this.isToString(parent = state.getPath().getParentPath().getLeaf(), tree, state)) == ToStringKind.NONE) {
            return Description.NO_MATCH;
        }
        if (!this.typePredicate().apply(type, state)) {
            return Description.NO_MATCH;
        }
        switch (toStringKind) {
            case IMPLICIT: {
                fix = this.implicitToStringFix(tree, state);
                break;
            }
            case EXPLICIT: {
                fix = this.toStringFix(parent, tree, state);
                break;
            }
            default: {
                throw new AssertionError((Object)toStringKind);
            }
        }
        return this.maybeFix(tree, state, type, fix);
    }

    ToStringKind isToString(Tree parent, ExpressionTree tree, VisitorState state) {
        if (this.isStringConcat(parent, state)) {
            return ToStringKind.IMPLICIT;
        }
        if (parent instanceof ExpressionTree) {
            ExpressionTree parentExpression = (ExpressionTree)parent;
            if (PRINT_STRING.matches((Tree)parentExpression, state)) {
                return ToStringKind.IMPLICIT;
            }
            if (VALUE_OF.matches((Tree)parentExpression, state)) {
                return ToStringKind.EXPLICIT;
            }
        }
        return ToStringKind.NONE;
    }

    private boolean isStringConcat(Tree tree, VisitorState state) {
        return (tree.getKind() == Tree.Kind.PLUS || tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT) && state.getTypes().isSameType(ASTHelpers.getType((Tree)tree), state.getSymtab().stringType);
    }

    private Description maybeFix(Tree tree, VisitorState state, Type matchedType, Optional<Fix> fix) {
        Optional<String> summary;
        Description.Builder description = this.buildDescription(tree);
        if (fix.isPresent()) {
            description.addFix((Fix)fix.get());
        }
        if ((summary = this.descriptionMessageForDefaultMatch(matchedType, state)).isPresent()) {
            description.setMessage((String)summary.get());
        }
        return description.build();
    }

    static enum ToStringKind {
        IMPLICIT,
        EXPLICIT,
        NONE;

    }
}

