/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp.dependencies;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.JavaFileObjectWithLocation;
import com.sun.tools.sjavac.comp.PubAPIs;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class NewDependencyCollector
implements TaskListener {
    private final Context context;
    private final Collection<JavaFileObject> explicitJFOs;
    private Map<String, Map<String, Set<String>>> deps;
    private Map<String, Map<String, Set<String>>> cpDeps;

    public NewDependencyCollector(Context context, Collection<JavaFileObject> explicitJFOs) {
        this.context = context;
        this.explicitJFOs = explicitJFOs;
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.COMPILATION) {
            this.collectPubApisOfDependencies(this.context, this.explicitJFOs);
            this.deps = this.getDependencies(this.context, this.explicitJFOs, false);
            this.cpDeps = this.getDependencies(this.context, this.explicitJFOs, true);
        }
    }

    public Map<String, Map<String, Set<String>>> getDependencies(boolean cp) {
        return cp ? this.cpDeps : this.deps;
    }

    private Set<Dependencies.GraphDependencies.CompletionNode> getDependencyNodes(Context context, Collection<JavaFileObject> explicitJFOs, boolean explicits) {
        Dependencies.GraphDependencies deps = (Dependencies.GraphDependencies)Dependencies.GraphDependencies.instance(context);
        return deps.getNodes().stream().map(n -> (Dependencies.GraphDependencies.CompletionNode)n).filter(n -> n.getClassSymbol().fullname != null).filter(n -> explicits == explicitJFOs.contains(n.getClassSymbol().classfile)).collect(Collectors.toSet());
    }

    private void collectPubApisOfDependencies(Context context, Collection<JavaFileObject> explicitJFOs) {
        PubAPIs pubApis = PubAPIs.instance(context);
        for (Dependencies.GraphDependencies.CompletionNode cDepNode : this.getDependencyNodes(context, explicitJFOs, false)) {
            Symbol.ClassSymbol cs = cDepNode.getClassSymbol().outermostClass();
            JavaFileManager.Location loc = this.getLocationOf(cs);
            if (loc != StandardLocation.CLASS_PATH && loc != StandardLocation.SOURCE_PATH) continue;
            pubApis.visitPubapi(cs);
        }
    }

    private JavaFileManager.Location getLocationOf(Symbol.ClassSymbol cs) {
        JavaFileObject jfo = cs.outermostClass().classfile;
        if (jfo instanceof JavaFileObjectWithLocation) {
            return ((JavaFileObjectWithLocation)jfo).getLocation();
        }
        return null;
    }

    private Map<String, Map<String, Set<String>>> getDependencies(Context context, Collection<JavaFileObject> explicitJFOs, boolean cp) {
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        for (Dependencies.GraphDependencies.CompletionNode cnode : this.getDependencyNodes(context, explicitJFOs, true)) {
            HashSet<String> fqDeps;
            String fqDep = cnode.getClassSymbol().outermostClass().flatname.toString();
            String depPkg = Util.pkgNameOfClassName(fqDep);
            HashMap depsForThisClass = (HashMap)result.get(depPkg);
            if (depsForThisClass == null) {
                depsForThisClass = new HashMap();
                result.put(depPkg, depsForThisClass);
            }
            if ((fqDeps = (HashSet<String>)depsForThisClass.get(fqDep)) == null) {
                fqDeps = new HashSet<String>();
                depsForThisClass.put(fqDep, fqDeps);
            }
            for (GraphUtils.Node<?, ?> depNode : this.getAllDependencies(cnode)) {
                Dependencies.GraphDependencies.CompletionNode cDepNode = (Dependencies.GraphDependencies.CompletionNode)depNode;
                if (cDepNode == cnode || cDepNode.getClassSymbol().fullname == null || !this.isSymbolRelevant(cp, cDepNode.getClassSymbol())) continue;
                fqDeps.add(cDepNode.getClassSymbol().outermostClass().flatname.toString());
            }
            for (Symbol.ClassSymbol cs : this.allSupertypes(cnode.getClassSymbol())) {
                if (!this.isSymbolRelevant(cp, cs)) continue;
                fqDeps.add(cs.outermostClass().flatname.toString());
            }
        }
        return result;
    }

    public boolean isSymbolRelevant(boolean cp, Symbol.ClassSymbol cs) {
        JavaFileManager.Location csLoc = this.getLocationOf(cs);
        StandardLocation relevantLocation = cp ? StandardLocation.CLASS_PATH : StandardLocation.SOURCE_PATH;
        return csLoc == relevantLocation;
    }

    private Set<Symbol.ClassSymbol> allSupertypes(Symbol.TypeSymbol t) {
        if (t == null || !(t instanceof Symbol.ClassSymbol)) {
            return Collections.emptySet();
        }
        HashSet<Symbol.ClassSymbol> result = new HashSet<Symbol.ClassSymbol>();
        Symbol.ClassSymbol cs = (Symbol.ClassSymbol)t;
        result.add(cs);
        result.addAll(this.allSupertypes(cs.getSuperclass().tsym));
        for (Type it : cs.getInterfaces()) {
            result.addAll(this.allSupertypes(it.tsym));
        }
        return result;
    }

    private Collection<? extends GraphUtils.Node<?, ?>> getAllDependencies(Dependencies.GraphDependencies.CompletionNode cnode) {
        return Stream.of(cnode.getSupportedDependencyKinds()).flatMap(dk -> cnode.getDependenciesByKind((GraphUtils.DependencyKind)dk).stream()).collect(Collectors.toSet());
    }
}

