/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.StatisticsCollector;
import com.google.errorprone.SuppressionInfo;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public class VisitorState {
    private final DescriptionListener descriptionListener;
    private final StatisticsCollector statisticsCollector;
    private final Map<String, BugPattern.SeverityLevel> severityMap;
    private final ErrorProneOptions errorProneOptions;
    private final LoadingCache<String, Optional<Type>> typeCache;
    public final Context context;
    private final TreePath path;
    private final SuppressionInfo.SuppressedState suppressedState;
    private static final DescriptionListener NULL_LISTENER = description -> {};

    public static VisitorState createForUtilityPurposes(Context context) {
        return new VisitorState(context, NULL_LISTENER, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createNoOpCollector(), null, null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    public static VisitorState createForCustomFindingCollection(Context context, DescriptionListener listener) {
        return new VisitorState(context, listener, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createCollector(), null, null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    public static VisitorState createConfiguredForCompilation(Context context, DescriptionListener listener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions) {
        return new VisitorState(context, listener, severityMap, errorProneOptions, StatisticsCollector.createCollector(), null, null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    @Deprecated
    public VisitorState(Context context) {
        this(context, NULL_LISTENER, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createNoOpCollector(), null, null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    @Deprecated
    public VisitorState(Context context, DescriptionListener listener) {
        this(context, listener, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createCollector(), null, null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    @Deprecated
    public VisitorState(Context context, DescriptionListener listener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions) {
        this(context, listener, severityMap, errorProneOptions, StatisticsCollector.createCollector(), null, null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    private VisitorState(Context context, DescriptionListener descriptionListener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions, StatisticsCollector statisticsCollector, LoadingCache<String, Optional<Type>> typeCache, TreePath path, SuppressionInfo.SuppressedState suppressedState) {
        this.context = context;
        this.descriptionListener = descriptionListener;
        this.severityMap = severityMap;
        this.errorProneOptions = errorProneOptions;
        this.statisticsCollector = statisticsCollector;
        this.suppressedState = suppressedState;
        this.path = path;
        this.typeCache = typeCache != null ? typeCache : CacheBuilder.newBuilder().concurrencyLevel(1).build(CacheLoader.from(key -> Optional.fromNullable((Object)this.getTypeFromStringInternal((String)key))));
    }

    public VisitorState withPath(TreePath path) {
        return new VisitorState(this.context, this.descriptionListener, this.severityMap, this.errorProneOptions, this.statisticsCollector, this.typeCache, path, this.suppressedState);
    }

    public VisitorState withPathAndSuppression(TreePath path, SuppressionInfo.SuppressedState suppressedState) {
        return new VisitorState(this.context, this.descriptionListener, this.severityMap, this.errorProneOptions, this.statisticsCollector, this.typeCache, path, suppressedState);
    }

    public TreePath getPath() {
        return this.path;
    }

    public TreeMaker getTreeMaker() {
        return TreeMaker.instance(this.context);
    }

    public Types getTypes() {
        return Types.instance(this.context);
    }

    public Symtab getSymtab() {
        return Symtab.instance(this.context);
    }

    public NullnessAnalysis getNullnessAnalysis() {
        return NullnessAnalysis.instance(this.context);
    }

    public ErrorProneOptions errorProneOptions() {
        return this.errorProneOptions;
    }

    public void reportMatch(Description description) {
        BugPattern.SeverityLevel override = this.severityMap.get(description.checkName);
        if (override != null) {
            description = description.applySeverityOverride(override);
        }
        this.statisticsCollector.incrementCounter(this.statsKey(description.checkName + "-findings"));
        this.descriptionListener.onDescribed(description);
    }

    private String statsKey(String key) {
        return this.suppressedState == SuppressionInfo.SuppressedState.SUPPRESSED ? key + "-suppressed" : key;
    }

    public void incrementCounter(BugChecker bugChecker, String key) {
        this.incrementCounter(bugChecker, key, 1);
    }

    public void incrementCounter(BugChecker bugChecker, String key, int count) {
        this.statisticsCollector.incrementCounter(this.statsKey(bugChecker.canonicalName() + "-" + key), count);
    }

    public ImmutableMultiset<String> counters() {
        return this.statisticsCollector.counters();
    }

    public Name getName(String nameStr) {
        return Names.instance(this.context).fromString(nameStr);
    }

    @Nullable
    public Type getTypeFromString(String typeStr) {
        try {
            return (Type)((Optional)this.typeCache.get((Object)typeStr)).orNull();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    private Type getTypeFromStringInternal(String typeStr) {
        VisitorState.validateTypeStr(typeStr);
        Type primitiveOrVoidType = this.getPrimitiveOrVoidType(typeStr);
        if (primitiveOrVoidType != null) {
            return primitiveOrVoidType;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.getSymbolFromString(typeStr);
        if (classSymbol != null) {
            return classSymbol.asType();
        }
        return null;
    }

    @Nullable
    public Symbol getSymbolFromString(String symStr) {
        boolean modular;
        symStr = VisitorState.inferBinaryName(symStr);
        Name name = this.getName(symStr);
        Modules modules = Modules.instance(this.context);
        boolean bl = modular = modules.getDefaultModule() != this.getSymtab().noModule;
        if (!modular) {
            return this.getSymbolFromString(this.getSymtab().noModule, name);
        }
        for (Symbol.ModuleSymbol msym : Modules.instance(this.context).allModules()) {
            Symbol.ClassSymbol result = this.getSymbolFromString(msym, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public Symbol.ClassSymbol getSymbolFromString(Symbol.ModuleSymbol msym, Name name) {
        Symbol.ClassSymbol result = this.getSymtab().getClass(msym, name);
        if (result == null || result.kind == Kinds.Kind.ERR || !result.exists()) {
            return null;
        }
        try {
            result.complete();
        }
        catch (Symbol.CompletionFailure failure) {
            return null;
        }
        return result;
    }

    private static String inferBinaryName(String classname) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int sep = 46;
        for (String bit : Splitter.on((char)'.').split((CharSequence)classname)) {
            if (!first) {
                sb.append((char)sep);
            }
            sb.append(bit);
            if (Character.isUpperCase(bit.charAt(0))) {
                sep = 36;
            }
            first = false;
        }
        return sb.toString();
    }

    public Type getType(Type baseType, boolean isArray, java.util.List<Type> typeParams) {
        boolean isGeneric;
        boolean bl = isGeneric = typeParams != null && !typeParams.isEmpty();
        if (!isArray && !isGeneric) {
            return baseType;
        }
        if (isArray && !isGeneric) {
            Symbol.ClassSymbol arraySymbol = this.getSymtab().arrayClass;
            return new Type.ArrayType(baseType, arraySymbol);
        }
        if (!isArray && isGeneric) {
            List<Type> typeParamsCopy = List.from(typeParams);
            return new Type.ClassType(Type.noType, typeParamsCopy, baseType.tsym);
        }
        throw new IllegalArgumentException("Unsupported arguments to getType");
    }

    public Type arrayTypeForType(Type baseType) {
        return new Type.ArrayType(baseType, this.getSymtab().arrayClass);
    }

    @Nullable
    @SafeVarargs
    public final TreePath findPathToEnclosing(Class<? extends Tree> ... classes) {
        for (TreePath enclosingPath = this.getPath(); enclosingPath != null; enclosingPath = enclosingPath.getParentPath()) {
            for (Class<? extends Tree> clazz : classes) {
                if (!clazz.isInstance(enclosingPath.getLeaf())) continue;
                return enclosingPath;
            }
        }
        return null;
    }

    @Nullable
    @SafeVarargs
    public final <T extends Tree> T findEnclosing(Class<? extends T> ... classes) {
        TreePath pathToEnclosing = this.findPathToEnclosing(classes);
        return (T)(pathToEnclosing == null ? null : pathToEnclosing.getLeaf());
    }

    @Nullable
    public CharSequence getSourceCode() {
        try {
            return this.getPath().getCompilationUnit().getSourceFile().getCharContent(false);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public String getSourceForNode(Tree tree) {
        JCTree node = (JCTree)tree;
        int start = node.getStartPosition();
        int end = this.getEndPosition(node);
        if (end < 0) {
            return null;
        }
        return this.getSourceCode().subSequence(start, end).toString();
    }

    public java.util.List<ErrorProneToken> getTokensForNode(Tree tree) {
        return ErrorProneTokens.getTokens(this.getSourceForNode(tree), this.context);
    }

    public int getEndPosition(Tree node) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)this.getPath().getCompilationUnit();
        if (compilationUnit.endPositions == null) {
            return -1;
        }
        return ((JCTree)node).getEndPosition(compilationUnit.endPositions);
    }

    private static void validateTypeStr(String typeStr) {
        if (typeStr.contains("[") || typeStr.contains("]")) {
            throw new IllegalArgumentException(String.format("Cannot convert array types (%s), please build them using getType()", typeStr));
        }
        if (typeStr.contains("<") || typeStr.contains(">")) {
            throw new IllegalArgumentException(String.format("Cannot convert generic types (%s), please build them using getType()", typeStr));
        }
    }

    @Nullable
    private Type getPrimitiveOrVoidType(String typeStr) {
        switch (typeStr) {
            case "byte": {
                return this.getSymtab().byteType;
            }
            case "short": {
                return this.getSymtab().shortType;
            }
            case "int": {
                return this.getSymtab().intType;
            }
            case "long": {
                return this.getSymtab().longType;
            }
            case "float": {
                return this.getSymtab().floatType;
            }
            case "double": {
                return this.getSymtab().doubleType;
            }
            case "boolean": {
                return this.getSymtab().booleanType;
            }
            case "char": {
                return this.getSymtab().charType;
            }
            case "void": {
                return this.getSymtab().voidType;
            }
        }
        return null;
    }

    public boolean isAndroidCompatible() {
        return Options.instance(this.context).getBoolean("androidCompatible");
    }
}

