Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _electron = require('electron');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _utils = require('./utils');

var marked = null;

var PackageCard = (function () {
  function PackageCard(pack, settingsView, packageManager) {
    var options = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];

    _classCallCheck(this, PackageCard);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();

    // It might be useful to either wrap this.pack in a class that has a
    // ::validate method, or add a method here. At the moment I think all cases
    // of malformed package metadata are handled here and in ::content but belt
    // and suspenders, you know
    this.client = this.packageManager.getClient();
    this.type = this.pack.theme ? 'theme' : 'package';
    this.name = this.pack.name;
    this.onSettingsView = options.onSettingsView;

    if (this.pack.latestVersion !== this.pack.version) {
      this.newVersion = this.pack.latestVersion;
    }

    if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
      if (this.pack.apmInstallSource.sha !== this.pack.latestSha) {
        this.newSha = this.pack.latestSha;
      }
    }

    // Default to displaying the download count
    if (!options.stats) {
      options.stats = { downloads: true };
    }

    _etch2['default'].initialize(this);

    this.displayStats(options);
    this.handlePackageEvents();
    this.handleButtonEvents(options);
    this.loadCachedMetadata();

    // themes have no status and cannot be dis/enabled
    if (this.type === 'theme') {
      this.refs.statusIndicator.remove();
      this.refs.enablementButton.remove();
    }

    if (atom.packages.isBundledPackage(this.pack.name)) {
      this.refs.installButtonGroup.remove();
      this.refs.uninstallButton.remove();
    }

    if (!this.newVersion && !this.newSha) {
      this.refs.updateButtonGroup.style.display = 'none';
    }

    this.hasCompatibleVersion = true;
    this.updateInterfaceState();
  }

  _createClass(PackageCard, [{
    key: 'render',
    value: function render() {
      var displayName = (this.pack.gitUrlInfo ? this.pack.gitUrlInfo.project : this.pack.name) || '';
      var owner = (0, _utils.ownerFromRepository)(this.pack.repository);
      var description = this.pack.description || '';

      return _etch2['default'].dom(
        'div',
        { className: 'package-card col-lg-8' },
        _etch2['default'].dom(
          'div',
          { ref: 'statsContainer', className: 'stats pull-right' },
          _etch2['default'].dom(
            'span',
            { ref: 'packageStars', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'stargazerIcon', className: 'icon icon-star' }),
            _etch2['default'].dom('span', { ref: 'stargazerCount', className: 'value' })
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDownloads', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'downloadIcon', className: 'icon icon-cloud-download' }),
            _etch2['default'].dom('span', { ref: 'downloadCount', className: 'value' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'body' },
          _etch2['default'].dom(
            'h4',
            { className: 'card-name' },
            _etch2['default'].dom(
              'a',
              { className: 'package-name', ref: 'packageName' },
              displayName
            ),
            _etch2['default'].dom(
              'span',
              { className: 'package-version' },
              _etch2['default'].dom(
                'span',
                { ref: 'versionValue', className: 'value' },
                String(this.pack.version)
              )
            ),
            _etch2['default'].dom(
              'span',
              { className: 'deprecation-badge highlight-warning inline-block' },
              'Deprecated'
            )
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDescription', className: 'package-description' },
            description
          ),
          _etch2['default'].dom('div', { ref: 'packageMessage', className: 'package-message' })
        ),
        _etch2['default'].dom(
          'div',
          { className: 'meta' },
          _etch2['default'].dom(
            'div',
            { ref: 'metaUserContainer', className: 'meta-user' },
            _etch2['default'].dom(
              'a',
              { ref: 'avatarLink', href: 'https://atom.io/users/' + owner },
              _etch2['default'].dom('img', { ref: 'avatar', className: 'avatar', src: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7' })
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'loginLink', className: 'author', href: 'https://atom.io/users/' + owner },
              owner
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'meta-controls' },
            _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'div',
                { ref: 'updateButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'updateButton' },
                  'Update'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installAlternativeButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installAlternativeButton' },
                  'Install Alternative'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installButton' },
                  'Install'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'packageActionButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-gear settings', ref: 'settingsButton' },
                  'Settings'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-trashcan uninstall-button', ref: 'uninstallButton' },
                  'Uninstall'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-playback-pause enablement', ref: 'enablementButton' },
                  _etch2['default'].dom(
                    'span',
                    { className: 'disable-text' },
                    'Disable'
                  )
                ),
                _etch2['default'].dom('button', { type: 'button', className: 'btn status-indicator', tabIndex: '-1', ref: 'statusIndicator' })
              )
            )
          )
        )
      );
    }
  }, {
    key: 'locateCompatiblePackageVersion',
    value: function locateCompatiblePackageVersion(callback) {
      var _this = this;

      this.packageManager.loadCompatiblePackageVersion(this.pack.name, function (err, pack) {
        if (err != null) {
          console.error(err);
        }

        var packageVersion = pack.version;

        // A compatible version exist, we activate the install button and
        // set this.installablePack so that the install action installs the
        // compatible version of the package.
        if (packageVersion) {
          _this.refs.versionValue.textContent = packageVersion;
          if (packageVersion !== _this.pack.version) {
            _this.refs.versionValue.classList.add('text-warning');
            _this.refs.packageMessage.classList.add('text-warning');
            _this.refs.packageMessage.textContent = 'Version ' + packageVersion + ' is not the latest version available for this package, but it\'s the latest that is compatible with your version of Atom.';
          }

          _this.installablePack = pack;
          _this.hasCompatibleVersion = true;
        } else {
          _this.hasCompatibleVersion = false;
          _this.refs.versionValue.classList.add('text-error');
          _this.refs.packageMessage.classList.add('text-error');
          _this.refs.packageMessage.insertAdjacentText('beforeend', 'There\'s no version of this package that is compatible with your Atom version. The version must satisfy ' + _this.pack.engines.atom + '.');
          console.error('No available version compatible with the installed Atom version: ' + atom.getVersion());
        }

        callback();
      });
    }
  }, {
    key: 'handleButtonEvents',
    value: function handleButtonEvents(options) {
      var _this2 = this;

      if (options && options.onSettingsView) {
        this.refs.settingsButton.style.display = 'none';
      } else {
        (function () {
          var clickHandler = function clickHandler(event) {
            event.stopPropagation();
            _this2.settingsView.showPanel(_this2.pack.name, { back: options ? options.back : null, pack: _this2.pack });
          };

          _this2.element.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.element.removeEventListener('click', clickHandler);
          }));

          _this2.refs.settingsButton.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.refs.settingsButton.removeEventListener('click', clickHandler);
          }));
        })();
      }

      var installButtonClickHandler = function installButtonClickHandler(event) {
        event.stopPropagation();
        _this2.install();
      };
      this.refs.installButton.addEventListener('click', installButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installButton.removeEventListener('click', installButtonClickHandler);
      }));

      var uninstallButtonClickHandler = function uninstallButtonClickHandler(event) {
        event.stopPropagation();
        _this2.uninstall();
      };
      this.refs.uninstallButton.addEventListener('click', uninstallButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.uninstallButton.removeEventListener('click', uninstallButtonClickHandler);
      }));

      var installAlternativeButtonClickHandler = function installAlternativeButtonClickHandler(event) {
        event.stopPropagation();
        _this2.installAlternative();
      };
      this.refs.installAlternativeButton.addEventListener('click', installAlternativeButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installAlternativeButton.removeEventListener('click', installAlternativeButtonClickHandler);
      }));

      var updateButtonClickHandler = function updateButtonClickHandler(event) {
        event.stopPropagation();
        _this2.update().then(function () {
          var buttons = [{
            text: 'Restart',
            onDidClick: function onDidClick() {
              return atom.restartApplication();
            }
          }];

          var oldVersion = '';
          var newVersion = '';

          if (_this2.pack.apmInstallSource && _this2.pack.apmInstallSource.type === 'git') {
            oldVersion = _this2.pack.apmInstallSource.sha.substr(0, 8);
            newVersion = '' + _this2.pack.latestSha.substr(0, 8);
          } else if (_this2.pack.version && _this2.pack.latestVersion) {
            oldVersion = _this2.pack.version;
            newVersion = _this2.pack.latestVersion;
          }

          var detail = '';
          if (oldVersion && newVersion) {
            detail = oldVersion + ' -> ' + newVersion;
          }

          atom.notifications.addSuccess('Restart Atom to complete the update of `' + _this2.pack.name + '`.', {
            dismissable: true, buttons: buttons, detail: detail
          });
        });
      };
      this.refs.updateButton.addEventListener('click', updateButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.updateButton.removeEventListener('click', updateButtonClickHandler);
      }));

      var packageNameClickHandler = function packageNameClickHandler(event) {
        event.stopPropagation();
        var packageType = _this2.pack.theme ? 'themes' : 'packages';
        _electron.shell.openExternal('https://atom.io/' + packageType + '/' + _this2.pack.name);
      };
      this.refs.packageName.addEventListener('click', packageNameClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageName.removeEventListener('click', packageNameClickHandler);
      }));

      var enablementButtonClickHandler = function enablementButtonClickHandler(event) {
        event.stopPropagation();
        event.preventDefault();
        if (_this2.isDisabled()) {
          atom.packages.enablePackage(_this2.pack.name);
        } else {
          atom.packages.disablePackage(_this2.pack.name);
        }
      };
      this.refs.enablementButton.addEventListener('click', enablementButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.enablementButton.removeEventListener('click', enablementButtonClickHandler);
      }));

      var packageMessageClickHandler = function packageMessageClickHandler(event) {
        var target = event.target.closest('a');
        if (target) {
          event.stopPropagation();
          event.preventDefault();
          if (target.href && target.href.startsWith('atom:')) {
            atom.workspace.open(target.href);
          }
        }
      };
      this.refs.packageMessage.addEventListener('click', packageMessageClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageMessage.removeEventListener('click', packageMessageClickHandler);
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'loadCachedMetadata',
    value: function loadCachedMetadata() {
      var _this3 = this;

      this.client.avatar((0, _utils.ownerFromRepository)(this.pack.repository), function (err, avatarPath) {
        if (!err && avatarPath) {
          _this3.refs.avatar.src = 'file://' + avatarPath;
        }
      });

      this.client['package'](this.pack.name, function (err, data) {
        // We don't need to actually handle the error here, we can just skip
        // showing the download count if there's a problem.
        if (!err) {
          if (data == null) {
            data = {};
          }

          if (_this3.pack.apmInstallSource && _this3.pack.apmInstallSource.type === 'git') {
            _this3.refs.downloadIcon.classList.remove('icon-cloud-download');
            _this3.refs.downloadIcon.classList.add('icon-git-branch');
            _this3.refs.downloadCount.textContent = _this3.pack.apmInstallSource.sha.substr(0, 8);
          } else {
            _this3.refs.stargazerCount.textContent = data.stargazers_count ? data.stargazers_count.toLocaleString() : '';
            _this3.refs.downloadCount.textContent = data.downloads ? data.downloads.toLocaleString() : '';
          }
        }
      });
    }
  }, {
    key: 'updateInterfaceState',
    value: function updateInterfaceState() {
      this.refs.versionValue.textContent = (this.installablePack ? this.installablePack.version : null) || this.pack.version;
      if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
        this.refs.downloadCount.textContent = this.pack.apmInstallSource.sha.substr(0, 8);
      }

      this.updateSettingsState();
      this.updateInstalledState();
      this.updateDisabledState();
      this.updateDeprecatedState();
    }
  }, {
    key: 'updateSettingsState',
    value: function updateSettingsState() {
      if (this.hasSettings() && !this.onSettingsView) {
        this.refs.settingsButton.style.display = '';
      } else {
        this.refs.settingsButton.style.display = 'none';
      }
    }

    // Section: disabled state updates

  }, {
    key: 'updateDisabledState',
    value: function updateDisabledState() {
      if (this.isDisabled()) {
        this.displayDisabledState();
      } else if (this.element.classList.contains('disabled')) {
        this.displayEnabledState();
      }
    }
  }, {
    key: 'displayEnabledState',
    value: function displayEnabledState() {
      this.element.classList.remove('disabled');
      if (this.type === 'theme') {
        this.refs.enablementButton.style.display = 'none';
      }
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Disable';
      this.refs.enablementButton.classList.add('icon-playback-pause');
      this.refs.enablementButton.classList.remove('icon-playback-play');
      this.refs.statusIndicator.classList.remove('is-disabled');
    }
  }, {
    key: 'displayDisabledState',
    value: function displayDisabledState() {
      this.element.classList.add('disabled');
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Enable';
      this.refs.enablementButton.classList.add('icon-playback-play');
      this.refs.enablementButton.classList.remove('icon-playback-pause');
      this.refs.statusIndicator.classList.add('is-disabled');
      if (this.isDeprecated()) {
        this.refs.enablementButton.disabled = true;
      } else {
        this.refs.enablementButton.disabled = false;
      }
    }

    // Section: installed state updates

  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.isInstalled()) {
        this.displayInstalledState();
      } else {
        this.displayNotInstalledState();
      }
    }
  }, {
    key: 'displayInstalledState',
    value: function displayInstalledState() {
      if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        if (this.newVersion) {
          this.refs.updateButton.textContent = 'Update to ' + this.newVersion;
        } else if (this.newSha) {
          this.refs.updateButton.textContent = 'Update to ' + this.newSha.substr(0, 8);
        }
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
      }

      this.refs.installButtonGroup.style.display = 'none';
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = '';
      this.refs.uninstallButton.style.display = '';
    }
  }, {
    key: 'displayNotInstalledState',
    value: function displayNotInstalledState() {
      var _this4 = this;

      this.refs.uninstallButton.style.display = 'none';
      var atomVersion = this.packageManager.normalizeVersion(atom.getVersion());
      if (!this.packageManager.satisfiesVersion(atomVersion, this.pack)) {
        this.hasCompatibleVersion = false;
        this.setNotInstalledStateButtons();
        this.locateCompatiblePackageVersion(function () {
          _this4.setNotInstalledStateButtons();
        });
      } else {
        this.setNotInstalledStateButtons();
      }
    }
  }, {
    key: 'setNotInstalledStateButtons',
    value: function setNotInstalledStateButtons() {
      if (!this.hasCompatibleVersion) {
        this.refs.installButtonGroup.style.display = 'none';
        this.refs.updateButtonGroup.style.display = 'none';
      } else if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        this.refs.installButtonGroup.style.display = 'none';
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
        this.refs.installButtonGroup.style.display = '';
      }
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = 'none';
    }

    // Section: deprecated state updates

  }, {
    key: 'updateDeprecatedState',
    value: function updateDeprecatedState() {
      if (this.isDeprecated()) {
        this.displayDeprecatedState();
      } else if (this.element.classList.contains('deprecated')) {
        this.displayUndeprecatedState();
      }
    }
  }, {
    key: 'displayStats',
    value: function displayStats(options) {
      if (options && options.stats && options.stats.downloads) {
        this.refs.packageDownloads.style.display = '';
      } else {
        this.refs.packageDownloads.style.display = 'none';
      }

      if (options && options.stats && options.stats.stars) {
        this.refs.packageStars.style.display = '';
      } else {
        this.refs.packageStars.style.display = 'none';
      }
    }
  }, {
    key: 'displayUndeprecatedState',
    value: function displayUndeprecatedState() {
      this.element.classList.remove('deprecated');
      this.refs.packageMessage.classList.remove('text-warning');
      this.refs.packageMessage.textContent = '';
    }
  }, {
    key: 'displayDeprecatedState',
    value: function displayDeprecatedState() {
      this.element.classList.add('deprecated');
      this.refs.settingsButton.disabled = true;

      var info = this.getDeprecatedPackageMetadata();
      this.refs.packageMessage.classList.add('text-warning');

      var message = null;
      if (info && info.hasDeprecations) {
        message = this.getDeprecationMessage(this.newVersion);
      } else if (info && info.hasAlternative && info.alternative === 'core') {
        message = info.message != null ? info.message : 'The features in `' + this.pack.name + '` have been added to core.';
        message += ' Please uninstall this package.';
        this.refs.settingsButton.remove();
        this.refs.enablementButton.remove();
      } else if (info && info.hasAlternative && info.alternative) {
        var alt = info.alternative;
        var isInstalled = this.isInstalled();
        if (isInstalled && this.packageManager.isPackageInstalled(alt)) {
          message = '`' + this.pack.name + '` has been replaced by `' + alt + '` which is already installed. Please uninstall this package.';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else if (isInstalled) {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installAlternativeButton.textContent = 'Install ' + alt;
          this.refs.installAlternativeButtonGroup.style.display = '';
          this.refs.packageActionButtonGroup.style.display = '';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installButtonGroup.style.display = 'none';
          this.refs.installAlternativeButtonGroup.style.display = 'none';
          this.refs.packageActionButtonGroup.style.display = 'none';
        }
      }

      if (message != null) {
        if (marked == null) {
          marked = require('marked');
        }

        this.refs.packageMessage.innerHTML = marked(message);
      }
    }
  }, {
    key: 'displayGitPackageInstallInformation',
    value: function displayGitPackageInstallInformation() {
      this.refs.metaUserContainer.remove();
      this.refs.statsContainer.remove();
      var gitUrlInfo = this.pack.gitUrlInfo;

      if (gitUrlInfo['default'] === 'shortcut') {
        this.refs.packageDescription.textContent = gitUrlInfo.https();
      } else {
        this.refs.packageDescription.textContent = gitUrlInfo.toString();
      }
      this.refs.installButton.classList.remove('icon-cloud-download');
      this.refs.installButton.classList.add('icon-git-commit');
      this.refs.updateButton.classList.remove('icon-cloud-download');
      this.refs.updateButton.classList.add('icon-git-commit');
    }
  }, {
    key: 'displayAvailableUpdate',
    value: function displayAvailableUpdate(newVersion) {
      this.newVersion = newVersion;
      this.updateInterfaceState();
    }
  }, {
    key: 'getDeprecationMessage',
    value: function getDeprecationMessage(newVersion) {
      var info = this.getDeprecatedPackageMetadata();
      if (!info || !info.hasDeprecations) {
        return;
      }

      if (newVersion) {
        if (this.isDeprecated(newVersion)) {
          return 'An update to `v' + newVersion + '` is available but still contains deprecations.';
        } else {
          return 'An update to `v' + newVersion + '` is available without deprecations.';
        }
      } else {
        if (this.isInstalled()) {
          return info.message != null ? info.message : 'This package has not been loaded due to using deprecated APIs. There is no update available.';
        } else {
          return 'This package has deprecations and is not installable.';
        }
      }
    }
  }, {
    key: 'handlePackageEvents',
    value: function handlePackageEvents() {
      var _this5 = this;

      this.disposables.add(atom.packages.onDidDeactivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.packages.onDidActivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.config.onDidChange('core.disabledPackages', function () {
        _this5.updateDisabledState();
      }));

      this.subscribeToPackageEvent('package-installing theme-installing', function () {
        _this5.updateInterfaceState();
        _this5.refs.installButton.disabled = true;
        _this5.refs.installButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-updating theme-updating', function () {
        _this5.updateInterfaceState();
        _this5.refs.updateButton.disabled = true;
        _this5.refs.updateButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-installing-alternative', function () {
        _this5.updateInterfaceState();
        _this5.refs.installAlternativeButton.disabled = true;
        _this5.refs.installAlternativeButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-uninstalling theme-uninstalling', function () {
        _this5.updateInterfaceState();
        _this5.refs.enablementButton.disabled = true;
        _this5.refs.uninstallButton.disabled = true;
        _this5.refs.uninstallButton.classList.add('is-uninstalling');
      });

      this.subscribeToPackageEvent('package-installed package-install-failed theme-installed theme-install-failed', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var version = loadedPack && loadedPack.metadata ? loadedPack.metadata.version : null;
        if (version) {
          _this5.pack.version = version;
        }
        _this5.refs.installButton.disabled = false;
        _this5.refs.installButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-updated theme-updated', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var metadata = loadedPack ? loadedPack.metadata : null;
        if (metadata && metadata.version) {
          _this5.pack.version = metadata.version;
        }

        if (metadata && metadata.apmInstallSource) {
          _this5.pack.apmInstallSource = metadata.apmInstallSource;
        }

        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-update-failed theme-update-failed', function () {
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-uninstalled package-uninstall-failed theme-uninstalled theme-uninstall-failed', function () {
        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.enablementButton.disabled = false;
        _this5.refs.uninstallButton.disabled = false;
        _this5.refs.uninstallButton.classList.remove('is-uninstalling');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-installed-alternative package-install-alternative-failed', function () {
        _this5.refs.installAlternativeButton.disabled = false;
        _this5.refs.installAlternativeButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });
    }
  }, {
    key: 'isInstalled',
    value: function isInstalled() {
      return this.packageManager.isPackageInstalled(this.pack.name);
    }
  }, {
    key: 'isDisabled',
    value: function isDisabled() {
      return atom.packages.isPackageDisabled(this.pack.name);
    }
  }, {
    key: 'isDeprecated',
    value: function isDeprecated(version) {
      var packVersion = version != null ? version : this.pack.version;
      return atom.packages.isDeprecatedPackage(this.pack.name, packVersion);
    }
  }, {
    key: 'getDeprecatedPackageMetadata',
    value: function getDeprecatedPackageMetadata() {
      return atom.packages.getDeprecatedPackageMetadata(this.pack.name);
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings() {
      return this.packageManager.packageHasSettings(this.pack.name);
    }
  }, {
    key: 'subscribeToPackageEvent',
    value: function subscribeToPackageEvent(event, callback) {
      var _this6 = this;

      this.disposables.add(this.packageManager.on(event, function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;

        if (pack.pack != null) {
          pack = pack.pack;
        }

        var packageName = pack.name;
        if (packageName === _this6.pack.name) {
          callback(pack, error);
        }
      }));
    }

    /*
    Section: Methods that should be on a Package model
    */

  }, {
    key: 'install',
    value: function install() {
      var _this7 = this;

      this.packageManager.install(this.installablePack != null ? this.installablePack : this.pack, function (error) {
        if (error != null) {
          console.error('Installing ' + _this7.type + ' ' + _this7.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        } else {
          // if a package was disabled before installing it, re-enable it
          if (_this7.isDisabled()) {
            atom.packages.enablePackage(_this7.pack.name);
          }
        }
      });
    }
  }, {
    key: 'update',
    value: function update() {
      var _this8 = this;

      if (!this.newVersion && !this.newSha) {
        return Promise.resolve();
      }

      var pack = this.installablePack != null ? this.installablePack : this.pack;
      var version = this.newVersion ? 'v' + this.newVersion : '#' + this.newSha.substr(0, 8);
      return new Promise(function (resolve, reject) {
        _this8.packageManager.update(pack, _this8.newVersion, function (error) {
          if (error != null) {
            atom.assert(false, 'Package update failed', function (assertionError) {
              assertionError.metadata = {
                type: _this8.type,
                name: pack.name,
                version: version,
                errorMessage: error.message,
                errorStack: error.stack,
                errorStderr: error.stderr
              };
            });
            console.error('Updating ' + _this8.type + ' ' + pack.name + ' to ' + version + ' failed:\n', error, error.stderr != null ? error.stderr : '');
            reject(error);
          } else {
            resolve();
          }
        });
      });
    }
  }, {
    key: 'uninstall',
    value: function uninstall() {
      var _this9 = this;

      this.packageManager.uninstall(this.pack, function (error) {
        if (error != null) {
          console.error('Uninstalling ' + _this9.type + ' ' + _this9.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }, {
    key: 'installAlternative',
    value: function installAlternative() {
      var _this10 = this;

      var metadata = this.getDeprecatedPackageMetadata();
      var loadedPack = atom.packages.getLoadedPackage(metadata ? metadata.alternative : null);
      if (!metadata || !metadata.hasAlternative || metadata.alternative === 'core' || loadedPack) {
        return;
      }

      this.packageManager.installAlternative(this.pack, metadata.alternative, function (error, _ref2) {
        var pack = _ref2.pack;
        var alternative = _ref2.alternative;

        if (error != null) {
          console.error('Installing alternative `' + alternative + '` ' + _this10.type + ' for ' + _this10.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }]);

  return PackageCard;
})();

exports['default'] = PackageCard;
module.exports = exports['default'];
/* A transparent gif so there is no "broken border" */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuNDEuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi9wYWNrYWdlLWNhcmQuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztvQkFHOEMsTUFBTTs7d0JBQ2hDLFVBQVU7O29CQUNiLE1BQU07Ozs7cUJBRVcsU0FBUzs7QUFFM0MsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFBOztJQUVJLFdBQVc7QUFDbEIsV0FETyxXQUFXLENBQ2pCLElBQUksRUFBRSxZQUFZLEVBQUUsY0FBYyxFQUFnQjtRQUFkLE9BQU8seURBQUcsRUFBRTs7MEJBRDFDLFdBQVc7O0FBRTVCLFFBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFBO0FBQ2hCLFFBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFBO0FBQ2hDLFFBQUksQ0FBQyxjQUFjLEdBQUcsY0FBYyxDQUFBO0FBQ3BDLFFBQUksQ0FBQyxXQUFXLEdBQUcsK0JBQXlCLENBQUE7Ozs7OztBQU01QyxRQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxFQUFFLENBQUE7QUFDN0MsUUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssR0FBRyxPQUFPLEdBQUcsU0FBUyxDQUFBO0FBQ2pELFFBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUE7QUFDMUIsUUFBSSxDQUFDLGNBQWMsR0FBRyxPQUFPLENBQUMsY0FBYyxDQUFBOztBQUU1QyxRQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxLQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFO0FBQ2pELFVBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUE7S0FDMUM7O0FBRUQsUUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxLQUFLLEtBQUssRUFBRTtBQUMzRSxVQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxLQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFO0FBQzFELFlBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUE7T0FDbEM7S0FDRjs7O0FBR0QsUUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUU7QUFDbEIsYUFBTyxDQUFDLEtBQUssR0FBRyxFQUFDLFNBQVMsRUFBRSxJQUFJLEVBQUMsQ0FBQTtLQUNsQzs7QUFFRCxzQkFBSyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUE7O0FBRXJCLFFBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUE7QUFDMUIsUUFBSSxDQUFDLG1CQUFtQixFQUFFLENBQUE7QUFDMUIsUUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFBO0FBQ2hDLFFBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFBOzs7QUFHekIsUUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLE9BQU8sRUFBRTtBQUN6QixVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtBQUNsQyxVQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxDQUFBO0tBQ3BDOztBQUVELFFBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFO0FBQ2xELFVBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxFQUFFLENBQUE7QUFDckMsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxFQUFFLENBQUE7S0FDbkM7O0FBRUQsUUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFO0FBQ3BDLFVBQUksQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7S0FDbkQ7O0FBRUQsUUFBSSxDQUFDLG9CQUFvQixHQUFHLElBQUksQ0FBQTtBQUNoQyxRQUFJLENBQUMsb0JBQW9CLEVBQUUsQ0FBQTtHQUM1Qjs7ZUF2RGtCLFdBQVc7O1dBeUR2QixrQkFBRztBQUNSLFVBQU0sV0FBVyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFBLElBQUssRUFBRSxDQUFBO0FBQ2hHLFVBQU0sS0FBSyxHQUFHLGdDQUFvQixJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFBO0FBQ3ZELFVBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxJQUFJLEVBQUUsQ0FBQTs7QUFFL0MsYUFDRTs7VUFBSyxTQUFTLEVBQUMsdUJBQXVCO1FBQ3BDOztZQUFLLEdBQUcsRUFBQyxnQkFBZ0IsRUFBQyxTQUFTLEVBQUMsa0JBQWtCO1VBQ3BEOztjQUFNLEdBQUcsRUFBQyxjQUFjLEVBQUMsU0FBUyxFQUFDLFlBQVk7WUFDN0MsZ0NBQU0sR0FBRyxFQUFDLGVBQWUsRUFBQyxTQUFTLEVBQUMsZ0JBQWdCLEdBQUc7WUFDdkQsZ0NBQU0sR0FBRyxFQUFDLGdCQUFnQixFQUFDLFNBQVMsRUFBQyxPQUFPLEdBQUc7V0FDMUM7VUFFUDs7Y0FBTSxHQUFHLEVBQUMsa0JBQWtCLEVBQUMsU0FBUyxFQUFDLFlBQVk7WUFDakQsZ0NBQU0sR0FBRyxFQUFDLGNBQWMsRUFBQyxTQUFTLEVBQUMsMEJBQTBCLEdBQUc7WUFDaEUsZ0NBQU0sR0FBRyxFQUFDLGVBQWUsRUFBQyxTQUFTLEVBQUMsT0FBTyxHQUFHO1dBQ3pDO1NBQ0g7UUFFTjs7WUFBSyxTQUFTLEVBQUMsTUFBTTtVQUNuQjs7Y0FBSSxTQUFTLEVBQUMsV0FBVztZQUN2Qjs7Z0JBQUcsU0FBUyxFQUFDLGNBQWMsRUFBQyxHQUFHLEVBQUMsYUFBYTtjQUFFLFdBQVc7YUFBSztZQUMvRDs7Z0JBQU0sU0FBUyxFQUFDLGlCQUFpQjtjQUMvQjs7a0JBQU0sR0FBRyxFQUFDLGNBQWMsRUFBQyxTQUFTLEVBQUMsT0FBTztnQkFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7ZUFBUTthQUN4RTtZQUVQOztnQkFBTSxTQUFTLEVBQUMsa0RBQWtEOzthQUFrQjtXQUNqRjtVQUNMOztjQUFNLEdBQUcsRUFBQyxvQkFBb0IsRUFBQyxTQUFTLEVBQUMscUJBQXFCO1lBQUUsV0FBVztXQUFRO1VBQ25GLCtCQUFLLEdBQUcsRUFBQyxnQkFBZ0IsRUFBQyxTQUFTLEVBQUMsaUJBQWlCLEdBQUc7U0FDcEQ7UUFFTjs7WUFBSyxTQUFTLEVBQUMsTUFBTTtVQUNuQjs7Y0FBSyxHQUFHLEVBQUMsbUJBQW1CLEVBQUMsU0FBUyxFQUFDLFdBQVc7WUFDaEQ7O2dCQUFHLEdBQUcsRUFBQyxZQUFZLEVBQUMsSUFBSSw2QkFBMkIsS0FBSyxBQUFHO2NBRXpELCtCQUFLLEdBQUcsRUFBQyxRQUFRLEVBQUMsU0FBUyxFQUFDLFFBQVEsRUFBQyxHQUFHLEVBQUMsZ0ZBQWdGLEdBQUc7YUFDMUg7WUFDSjs7Z0JBQUcsR0FBRyxFQUFDLFdBQVcsRUFBQyxTQUFTLEVBQUMsUUFBUSxFQUFDLElBQUksNkJBQTJCLEtBQUssQUFBRztjQUFFLEtBQUs7YUFBSztXQUNyRjtVQUNOOztjQUFLLFNBQVMsRUFBQyxlQUFlO1lBQzVCOztnQkFBSyxTQUFTLEVBQUMsYUFBYTtjQUMxQjs7a0JBQUssR0FBRyxFQUFDLG1CQUFtQixFQUFDLFNBQVMsRUFBQyxXQUFXO2dCQUNoRDs7b0JBQVEsSUFBSSxFQUFDLFFBQVEsRUFBQyxTQUFTLEVBQUMsc0RBQXNELEVBQUMsR0FBRyxFQUFDLGNBQWM7O2lCQUFnQjtlQUNySDtjQUNOOztrQkFBSyxHQUFHLEVBQUMsK0JBQStCLEVBQUMsU0FBUyxFQUFDLFdBQVc7Z0JBQzVEOztvQkFBUSxJQUFJLEVBQUMsUUFBUSxFQUFDLFNBQVMsRUFBQyxzREFBc0QsRUFBQyxHQUFHLEVBQUMsMEJBQTBCOztpQkFBNkI7ZUFDOUk7Y0FDTjs7a0JBQUssR0FBRyxFQUFDLG9CQUFvQixFQUFDLFNBQVMsRUFBQyxXQUFXO2dCQUNqRDs7b0JBQVEsSUFBSSxFQUFDLFFBQVEsRUFBQyxTQUFTLEVBQUMsc0RBQXNELEVBQUMsR0FBRyxFQUFDLGVBQWU7O2lCQUFpQjtlQUN2SDtjQUNOOztrQkFBSyxHQUFHLEVBQUMsMEJBQTBCLEVBQUMsU0FBUyxFQUFDLFdBQVc7Z0JBQ3ZEOztvQkFBUSxJQUFJLEVBQUMsUUFBUSxFQUFDLFNBQVMsRUFBQyw2QkFBNkIsRUFBQyxHQUFHLEVBQUMsZ0JBQWdCOztpQkFBa0I7Z0JBQ3BHOztvQkFBUSxJQUFJLEVBQUMsUUFBUSxFQUFDLFNBQVMsRUFBQyx5Q0FBeUMsRUFBQyxHQUFHLEVBQUMsaUJBQWlCOztpQkFBbUI7Z0JBQ2xIOztvQkFBUSxJQUFJLEVBQUMsUUFBUSxFQUFDLFNBQVMsRUFBQyx5Q0FBeUMsRUFBQyxHQUFHLEVBQUMsa0JBQWtCO2tCQUM5Rjs7c0JBQU0sU0FBUyxFQUFDLGNBQWM7O21CQUFlO2lCQUN0QztnQkFDVCxrQ0FBUSxJQUFJLEVBQUMsUUFBUSxFQUFDLFNBQVMsRUFBQyxzQkFBc0IsRUFBQyxRQUFRLEVBQUMsSUFBSSxFQUFDLEdBQUcsRUFBQyxpQkFBaUIsR0FBRztlQUN6RjthQUNGO1dBQ0Y7U0FDRjtPQUNGLENBQ1A7S0FDRjs7O1dBRThCLHdDQUFDLFFBQVEsRUFBRTs7O0FBQ3hDLFVBQUksQ0FBQyxjQUFjLENBQUMsNEJBQTRCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsVUFBQyxHQUFHLEVBQUUsSUFBSSxFQUFLO0FBQzlFLFlBQUksR0FBRyxJQUFJLElBQUksRUFBRTtBQUNmLGlCQUFPLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFBO1NBQ25COztBQUVELFlBQU0sY0FBYyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUE7Ozs7O0FBS25DLFlBQUksY0FBYyxFQUFFO0FBQ2xCLGdCQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsV0FBVyxHQUFHLGNBQWMsQ0FBQTtBQUNuRCxjQUFJLGNBQWMsS0FBSyxNQUFLLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDeEMsa0JBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFBO0FBQ3BELGtCQUFLLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQTtBQUN0RCxrQkFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsZ0JBQWMsY0FBYyw4SEFBMEgsQ0FBQTtXQUMzTDs7QUFFRCxnQkFBSyxlQUFlLEdBQUcsSUFBSSxDQUFBO0FBQzNCLGdCQUFLLG9CQUFvQixHQUFHLElBQUksQ0FBQTtTQUNqQyxNQUFNO0FBQ0wsZ0JBQUssb0JBQW9CLEdBQUcsS0FBSyxDQUFBO0FBQ2pDLGdCQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQTtBQUNsRCxnQkFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLENBQUE7QUFDcEQsZ0JBQUssSUFBSSxDQUFDLGNBQWMsQ0FBQyxrQkFBa0IsQ0FDekMsV0FBVywrR0FDK0YsTUFBSyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksT0FDakksQ0FBQTtBQUNELGlCQUFPLENBQUMsS0FBSyx1RUFBcUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFHLENBQUE7U0FDdkc7O0FBRUQsZ0JBQVEsRUFBRSxDQUFBO09BQ1gsQ0FBQyxDQUFBO0tBQ0g7OztXQUVrQiw0QkFBQyxPQUFPLEVBQUU7OztBQUMzQixVQUFJLE9BQU8sSUFBSSxPQUFPLENBQUMsY0FBYyxFQUFFO0FBQ3JDLFlBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ2hELE1BQU07O0FBQ0wsY0FBTSxZQUFZLEdBQUcsU0FBZixZQUFZLENBQUksS0FBSyxFQUFLO0FBQzlCLGlCQUFLLENBQUMsZUFBZSxFQUFFLENBQUE7QUFDdkIsbUJBQUssWUFBWSxDQUFDLFNBQVMsQ0FBQyxPQUFLLElBQUksQ0FBQyxJQUFJLEVBQUUsRUFBQyxJQUFJLEVBQUUsT0FBTyxHQUFHLE9BQU8sQ0FBQyxJQUFJLEdBQUcsSUFBSSxFQUFFLElBQUksRUFBRSxPQUFLLElBQUksRUFBQyxDQUFDLENBQUE7V0FDcEcsQ0FBQTs7QUFFRCxpQkFBSyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFBO0FBQ3BELGlCQUFLLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLG1CQUFLLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7V0FBRSxDQUFDLENBQUMsQ0FBQTs7QUFFdkcsaUJBQUssSUFBSSxDQUFDLGNBQWMsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7QUFDaEUsaUJBQUssV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsbUJBQUssSUFBSSxDQUFDLGNBQWMsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7V0FBRSxDQUFDLENBQUMsQ0FBQTs7T0FDcEg7O0FBRUQsVUFBTSx5QkFBeUIsR0FBRyxTQUE1Qix5QkFBeUIsQ0FBSSxLQUFLLEVBQUs7QUFDM0MsYUFBSyxDQUFDLGVBQWUsRUFBRSxDQUFBO0FBQ3ZCLGVBQUssT0FBTyxFQUFFLENBQUE7T0FDZixDQUFBO0FBQ0QsVUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLHlCQUF5QixDQUFDLENBQUE7QUFDNUUsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLGVBQUssSUFBSSxDQUFDLGFBQWEsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUseUJBQXlCLENBQUMsQ0FBQTtPQUFFLENBQUMsQ0FBQyxDQUFBOztBQUUvSCxVQUFNLDJCQUEyQixHQUFHLFNBQTlCLDJCQUEyQixDQUFJLEtBQUssRUFBSztBQUM3QyxhQUFLLENBQUMsZUFBZSxFQUFFLENBQUE7QUFDdkIsZUFBSyxTQUFTLEVBQUUsQ0FBQTtPQUNqQixDQUFBO0FBQ0QsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLDJCQUEyQixDQUFDLENBQUE7QUFDaEYsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLGVBQUssSUFBSSxDQUFDLGVBQWUsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsMkJBQTJCLENBQUMsQ0FBQTtPQUFFLENBQUMsQ0FBQyxDQUFBOztBQUVuSSxVQUFNLG9DQUFvQyxHQUFHLFNBQXZDLG9DQUFvQyxDQUFJLEtBQUssRUFBSztBQUN0RCxhQUFLLENBQUMsZUFBZSxFQUFFLENBQUE7QUFDdkIsZUFBSyxrQkFBa0IsRUFBRSxDQUFBO09BQzFCLENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSxvQ0FBb0MsQ0FBQyxDQUFBO0FBQ2xHLFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFBRSxlQUFLLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsb0NBQW9DLENBQUMsQ0FBQTtPQUFFLENBQUMsQ0FBQyxDQUFBOztBQUVySixVQUFNLHdCQUF3QixHQUFHLFNBQTNCLHdCQUF3QixDQUFJLEtBQUssRUFBSztBQUMxQyxhQUFLLENBQUMsZUFBZSxFQUFFLENBQUE7QUFDdkIsZUFBSyxNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsWUFBTTtBQUN2QixjQUFNLE9BQU8sR0FBRyxDQUFDO0FBQ2YsZ0JBQUksRUFBRSxTQUFTO0FBQ2Ysc0JBQVUsRUFBQyxzQkFBRztBQUFFLHFCQUFPLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFBO2FBQUU7V0FDbkQsQ0FBQyxDQUFBOztBQUVGLGNBQUksVUFBVSxHQUFHLEVBQUUsQ0FBQTtBQUNuQixjQUFJLFVBQVUsR0FBRyxFQUFFLENBQUE7O0FBRW5CLGNBQUksT0FBSyxJQUFJLENBQUMsZ0JBQWdCLElBQUksT0FBSyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxLQUFLLEtBQUssRUFBRTtBQUMzRSxzQkFBVSxHQUFHLE9BQUssSUFBSSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFBO0FBQ3hELHNCQUFVLFFBQU0sT0FBSyxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEFBQUUsQ0FBQTtXQUNuRCxNQUFNLElBQUksT0FBSyxJQUFJLENBQUMsT0FBTyxJQUFJLE9BQUssSUFBSSxDQUFDLGFBQWEsRUFBRTtBQUN2RCxzQkFBVSxHQUFHLE9BQUssSUFBSSxDQUFDLE9BQU8sQ0FBQTtBQUM5QixzQkFBVSxHQUFHLE9BQUssSUFBSSxDQUFDLGFBQWEsQ0FBQTtXQUNyQzs7QUFFRCxjQUFJLE1BQU0sR0FBRyxFQUFFLENBQUE7QUFDZixjQUFJLFVBQVUsSUFBSSxVQUFVLEVBQUU7QUFDNUIsa0JBQU0sR0FBTSxVQUFVLFlBQU8sVUFBVSxBQUFFLENBQUE7V0FDMUM7O0FBRUQsY0FBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLDhDQUE2QyxPQUFLLElBQUksQ0FBQyxJQUFJLFNBQU87QUFDN0YsdUJBQVcsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFQLE9BQU8sRUFBRSxNQUFNLEVBQU4sTUFBTTtXQUNuQyxDQUFDLENBQUE7U0FDSCxDQUFDLENBQUE7T0FDSCxDQUFBO0FBQ0QsVUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxFQUFFLHdCQUF3QixDQUFDLENBQUE7QUFDMUUsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMscUJBQWUsWUFBTTtBQUFFLGVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsd0JBQXdCLENBQUMsQ0FBQTtPQUFFLENBQUMsQ0FBQyxDQUFBOztBQUU3SCxVQUFNLHVCQUF1QixHQUFHLFNBQTFCLHVCQUF1QixDQUFJLEtBQUssRUFBSztBQUN6QyxhQUFLLENBQUMsZUFBZSxFQUFFLENBQUE7QUFDdkIsWUFBTSxXQUFXLEdBQUcsT0FBSyxJQUFJLENBQUMsS0FBSyxHQUFHLFFBQVEsR0FBRyxVQUFVLENBQUE7QUFDM0Qsd0JBQU0sWUFBWSxzQkFBb0IsV0FBVyxTQUFJLE9BQUssSUFBSSxDQUFDLElBQUksQ0FBRyxDQUFBO09BQ3ZFLENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsdUJBQXVCLENBQUMsQ0FBQTtBQUN4RSxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsZUFBSyxJQUFJLENBQUMsV0FBVyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSx1QkFBdUIsQ0FBQyxDQUFBO09BQUUsQ0FBQyxDQUFDLENBQUE7O0FBRTNILFVBQU0sNEJBQTRCLEdBQUcsU0FBL0IsNEJBQTRCLENBQUksS0FBSyxFQUFLO0FBQzlDLGFBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixhQUFLLENBQUMsY0FBYyxFQUFFLENBQUE7QUFDdEIsWUFBSSxPQUFLLFVBQVUsRUFBRSxFQUFFO0FBQ3JCLGNBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLE9BQUssSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO1NBQzVDLE1BQU07QUFDTCxjQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxPQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQTtTQUM3QztPQUNGLENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGdCQUFnQixDQUFDLE9BQU8sRUFBRSw0QkFBNEIsQ0FBQyxDQUFBO0FBQ2xGLFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLHFCQUFlLFlBQU07QUFBRSxlQUFLLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsNEJBQTRCLENBQUMsQ0FBQTtPQUFFLENBQUMsQ0FBQyxDQUFBOztBQUVySSxVQUFNLDBCQUEwQixHQUFHLFNBQTdCLDBCQUEwQixDQUFJLEtBQUssRUFBSztBQUM1QyxZQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQTtBQUN4QyxZQUFJLE1BQU0sRUFBRTtBQUNWLGVBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixlQUFLLENBQUMsY0FBYyxFQUFFLENBQUE7QUFDdEIsY0FBSSxNQUFNLENBQUMsSUFBSSxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxFQUFFO0FBQ2xELGdCQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUE7V0FDakM7U0FDRjtPQUNGLENBQUE7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsMEJBQTBCLENBQUMsQ0FBQTtBQUM5RSxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxxQkFBZSxZQUFNO0FBQUUsZUFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSwwQkFBMEIsQ0FBQyxDQUFBO09BQUUsQ0FBQyxDQUFDLENBQUE7S0FDbEk7OztXQUVPLG1CQUFHO0FBQ1QsVUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtBQUMxQixhQUFPLGtCQUFLLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQTtLQUMxQjs7O1dBRWtCLDhCQUFHOzs7QUFDcEIsVUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsZ0NBQW9CLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEVBQUUsVUFBQyxHQUFHLEVBQUUsVUFBVSxFQUFLO0FBQ2pGLFlBQUksQ0FBQyxHQUFHLElBQUksVUFBVSxFQUFFO0FBQ3RCLGlCQUFLLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxlQUFhLFVBQVUsQUFBRSxDQUFBO1NBQzlDO09BQ0YsQ0FBQyxDQUFBOztBQUVGLFVBQUksQ0FBQyxNQUFNLFdBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxVQUFDLEdBQUcsRUFBRSxJQUFJLEVBQUs7OztBQUdqRCxZQUFJLENBQUMsR0FBRyxFQUFFO0FBQ1IsY0FBSSxJQUFJLElBQUksSUFBSSxFQUFFO0FBQ2hCLGdCQUFJLEdBQUcsRUFBRSxDQUFBO1dBQ1Y7O0FBRUQsY0FBSSxPQUFLLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxPQUFLLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEtBQUssS0FBSyxFQUFFO0FBQzNFLG1CQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFBO0FBQzlELG1CQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFBO0FBQ3ZELG1CQUFLLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxHQUFHLE9BQUssSUFBSSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFBO1dBQ2xGLE1BQU07QUFDTCxtQkFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGNBQWMsRUFBRSxHQUFHLEVBQUUsQ0FBQTtBQUMxRyxtQkFBSyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsY0FBYyxFQUFFLEdBQUcsRUFBRSxDQUFBO1dBQzVGO1NBQ0Y7T0FDRixDQUFDLENBQUE7S0FDSDs7O1dBRW9CLGdDQUFHO0FBQ3RCLFVBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFdBQVcsR0FBRyxDQUFDLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFBLElBQUssSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUE7QUFDdEgsVUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxLQUFLLEtBQUssRUFBRTtBQUMzRSxZQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQTtPQUNsRjs7QUFFRCxVQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQTtBQUMxQixVQUFJLENBQUMsb0JBQW9CLEVBQUUsQ0FBQTtBQUMzQixVQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQTtBQUMxQixVQUFJLENBQUMscUJBQXFCLEVBQUUsQ0FBQTtLQUM3Qjs7O1dBRW1CLCtCQUFHO0FBQ3JCLFVBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRTtBQUM5QyxZQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtPQUM1QyxNQUFNO0FBQ0wsWUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDaEQ7S0FDRjs7Ozs7O1dBSW1CLCtCQUFHO0FBQ3JCLFVBQUksSUFBSSxDQUFDLFVBQVUsRUFBRSxFQUFFO0FBQ3JCLFlBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFBO09BQzVCLE1BQU0sSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLEVBQUU7QUFDdEQsWUFBSSxDQUFDLG1CQUFtQixFQUFFLENBQUE7T0FDM0I7S0FDRjs7O1dBRW1CLCtCQUFHO0FBQ3JCLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsQ0FBQTtBQUN6QyxVQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssT0FBTyxFQUFFO0FBQ3pCLFlBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDbEQ7QUFDRCxVQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsQ0FBQyxlQUFlLENBQUMsQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFBO0FBQ2pGLFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFBO0FBQy9ELFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFBO0FBQ2pFLFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLENBQUE7S0FDMUQ7OztXQUVvQixnQ0FBRztBQUN0QixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLENBQUE7QUFDdEMsVUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUMsZUFBZSxDQUFDLENBQUMsV0FBVyxHQUFHLFFBQVEsQ0FBQTtBQUNoRixVQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsb0JBQW9CLENBQUMsQ0FBQTtBQUM5RCxVQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMscUJBQXFCLENBQUMsQ0FBQTtBQUNsRSxVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFBO0FBQ3RELFVBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxFQUFFO0FBQ3ZCLFlBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtPQUMzQyxNQUFNO0FBQ0wsWUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO09BQzVDO0tBQ0Y7Ozs7OztXQUlvQixnQ0FBRztBQUN0QixVQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsRUFBRTtBQUN0QixZQUFJLENBQUMscUJBQXFCLEVBQUUsQ0FBQTtPQUM3QixNQUFNO0FBQ0wsWUFBSSxDQUFDLHdCQUF3QixFQUFFLENBQUE7T0FDaEM7S0FDRjs7O1dBRXFCLGlDQUFHO0FBQ3ZCLFVBQUksSUFBSSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFO0FBQ2xDLFlBQUksQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7QUFDOUMsWUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFO0FBQ25CLGNBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFdBQVcsa0JBQWdCLElBQUksQ0FBQyxVQUFVLEFBQUUsQ0FBQTtTQUNwRSxNQUFNLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRTtBQUN0QixjQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxXQUFXLGtCQUFnQixJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEFBQUUsQ0FBQTtTQUM3RTtPQUNGLE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ25EOztBQUVELFVBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDbkQsVUFBSSxDQUFDLElBQUksQ0FBQyw2QkFBNkIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUM5RCxVQUFJLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO0FBQ3JELFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO0tBQzdDOzs7V0FFd0Isb0NBQUc7OztBQUMxQixVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUNoRCxVQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFBO0FBQzNFLFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLGdCQUFnQixDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUU7QUFDakUsWUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQTtBQUNqQyxZQUFJLENBQUMsMkJBQTJCLEVBQUUsQ0FBQTtBQUNsQyxZQUFJLENBQUMsOEJBQThCLENBQUMsWUFBTTtBQUFFLGlCQUFLLDJCQUEyQixFQUFFLENBQUE7U0FBRSxDQUFDLENBQUE7T0FDbEYsTUFBTTtBQUNMLFlBQUksQ0FBQywyQkFBMkIsRUFBRSxDQUFBO09BQ25DO0tBQ0Y7OztXQUUyQix1Q0FBRztBQUM3QixVQUFJLENBQUMsSUFBSSxDQUFDLG9CQUFvQixFQUFFO0FBQzlCLFlBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDbkQsWUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtPQUNuRCxNQUFNLElBQUksSUFBSSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFO0FBQ3pDLFlBQUksQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7QUFDOUMsWUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtPQUNwRCxNQUFNO0FBQ0wsWUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUNsRCxZQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO09BQ2hEO0FBQ0QsVUFBSSxDQUFDLElBQUksQ0FBQyw2QkFBNkIsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUM5RCxVQUFJLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0tBQzFEOzs7Ozs7V0FJcUIsaUNBQUc7QUFDdkIsVUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLEVBQUU7QUFDdkIsWUFBSSxDQUFDLHNCQUFzQixFQUFFLENBQUE7T0FDOUIsTUFBTSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxZQUFZLENBQUMsRUFBRTtBQUN4RCxZQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQTtPQUNoQztLQUNGOzs7V0FFWSxzQkFBQyxPQUFPLEVBQUU7QUFDckIsVUFBSSxPQUFPLElBQUksT0FBTyxDQUFDLEtBQUssSUFBSSxPQUFPLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRTtBQUN2RCxZQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO09BQzlDLE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ2xEOztBQUVELFVBQUksT0FBTyxJQUFJLE9BQU8sQ0FBQyxLQUFLLElBQUksT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUU7QUFDbkQsWUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7T0FDMUMsTUFBTTtBQUNMLFlBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQzlDO0tBQ0Y7OztXQUV3QixvQ0FBRztBQUMxQixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLENBQUE7QUFDM0MsVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQTtBQUN6RCxVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLEdBQUcsRUFBRSxDQUFBO0tBQzFDOzs7V0FFc0Isa0NBQUc7QUFDeEIsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxDQUFBO0FBQ3hDLFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7O0FBRXhDLFVBQU0sSUFBSSxHQUFHLElBQUksQ0FBQyw0QkFBNEIsRUFBRSxDQUFBO0FBQ2hELFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUE7O0FBRXRELFVBQUksT0FBTyxHQUFHLElBQUksQ0FBQTtBQUNsQixVQUFJLElBQUksSUFBSSxJQUFJLENBQUMsZUFBZSxFQUFFO0FBQ2hDLGVBQU8sR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFBO09BQ3RELE1BQU0sSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsV0FBVyxLQUFLLE1BQU0sRUFBRTtBQUNyRSxlQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDLE9BQU8seUJBQXdCLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSwrQkFBNkIsQ0FBQTtBQUNoSCxlQUFPLElBQUksaUNBQWlDLENBQUE7QUFDNUMsWUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxFQUFFLENBQUE7QUFDakMsWUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtPQUNwQyxNQUFNLElBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRTtBQUMxRCxZQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFBO0FBQzVCLFlBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQTtBQUN0QyxZQUFJLFdBQVcsSUFBSSxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxFQUFFO0FBQzlELGlCQUFPLFNBQVEsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLGdDQUE2QixHQUFHLGlFQUErRCxDQUFBO0FBQzVILGNBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLE1BQU0sRUFBRSxDQUFBO0FBQ2pDLGNBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxFQUFFLENBQUE7U0FDcEMsTUFBTSxJQUFJLFdBQVcsRUFBRTtBQUN0QixpQkFBTyxTQUFRLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxpQ0FBOEIsR0FBRyx5Q0FBcUMsR0FBRyxPQUFJLENBQUE7QUFDMUcsY0FBSSxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxXQUFXLGdCQUFjLEdBQUcsQUFBRSxDQUFBO0FBQ2pFLGNBQUksQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7QUFDMUQsY0FBSSxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtBQUNyRCxjQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtBQUNqQyxjQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxDQUFBO1NBQ3BDLE1BQU07QUFDTCxpQkFBTyxTQUFRLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxpQ0FBOEIsR0FBRyx5Q0FBcUMsR0FBRyxPQUFJLENBQUE7QUFDMUcsY0FBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUNuRCxjQUFJLENBQUMsSUFBSSxDQUFDLDZCQUE2QixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQzlELGNBQUksQ0FBQyxJQUFJLENBQUMsd0JBQXdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7U0FDMUQ7T0FDRjs7QUFFRCxVQUFJLE9BQU8sSUFBSSxJQUFJLEVBQUU7QUFDbkIsWUFBSSxNQUFNLElBQUksSUFBSSxFQUFFO0FBQ2xCLGdCQUFNLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFBO1NBQzNCOztBQUVELFlBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDckQ7S0FDRjs7O1dBRW1DLCtDQUFHO0FBQ3JDLFVBQUksQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLENBQUE7QUFDcEMsVUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxFQUFFLENBQUE7VUFDMUIsVUFBVSxHQUFJLElBQUksQ0FBQyxJQUFJLENBQXZCLFVBQVU7O0FBQ2pCLFVBQUksVUFBVSxXQUFRLEtBQUssVUFBVSxFQUFFO0FBQ3JDLFlBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxHQUFHLFVBQVUsQ0FBQyxLQUFLLEVBQUUsQ0FBQTtPQUM5RCxNQUFNO0FBQ0wsWUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLEdBQUcsVUFBVSxDQUFDLFFBQVEsRUFBRSxDQUFBO09BQ2pFO0FBQ0QsVUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFBO0FBQy9ELFVBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQTtBQUN4RCxVQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUE7QUFDOUQsVUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFBO0tBQ3hEOzs7V0FFc0IsZ0NBQUMsVUFBVSxFQUFFO0FBQ2xDLFVBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFBO0FBQzVCLFVBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFBO0tBQzVCOzs7V0FFcUIsK0JBQUMsVUFBVSxFQUFFO0FBQ2pDLFVBQU0sSUFBSSxHQUFHLElBQUksQ0FBQyw0QkFBNEIsRUFBRSxDQUFBO0FBQ2hELFVBQUksQ0FBQyxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFO0FBQ2xDLGVBQU07T0FDUDs7QUFFRCxVQUFJLFVBQVUsRUFBRTtBQUNkLFlBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxVQUFVLENBQUMsRUFBRTtBQUNqQyxxQ0FBMEIsVUFBVSxxREFBa0Q7U0FDdkYsTUFBTTtBQUNMLHFDQUEwQixVQUFVLDBDQUF1QztTQUM1RTtPQUNGLE1BQU07QUFDTCxZQUFJLElBQUksQ0FBQyxXQUFXLEVBQUUsRUFBRTtBQUN0QixpQkFBTyxJQUFJLENBQUMsT0FBTyxJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsT0FBTyxHQUFHLDhGQUE4RixDQUFBO1NBQzVJLE1BQU07QUFDTCxpQkFBTyx1REFBdUQsQ0FBQTtTQUMvRDtPQUNGO0tBQ0Y7OztXQUVtQiwrQkFBRzs7O0FBQ3JCLFVBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsc0JBQXNCLENBQUMsVUFBQyxJQUFJLEVBQUs7QUFDbEUsWUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLE9BQUssSUFBSSxDQUFDLElBQUksRUFBRTtBQUNoQyxpQkFBSyxtQkFBbUIsRUFBRSxDQUFBO1NBQzNCO09BQ0YsQ0FBQyxDQUFDLENBQUE7O0FBRUgsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxvQkFBb0IsQ0FBQyxVQUFDLElBQUksRUFBSztBQUNoRSxZQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssT0FBSyxJQUFJLENBQUMsSUFBSSxFQUFFO0FBQ2hDLGlCQUFLLG1CQUFtQixFQUFFLENBQUE7U0FDM0I7T0FDRixDQUFDLENBQUMsQ0FBQTs7QUFFSCxVQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyx1QkFBdUIsRUFBRSxZQUFNO0FBQzFFLGVBQUssbUJBQW1CLEVBQUUsQ0FBQTtPQUMzQixDQUFDLENBQUMsQ0FBQTs7QUFFSCxVQUFJLENBQUMsdUJBQXVCLENBQUMscUNBQXFDLEVBQUUsWUFBTTtBQUN4RSxlQUFLLG9CQUFvQixFQUFFLENBQUE7QUFDM0IsZUFBSyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDdkMsZUFBSyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUE7T0FDdkQsQ0FBQyxDQUFBOztBQUVGLFVBQUksQ0FBQyx1QkFBdUIsQ0FBQyxpQ0FBaUMsRUFBRSxZQUFNO0FBQ3BFLGVBQUssb0JBQW9CLEVBQUUsQ0FBQTtBQUMzQixlQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUN0QyxlQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQTtPQUN0RCxDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLHVCQUF1QixDQUFDLGdDQUFnQyxFQUFFLFlBQU07QUFDbkUsZUFBSyxvQkFBb0IsRUFBRSxDQUFBO0FBQzNCLGVBQUssSUFBSSxDQUFDLHdCQUF3QixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDbEQsZUFBSyxJQUFJLENBQUMsd0JBQXdCLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQTtPQUNsRSxDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLHVCQUF1QixDQUFDLHlDQUF5QyxFQUFFLFlBQU07QUFDNUUsZUFBSyxvQkFBb0IsRUFBRSxDQUFBO0FBQzNCLGVBQUssSUFBSSxDQUFDLGdCQUFnQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDMUMsZUFBSyxJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDekMsZUFBSyxJQUFJLENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQTtPQUMzRCxDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLHVCQUF1QixDQUFDLCtFQUErRSxFQUFFLFlBQU07QUFDbEgsWUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUNqRSxZQUFNLE9BQU8sR0FBRyxVQUFVLElBQUksVUFBVSxDQUFDLFFBQVEsR0FBRyxVQUFVLENBQUMsUUFBUSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUE7QUFDdEYsWUFBSSxPQUFPLEVBQUU7QUFDWCxpQkFBSyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQTtTQUM1QjtBQUNELGVBQUssSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO0FBQ3hDLGVBQUssSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxDQUFBO0FBQ3pELGVBQUssb0JBQW9CLEVBQUUsQ0FBQTtPQUM1QixDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLHVCQUF1QixDQUFDLCtCQUErQixFQUFFLFlBQU07QUFDbEUsWUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUNqRSxZQUFNLFFBQVEsR0FBRyxVQUFVLEdBQUcsVUFBVSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDeEQsWUFBSSxRQUFRLElBQUksUUFBUSxDQUFDLE9BQU8sRUFBRTtBQUNoQyxpQkFBSyxJQUFJLENBQUMsT0FBTyxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUE7U0FDckM7O0FBRUQsWUFBSSxRQUFRLElBQUksUUFBUSxDQUFDLGdCQUFnQixFQUFFO0FBQ3pDLGlCQUFLLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxRQUFRLENBQUMsZ0JBQWdCLENBQUE7U0FDdkQ7O0FBRUQsZUFBSyxVQUFVLEdBQUcsSUFBSSxDQUFBO0FBQ3RCLGVBQUssTUFBTSxHQUFHLElBQUksQ0FBQTtBQUNsQixlQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQTtBQUN2QyxlQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxlQUFlLENBQUMsQ0FBQTtBQUN4RCxlQUFLLG9CQUFvQixFQUFFLENBQUE7T0FDNUIsQ0FBQyxDQUFBOztBQUVGLFVBQUksQ0FBQyx1QkFBdUIsQ0FBQywyQ0FBMkMsRUFBRSxZQUFNO0FBQzlFLGVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO0FBQ3ZDLGVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxDQUFBO0FBQ3hELGVBQUssb0JBQW9CLEVBQUUsQ0FBQTtPQUM1QixDQUFDLENBQUE7O0FBRUYsVUFBSSxDQUFDLHVCQUF1QixDQUFDLHVGQUF1RixFQUFFLFlBQU07QUFDMUgsZUFBSyxVQUFVLEdBQUcsSUFBSSxDQUFBO0FBQ3RCLGVBQUssTUFBTSxHQUFHLElBQUksQ0FBQTtBQUNsQixlQUFLLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO0FBQzNDLGVBQUssSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO0FBQzFDLGVBQUssSUFBSSxDQUFDLGVBQWUsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLENBQUE7QUFDN0QsZUFBSyxvQkFBb0IsRUFBRSxDQUFBO09BQzVCLENBQUMsQ0FBQTs7QUFFRixVQUFJLENBQUMsdUJBQXVCLENBQUMsa0VBQWtFLEVBQUUsWUFBTTtBQUNyRyxlQUFLLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO0FBQ25ELGVBQUssSUFBSSxDQUFDLHdCQUF3QixDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUE7QUFDcEUsZUFBSyxvQkFBb0IsRUFBRSxDQUFBO09BQzVCLENBQUMsQ0FBQTtLQUNIOzs7V0FFVyx1QkFBRztBQUNiLGFBQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzlEOzs7V0FFVSxzQkFBRztBQUNaLGFBQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQ3ZEOzs7V0FFWSxzQkFBQyxPQUFPLEVBQUU7QUFDckIsVUFBTSxXQUFXLEdBQUcsT0FBTyxJQUFJLElBQUksR0FBRyxPQUFPLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUE7QUFDakUsYUFBTyxJQUFJLENBQUMsUUFBUSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLFdBQVcsQ0FBQyxDQUFBO0tBQ3RFOzs7V0FFNEIsd0NBQUc7QUFDOUIsYUFBTyxJQUFJLENBQUMsUUFBUSxDQUFDLDRCQUE0QixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDbEU7OztXQUVXLHVCQUFHO0FBQ2IsYUFBTyxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDOUQ7OztXQUV1QixpQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFOzs7QUFDeEMsVUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFLENBQUMsS0FBSyxFQUFFLFVBQUMsSUFBYSxFQUFLO1lBQWpCLElBQUksR0FBTCxJQUFhLENBQVosSUFBSTtZQUFFLEtBQUssR0FBWixJQUFhLENBQU4sS0FBSzs7QUFDOUQsWUFBSSxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksRUFBRTtBQUNyQixjQUFJLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQTtTQUNqQjs7QUFFRCxZQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFBO0FBQzdCLFlBQUksV0FBVyxLQUFLLE9BQUssSUFBSSxDQUFDLElBQUksRUFBRTtBQUNsQyxrQkFBUSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQTtTQUN0QjtPQUNGLENBQUMsQ0FBQyxDQUFBO0tBQ0o7Ozs7Ozs7O1dBTU8sbUJBQUc7OztBQUNULFVBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxlQUFlLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLElBQUksRUFBRSxVQUFDLEtBQUssRUFBSztBQUN0RyxZQUFJLEtBQUssSUFBSSxJQUFJLEVBQUU7QUFDakIsaUJBQU8sQ0FBQyxLQUFLLGlCQUFlLE9BQUssSUFBSSxTQUFJLE9BQUssSUFBSSxDQUFDLElBQUksY0FBVyxLQUFLLENBQUMsS0FBSyxJQUFJLElBQUksR0FBRyxLQUFLLENBQUMsS0FBSyxHQUFHLEtBQUssRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUE7U0FDM0gsTUFBTTs7QUFFTCxjQUFJLE9BQUssVUFBVSxFQUFFLEVBQUU7QUFDckIsZ0JBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLE9BQUssSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFBO1dBQzVDO1NBQ0Y7T0FDRixDQUFDLENBQUE7S0FDSDs7O1dBRU0sa0JBQUc7OztBQUNSLFVBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRTtBQUNwQyxlQUFPLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQTtPQUN6Qjs7QUFFRCxVQUFNLElBQUksR0FBRyxJQUFJLENBQUMsZUFBZSxJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUE7QUFDNUUsVUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLFVBQVUsU0FBTyxJQUFJLENBQUMsVUFBVSxTQUFTLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQUFBRSxDQUFBO0FBQ3hGLGFBQU8sSUFBSSxPQUFPLENBQUMsVUFBQyxPQUFPLEVBQUUsTUFBTSxFQUFLO0FBQ3RDLGVBQUssY0FBYyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsT0FBSyxVQUFVLEVBQUUsVUFBQSxLQUFLLEVBQUk7QUFDekQsY0FBSSxLQUFLLElBQUksSUFBSSxFQUFFO0FBQ2pCLGdCQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSx1QkFBdUIsRUFBRSxVQUFBLGNBQWMsRUFBSTtBQUM1RCw0QkFBYyxDQUFDLFFBQVEsR0FBRztBQUN4QixvQkFBSSxFQUFFLE9BQUssSUFBSTtBQUNmLG9CQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7QUFDZix1QkFBTyxFQUFQLE9BQU87QUFDUCw0QkFBWSxFQUFFLEtBQUssQ0FBQyxPQUFPO0FBQzNCLDBCQUFVLEVBQUUsS0FBSyxDQUFDLEtBQUs7QUFDdkIsMkJBQVcsRUFBRSxLQUFLLENBQUMsTUFBTTtlQUMxQixDQUFBO2FBQ0YsQ0FBQyxDQUFBO0FBQ0YsbUJBQU8sQ0FBQyxLQUFLLGVBQWEsT0FBSyxJQUFJLFNBQUksSUFBSSxDQUFDLElBQUksWUFBTyxPQUFPLGlCQUFjLEtBQUssRUFBRSxLQUFLLENBQUMsTUFBTSxJQUFJLElBQUksR0FBRyxLQUFLLENBQUMsTUFBTSxHQUFHLEVBQUUsQ0FBQyxDQUFBO0FBQzVILGtCQUFNLENBQUMsS0FBSyxDQUFDLENBQUE7V0FDZCxNQUFNO0FBQ0wsbUJBQU8sRUFBRSxDQUFBO1dBQ1Y7U0FDRixDQUFDLENBQUE7T0FDSCxDQUFDLENBQUE7S0FDSDs7O1dBRVMscUJBQUc7OztBQUNYLFVBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsVUFBQyxLQUFLLEVBQUs7QUFDbEQsWUFBSSxLQUFLLElBQUksSUFBSSxFQUFFO0FBQ2pCLGlCQUFPLENBQUMsS0FBSyxtQkFBaUIsT0FBSyxJQUFJLFNBQUksT0FBSyxJQUFJLENBQUMsSUFBSSxjQUFXLEtBQUssQ0FBQyxLQUFLLElBQUksSUFBSSxHQUFHLEtBQUssQ0FBQyxLQUFLLEdBQUcsS0FBSyxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQTtTQUM3SDtPQUNGLENBQUMsQ0FBQTtLQUNIOzs7V0FFa0IsOEJBQUc7OztBQUNwQixVQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsNEJBQTRCLEVBQUUsQ0FBQTtBQUNwRCxVQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGdCQUFnQixDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxDQUFBO0FBQ3pGLFVBQUksQ0FBQyxRQUFRLElBQUksQ0FBQyxRQUFRLENBQUMsY0FBYyxJQUFJLFFBQVEsQ0FBQyxXQUFXLEtBQUssTUFBTSxJQUFJLFVBQVUsRUFBRTtBQUMxRixlQUFNO09BQ1A7O0FBRUQsVUFBSSxDQUFDLGNBQWMsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLFFBQVEsQ0FBQyxXQUFXLEVBQUUsVUFBQyxLQUFLLEVBQUUsS0FBbUIsRUFBSztZQUF2QixJQUFJLEdBQUwsS0FBbUIsQ0FBbEIsSUFBSTtZQUFFLFdBQVcsR0FBbEIsS0FBbUIsQ0FBWixXQUFXOztBQUNoRyxZQUFJLEtBQUssSUFBSSxJQUFJLEVBQUU7QUFDakIsaUJBQU8sQ0FBQyxLQUFLLDhCQUE2QixXQUFXLFVBQU0sUUFBSyxJQUFJLGFBQVEsUUFBSyxJQUFJLENBQUMsSUFBSSxjQUFXLEtBQUssQ0FBQyxLQUFLLElBQUksSUFBSSxHQUFHLEtBQUssQ0FBQyxLQUFLLEdBQUcsS0FBSyxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQTtTQUM5SjtPQUNGLENBQUMsQ0FBQTtLQUNIOzs7U0F6c0JrQixXQUFXOzs7cUJBQVgsV0FBVyIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjQxLjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvc2V0dGluZ3Mtdmlldy9saWIvcGFja2FnZS1jYXJkLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuLyoqIEBqc3ggZXRjaC5kb20gKi9cblxuaW1wb3J0IHtDb21wb3NpdGVEaXNwb3NhYmxlLCBEaXNwb3NhYmxlfSBmcm9tICdhdG9tJ1xuaW1wb3J0IHtzaGVsbH0gZnJvbSAnZWxlY3Ryb24nXG5pbXBvcnQgZXRjaCBmcm9tICdldGNoJ1xuXG5pbXBvcnQge293bmVyRnJvbVJlcG9zaXRvcnl9IGZyb20gJy4vdXRpbHMnXG5cbmxldCBtYXJrZWQgPSBudWxsXG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFBhY2thZ2VDYXJkIHtcbiAgY29uc3RydWN0b3IgKHBhY2ssIHNldHRpbmdzVmlldywgcGFja2FnZU1hbmFnZXIsIG9wdGlvbnMgPSB7fSkge1xuICAgIHRoaXMucGFjayA9IHBhY2tcbiAgICB0aGlzLnNldHRpbmdzVmlldyA9IHNldHRpbmdzVmlld1xuICAgIHRoaXMucGFja2FnZU1hbmFnZXIgPSBwYWNrYWdlTWFuYWdlclxuICAgIHRoaXMuZGlzcG9zYWJsZXMgPSBuZXcgQ29tcG9zaXRlRGlzcG9zYWJsZSgpXG5cbiAgICAvLyBJdCBtaWdodCBiZSB1c2VmdWwgdG8gZWl0aGVyIHdyYXAgdGhpcy5wYWNrIGluIGEgY2xhc3MgdGhhdCBoYXMgYVxuICAgIC8vIDo6dmFsaWRhdGUgbWV0aG9kLCBvciBhZGQgYSBtZXRob2QgaGVyZS4gQXQgdGhlIG1vbWVudCBJIHRoaW5rIGFsbCBjYXNlc1xuICAgIC8vIG9mIG1hbGZvcm1lZCBwYWNrYWdlIG1ldGFkYXRhIGFyZSBoYW5kbGVkIGhlcmUgYW5kIGluIDo6Y29udGVudCBidXQgYmVsdFxuICAgIC8vIGFuZCBzdXNwZW5kZXJzLCB5b3Uga25vd1xuICAgIHRoaXMuY2xpZW50ID0gdGhpcy5wYWNrYWdlTWFuYWdlci5nZXRDbGllbnQoKVxuICAgIHRoaXMudHlwZSA9IHRoaXMucGFjay50aGVtZSA/ICd0aGVtZScgOiAncGFja2FnZSdcbiAgICB0aGlzLm5hbWUgPSB0aGlzLnBhY2submFtZVxuICAgIHRoaXMub25TZXR0aW5nc1ZpZXcgPSBvcHRpb25zLm9uU2V0dGluZ3NWaWV3XG5cbiAgICBpZiAodGhpcy5wYWNrLmxhdGVzdFZlcnNpb24gIT09IHRoaXMucGFjay52ZXJzaW9uKSB7XG4gICAgICB0aGlzLm5ld1ZlcnNpb24gPSB0aGlzLnBhY2subGF0ZXN0VmVyc2lvblxuICAgIH1cblxuICAgIGlmICh0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZSAmJiB0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZS50eXBlID09PSAnZ2l0Jykge1xuICAgICAgaWYgKHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlLnNoYSAhPT0gdGhpcy5wYWNrLmxhdGVzdFNoYSkge1xuICAgICAgICB0aGlzLm5ld1NoYSA9IHRoaXMucGFjay5sYXRlc3RTaGFcbiAgICAgIH1cbiAgICB9XG5cbiAgICAvLyBEZWZhdWx0IHRvIGRpc3BsYXlpbmcgdGhlIGRvd25sb2FkIGNvdW50XG4gICAgaWYgKCFvcHRpb25zLnN0YXRzKSB7XG4gICAgICBvcHRpb25zLnN0YXRzID0ge2Rvd25sb2FkczogdHJ1ZX1cbiAgICB9XG5cbiAgICBldGNoLmluaXRpYWxpemUodGhpcylcblxuICAgIHRoaXMuZGlzcGxheVN0YXRzKG9wdGlvbnMpXG4gICAgdGhpcy5oYW5kbGVQYWNrYWdlRXZlbnRzKClcbiAgICB0aGlzLmhhbmRsZUJ1dHRvbkV2ZW50cyhvcHRpb25zKVxuICAgIHRoaXMubG9hZENhY2hlZE1ldGFkYXRhKClcblxuICAgIC8vIHRoZW1lcyBoYXZlIG5vIHN0YXR1cyBhbmQgY2Fubm90IGJlIGRpcy9lbmFibGVkXG4gICAgaWYgKHRoaXMudHlwZSA9PT0gJ3RoZW1lJykge1xuICAgICAgdGhpcy5yZWZzLnN0YXR1c0luZGljYXRvci5yZW1vdmUoKVxuICAgICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24ucmVtb3ZlKClcbiAgICB9XG5cbiAgICBpZiAoYXRvbS5wYWNrYWdlcy5pc0J1bmRsZWRQYWNrYWdlKHRoaXMucGFjay5uYW1lKSkge1xuICAgICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b25Hcm91cC5yZW1vdmUoKVxuICAgICAgdGhpcy5yZWZzLnVuaW5zdGFsbEJ1dHRvbi5yZW1vdmUoKVxuICAgIH1cblxuICAgIGlmICghdGhpcy5uZXdWZXJzaW9uICYmICF0aGlzLm5ld1NoYSkge1xuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9XG5cbiAgICB0aGlzLmhhc0NvbXBhdGlibGVWZXJzaW9uID0gdHJ1ZVxuICAgIHRoaXMudXBkYXRlSW50ZXJmYWNlU3RhdGUoKVxuICB9XG5cbiAgcmVuZGVyICgpIHtcbiAgICBjb25zdCBkaXNwbGF5TmFtZSA9ICh0aGlzLnBhY2suZ2l0VXJsSW5mbyA/IHRoaXMucGFjay5naXRVcmxJbmZvLnByb2plY3QgOiB0aGlzLnBhY2submFtZSkgfHwgJydcbiAgICBjb25zdCBvd25lciA9IG93bmVyRnJvbVJlcG9zaXRvcnkodGhpcy5wYWNrLnJlcG9zaXRvcnkpXG4gICAgY29uc3QgZGVzY3JpcHRpb24gPSB0aGlzLnBhY2suZGVzY3JpcHRpb24gfHwgJydcblxuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT0ncGFja2FnZS1jYXJkIGNvbC1sZy04Jz5cbiAgICAgICAgPGRpdiByZWY9J3N0YXRzQ29udGFpbmVyJyBjbGFzc05hbWU9J3N0YXRzIHB1bGwtcmlnaHQnPlxuICAgICAgICAgIDxzcGFuIHJlZj0ncGFja2FnZVN0YXJzJyBjbGFzc05hbWU9J3N0YXRzLWl0ZW0nPlxuICAgICAgICAgICAgPHNwYW4gcmVmPSdzdGFyZ2F6ZXJJY29uJyBjbGFzc05hbWU9J2ljb24gaWNvbi1zdGFyJyAvPlxuICAgICAgICAgICAgPHNwYW4gcmVmPSdzdGFyZ2F6ZXJDb3VudCcgY2xhc3NOYW1lPSd2YWx1ZScgLz5cbiAgICAgICAgICA8L3NwYW4+XG5cbiAgICAgICAgICA8c3BhbiByZWY9J3BhY2thZ2VEb3dubG9hZHMnIGNsYXNzTmFtZT0nc3RhdHMtaXRlbSc+XG4gICAgICAgICAgICA8c3BhbiByZWY9J2Rvd25sb2FkSWNvbicgY2xhc3NOYW1lPSdpY29uIGljb24tY2xvdWQtZG93bmxvYWQnIC8+XG4gICAgICAgICAgICA8c3BhbiByZWY9J2Rvd25sb2FkQ291bnQnIGNsYXNzTmFtZT0ndmFsdWUnIC8+XG4gICAgICAgICAgPC9zcGFuPlxuICAgICAgICA8L2Rpdj5cblxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYm9keSc+XG4gICAgICAgICAgPGg0IGNsYXNzTmFtZT0nY2FyZC1uYW1lJz5cbiAgICAgICAgICAgIDxhIGNsYXNzTmFtZT0ncGFja2FnZS1uYW1lJyByZWY9J3BhY2thZ2VOYW1lJz57ZGlzcGxheU5hbWV9PC9hPlxuICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdwYWNrYWdlLXZlcnNpb24nPlxuICAgICAgICAgICAgICA8c3BhbiByZWY9J3ZlcnNpb25WYWx1ZScgY2xhc3NOYW1lPSd2YWx1ZSc+e1N0cmluZyh0aGlzLnBhY2sudmVyc2lvbil9PC9zcGFuPlxuICAgICAgICAgICAgPC9zcGFuPlxuXG4gICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9J2RlcHJlY2F0aW9uLWJhZGdlIGhpZ2hsaWdodC13YXJuaW5nIGlubGluZS1ibG9jayc+RGVwcmVjYXRlZDwvc3Bhbj5cbiAgICAgICAgICA8L2g0PlxuICAgICAgICAgIDxzcGFuIHJlZj0ncGFja2FnZURlc2NyaXB0aW9uJyBjbGFzc05hbWU9J3BhY2thZ2UtZGVzY3JpcHRpb24nPntkZXNjcmlwdGlvbn08L3NwYW4+XG4gICAgICAgICAgPGRpdiByZWY9J3BhY2thZ2VNZXNzYWdlJyBjbGFzc05hbWU9J3BhY2thZ2UtbWVzc2FnZScgLz5cbiAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J21ldGEnPlxuICAgICAgICAgIDxkaXYgcmVmPSdtZXRhVXNlckNvbnRhaW5lcicgY2xhc3NOYW1lPSdtZXRhLXVzZXInPlxuICAgICAgICAgICAgPGEgcmVmPSdhdmF0YXJMaW5rJyBocmVmPXtgaHR0cHM6Ly9hdG9tLmlvL3VzZXJzLyR7b3duZXJ9YH0+XG4gICAgICAgICAgICAgIHsvKiBBIHRyYW5zcGFyZW50IGdpZiBzbyB0aGVyZSBpcyBubyBcImJyb2tlbiBib3JkZXJcIiAqL31cbiAgICAgICAgICAgICAgPGltZyByZWY9J2F2YXRhcicgY2xhc3NOYW1lPSdhdmF0YXInIHNyYz0nZGF0YTppbWFnZS9naWY7YmFzZTY0LFIwbEdPRGxoQVFBQkFJQUFBQUFBQVAvLy95SDVCQUVBQUFBQUxBQUFBQUFCQUFFQUFBSUJSQUE3JyAvPlxuICAgICAgICAgICAgPC9hPlxuICAgICAgICAgICAgPGEgcmVmPSdsb2dpbkxpbmsnIGNsYXNzTmFtZT0nYXV0aG9yJyBocmVmPXtgaHR0cHM6Ly9hdG9tLmlvL3VzZXJzLyR7b3duZXJ9YH0+e293bmVyfTwvYT5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nbWV0YS1jb250cm9scyc+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nYnRuLXRvb2xiYXInPlxuICAgICAgICAgICAgICA8ZGl2IHJlZj0ndXBkYXRlQnV0dG9uR3JvdXAnIGNsYXNzTmFtZT0nYnRuLWdyb3VwJz5cbiAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9J2J1dHRvbicgY2xhc3NOYW1lPSdidG4gYnRuLWluZm8gaWNvbiBpY29uLWNsb3VkLWRvd25sb2FkIGluc3RhbGwtYnV0dG9uJyByZWY9J3VwZGF0ZUJ1dHRvbic+VXBkYXRlPC9idXR0b24+XG4gICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICA8ZGl2IHJlZj0naW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uR3JvdXAnIGNsYXNzTmFtZT0nYnRuLWdyb3VwJz5cbiAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9J2J1dHRvbicgY2xhc3NOYW1lPSdidG4gYnRuLWluZm8gaWNvbiBpY29uLWNsb3VkLWRvd25sb2FkIGluc3RhbGwtYnV0dG9uJyByZWY9J2luc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbic+SW5zdGFsbCBBbHRlcm5hdGl2ZTwvYnV0dG9uPlxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgPGRpdiByZWY9J2luc3RhbGxCdXR0b25Hcm91cCcgY2xhc3NOYW1lPSdidG4tZ3JvdXAnPlxuICAgICAgICAgICAgICAgIDxidXR0b24gdHlwZT0nYnV0dG9uJyBjbGFzc05hbWU9J2J0biBidG4taW5mbyBpY29uIGljb24tY2xvdWQtZG93bmxvYWQgaW5zdGFsbC1idXR0b24nIHJlZj0naW5zdGFsbEJ1dHRvbic+SW5zdGFsbDwvYnV0dG9uPlxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgPGRpdiByZWY9J3BhY2thZ2VBY3Rpb25CdXR0b25Hcm91cCcgY2xhc3NOYW1lPSdidG4tZ3JvdXAnPlxuICAgICAgICAgICAgICAgIDxidXR0b24gdHlwZT0nYnV0dG9uJyBjbGFzc05hbWU9J2J0biBpY29uIGljb24tZ2VhciBzZXR0aW5ncycgcmVmPSdzZXR0aW5nc0J1dHRvbic+U2V0dGluZ3M8L2J1dHRvbj5cbiAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9J2J1dHRvbicgY2xhc3NOYW1lPSdidG4gaWNvbiBpY29uLXRyYXNoY2FuIHVuaW5zdGFsbC1idXR0b24nIHJlZj0ndW5pbnN0YWxsQnV0dG9uJz5Vbmluc3RhbGw8L2J1dHRvbj5cbiAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9J2J1dHRvbicgY2xhc3NOYW1lPSdidG4gaWNvbiBpY29uLXBsYXliYWNrLXBhdXNlIGVuYWJsZW1lbnQnIHJlZj0nZW5hYmxlbWVudEJ1dHRvbic+XG4gICAgICAgICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9J2Rpc2FibGUtdGV4dCc+RGlzYWJsZTwvc3Bhbj5cbiAgICAgICAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9J2J1dHRvbicgY2xhc3NOYW1lPSdidG4gc3RhdHVzLWluZGljYXRvcicgdGFiSW5kZXg9Jy0xJyByZWY9J3N0YXR1c0luZGljYXRvcicgLz5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgPC9kaXY+XG4gICAgICA8L2Rpdj5cbiAgICApXG4gIH1cblxuICBsb2NhdGVDb21wYXRpYmxlUGFja2FnZVZlcnNpb24gKGNhbGxiYWNrKSB7XG4gICAgdGhpcy5wYWNrYWdlTWFuYWdlci5sb2FkQ29tcGF0aWJsZVBhY2thZ2VWZXJzaW9uKHRoaXMucGFjay5uYW1lLCAoZXJyLCBwYWNrKSA9PiB7XG4gICAgICBpZiAoZXJyICE9IG51bGwpIHtcbiAgICAgICAgY29uc29sZS5lcnJvcihlcnIpXG4gICAgICB9XG5cbiAgICAgIGNvbnN0IHBhY2thZ2VWZXJzaW9uID0gcGFjay52ZXJzaW9uXG5cbiAgICAgIC8vIEEgY29tcGF0aWJsZSB2ZXJzaW9uIGV4aXN0LCB3ZSBhY3RpdmF0ZSB0aGUgaW5zdGFsbCBidXR0b24gYW5kXG4gICAgICAvLyBzZXQgdGhpcy5pbnN0YWxsYWJsZVBhY2sgc28gdGhhdCB0aGUgaW5zdGFsbCBhY3Rpb24gaW5zdGFsbHMgdGhlXG4gICAgICAvLyBjb21wYXRpYmxlIHZlcnNpb24gb2YgdGhlIHBhY2thZ2UuXG4gICAgICBpZiAocGFja2FnZVZlcnNpb24pIHtcbiAgICAgICAgdGhpcy5yZWZzLnZlcnNpb25WYWx1ZS50ZXh0Q29udGVudCA9IHBhY2thZ2VWZXJzaW9uXG4gICAgICAgIGlmIChwYWNrYWdlVmVyc2lvbiAhPT0gdGhpcy5wYWNrLnZlcnNpb24pIHtcbiAgICAgICAgICB0aGlzLnJlZnMudmVyc2lvblZhbHVlLmNsYXNzTGlzdC5hZGQoJ3RleHQtd2FybmluZycpXG4gICAgICAgICAgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLmNsYXNzTGlzdC5hZGQoJ3RleHQtd2FybmluZycpXG4gICAgICAgICAgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLnRleHRDb250ZW50ID0gYFZlcnNpb24gJHtwYWNrYWdlVmVyc2lvbn0gaXMgbm90IHRoZSBsYXRlc3QgdmVyc2lvbiBhdmFpbGFibGUgZm9yIHRoaXMgcGFja2FnZSwgYnV0IGl0J3MgdGhlIGxhdGVzdCB0aGF0IGlzIGNvbXBhdGlibGUgd2l0aCB5b3VyIHZlcnNpb24gb2YgQXRvbS5gXG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLmluc3RhbGxhYmxlUGFjayA9IHBhY2tcbiAgICAgICAgdGhpcy5oYXNDb21wYXRpYmxlVmVyc2lvbiA9IHRydWVcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHRoaXMuaGFzQ29tcGF0aWJsZVZlcnNpb24gPSBmYWxzZVxuICAgICAgICB0aGlzLnJlZnMudmVyc2lvblZhbHVlLmNsYXNzTGlzdC5hZGQoJ3RleHQtZXJyb3InKVxuICAgICAgICB0aGlzLnJlZnMucGFja2FnZU1lc3NhZ2UuY2xhc3NMaXN0LmFkZCgndGV4dC1lcnJvcicpXG4gICAgICAgIHRoaXMucmVmcy5wYWNrYWdlTWVzc2FnZS5pbnNlcnRBZGphY2VudFRleHQoXG4gICAgICAgICAgJ2JlZm9yZWVuZCcsXG4gICAgICAgICAgYFRoZXJlJ3Mgbm8gdmVyc2lvbiBvZiB0aGlzIHBhY2thZ2UgdGhhdCBpcyBjb21wYXRpYmxlIHdpdGggeW91ciBBdG9tIHZlcnNpb24uIFRoZSB2ZXJzaW9uIG11c3Qgc2F0aXNmeSAke3RoaXMucGFjay5lbmdpbmVzLmF0b219LmBcbiAgICAgICAgKVxuICAgICAgICBjb25zb2xlLmVycm9yKGBObyBhdmFpbGFibGUgdmVyc2lvbiBjb21wYXRpYmxlIHdpdGggdGhlIGluc3RhbGxlZCBBdG9tIHZlcnNpb246ICR7YXRvbS5nZXRWZXJzaW9uKCl9YClcbiAgICAgIH1cblxuICAgICAgY2FsbGJhY2soKVxuICAgIH0pXG4gIH1cblxuICBoYW5kbGVCdXR0b25FdmVudHMgKG9wdGlvbnMpIHtcbiAgICBpZiAob3B0aW9ucyAmJiBvcHRpb25zLm9uU2V0dGluZ3NWaWV3KSB7XG4gICAgICB0aGlzLnJlZnMuc2V0dGluZ3NCdXR0b24uc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH0gZWxzZSB7XG4gICAgICBjb25zdCBjbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgICAgdGhpcy5zZXR0aW5nc1ZpZXcuc2hvd1BhbmVsKHRoaXMucGFjay5uYW1lLCB7YmFjazogb3B0aW9ucyA/IG9wdGlvbnMuYmFjayA6IG51bGwsIHBhY2s6IHRoaXMucGFja30pXG4gICAgICB9XG5cbiAgICAgIHRoaXMuZWxlbWVudC5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIGNsaWNrSGFuZGxlcilcbiAgICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5lbGVtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKSB9KSlcblxuICAgICAgdGhpcy5yZWZzLnNldHRpbmdzQnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKVxuICAgICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4geyB0aGlzLnJlZnMuc2V0dGluZ3NCdXR0b24ucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCBjbGlja0hhbmRsZXIpIH0pKVxuICAgIH1cblxuICAgIGNvbnN0IGluc3RhbGxCdXR0b25DbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICB0aGlzLmluc3RhbGwoKVxuICAgIH1cbiAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIGluc3RhbGxCdXR0b25DbGlja0hhbmRsZXIpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4geyB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIGluc3RhbGxCdXR0b25DbGlja0hhbmRsZXIpIH0pKVxuXG4gICAgY29uc3QgdW5pbnN0YWxsQnV0dG9uQ2xpY2tIYW5kbGVyID0gKGV2ZW50KSA9PiB7XG4gICAgICBldmVudC5zdG9wUHJvcGFnYXRpb24oKVxuICAgICAgdGhpcy51bmluc3RhbGwoKVxuICAgIH1cbiAgICB0aGlzLnJlZnMudW5pbnN0YWxsQnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgdW5pbnN0YWxsQnV0dG9uQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnVuaW5zdGFsbEJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIHVuaW5zdGFsbEJ1dHRvbkNsaWNrSGFuZGxlcikgfSkpXG5cbiAgICBjb25zdCBpbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b25DbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgICB0aGlzLmluc3RhbGxBbHRlcm5hdGl2ZSgpXG4gICAgfVxuICAgIHRoaXMucmVmcy5pbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b24uYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBpbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b25DbGlja0hhbmRsZXIpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4geyB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uQ2xpY2tIYW5kbGVyKSB9KSlcblxuICAgIGNvbnN0IHVwZGF0ZUJ1dHRvbkNsaWNrSGFuZGxlciA9IChldmVudCkgPT4ge1xuICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgIHRoaXMudXBkYXRlKCkudGhlbigoKSA9PiB7XG4gICAgICAgIGNvbnN0IGJ1dHRvbnMgPSBbe1xuICAgICAgICAgIHRleHQ6ICdSZXN0YXJ0JyxcbiAgICAgICAgICBvbkRpZENsaWNrICgpIHsgcmV0dXJuIGF0b20ucmVzdGFydEFwcGxpY2F0aW9uKCkgfVxuICAgICAgICB9XVxuXG4gICAgICAgIGxldCBvbGRWZXJzaW9uID0gJydcbiAgICAgICAgbGV0IG5ld1ZlcnNpb24gPSAnJ1xuXG4gICAgICAgIGlmICh0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZSAmJiB0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZS50eXBlID09PSAnZ2l0Jykge1xuICAgICAgICAgIG9sZFZlcnNpb24gPSB0aGlzLnBhY2suYXBtSW5zdGFsbFNvdXJjZS5zaGEuc3Vic3RyKDAsIDgpXG4gICAgICAgICAgbmV3VmVyc2lvbiA9IGAke3RoaXMucGFjay5sYXRlc3RTaGEuc3Vic3RyKDAsIDgpfWBcbiAgICAgICAgfSBlbHNlIGlmICh0aGlzLnBhY2sudmVyc2lvbiAmJiB0aGlzLnBhY2subGF0ZXN0VmVyc2lvbikge1xuICAgICAgICAgIG9sZFZlcnNpb24gPSB0aGlzLnBhY2sudmVyc2lvblxuICAgICAgICAgIG5ld1ZlcnNpb24gPSB0aGlzLnBhY2subGF0ZXN0VmVyc2lvblxuICAgICAgICB9XG5cbiAgICAgICAgbGV0IGRldGFpbCA9ICcnXG4gICAgICAgIGlmIChvbGRWZXJzaW9uICYmIG5ld1ZlcnNpb24pIHtcbiAgICAgICAgICBkZXRhaWwgPSBgJHtvbGRWZXJzaW9ufSAtPiAke25ld1ZlcnNpb259YFxuICAgICAgICB9XG5cbiAgICAgICAgYXRvbS5ub3RpZmljYXRpb25zLmFkZFN1Y2Nlc3MoYFJlc3RhcnQgQXRvbSB0byBjb21wbGV0ZSB0aGUgdXBkYXRlIG9mIFxcYCR7dGhpcy5wYWNrLm5hbWV9XFxgLmAsIHtcbiAgICAgICAgICBkaXNtaXNzYWJsZTogdHJ1ZSwgYnV0dG9ucywgZGV0YWlsXG4gICAgICAgIH0pXG4gICAgICB9KVxuICAgIH1cbiAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgdXBkYXRlQnV0dG9uQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIHVwZGF0ZUJ1dHRvbkNsaWNrSGFuZGxlcikgfSkpXG5cbiAgICBjb25zdCBwYWNrYWdlTmFtZUNsaWNrSGFuZGxlciA9IChldmVudCkgPT4ge1xuICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgIGNvbnN0IHBhY2thZ2VUeXBlID0gdGhpcy5wYWNrLnRoZW1lID8gJ3RoZW1lcycgOiAncGFja2FnZXMnXG4gICAgICBzaGVsbC5vcGVuRXh0ZXJuYWwoYGh0dHBzOi8vYXRvbS5pby8ke3BhY2thZ2VUeXBlfS8ke3RoaXMucGFjay5uYW1lfWApXG4gICAgfVxuICAgIHRoaXMucmVmcy5wYWNrYWdlTmFtZS5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIHBhY2thZ2VOYW1lQ2xpY2tIYW5kbGVyKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5yZWZzLnBhY2thZ2VOYW1lLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgcGFja2FnZU5hbWVDbGlja0hhbmRsZXIpIH0pKVxuXG4gICAgY29uc3QgZW5hYmxlbWVudEJ1dHRvbkNsaWNrSGFuZGxlciA9IChldmVudCkgPT4ge1xuICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KClcbiAgICAgIGlmICh0aGlzLmlzRGlzYWJsZWQoKSkge1xuICAgICAgICBhdG9tLnBhY2thZ2VzLmVuYWJsZVBhY2thZ2UodGhpcy5wYWNrLm5hbWUpXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBhdG9tLnBhY2thZ2VzLmRpc2FibGVQYWNrYWdlKHRoaXMucGFjay5uYW1lKVxuICAgICAgfVxuICAgIH1cbiAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5hZGRFdmVudExpc3RlbmVyKCdjbGljaycsIGVuYWJsZW1lbnRCdXR0b25DbGlja0hhbmRsZXIpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4geyB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5yZW1vdmVFdmVudExpc3RlbmVyKCdjbGljaycsIGVuYWJsZW1lbnRCdXR0b25DbGlja0hhbmRsZXIpIH0pKVxuXG4gICAgY29uc3QgcGFja2FnZU1lc3NhZ2VDbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGNvbnN0IHRhcmdldCA9IGV2ZW50LnRhcmdldC5jbG9zZXN0KCdhJylcbiAgICAgIGlmICh0YXJnZXQpIHtcbiAgICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgICAgICAgZXZlbnQucHJldmVudERlZmF1bHQoKVxuICAgICAgICBpZiAodGFyZ2V0LmhyZWYgJiYgdGFyZ2V0LmhyZWYuc3RhcnRzV2l0aCgnYXRvbTonKSkge1xuICAgICAgICAgIGF0b20ud29ya3NwYWNlLm9wZW4odGFyZ2V0LmhyZWYpXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gICAgdGhpcy5yZWZzLnBhY2thZ2VNZXNzYWdlLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgcGFja2FnZU1lc3NhZ2VDbGlja0hhbmRsZXIpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQobmV3IERpc3Bvc2FibGUoKCkgPT4geyB0aGlzLnJlZnMucGFja2FnZU1lc3NhZ2UucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCBwYWNrYWdlTWVzc2FnZUNsaWNrSGFuZGxlcikgfSkpXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmRpc3Bvc2UoKVxuICAgIHJldHVybiBldGNoLmRlc3Ryb3kodGhpcylcbiAgfVxuXG4gIGxvYWRDYWNoZWRNZXRhZGF0YSAoKSB7XG4gICAgdGhpcy5jbGllbnQuYXZhdGFyKG93bmVyRnJvbVJlcG9zaXRvcnkodGhpcy5wYWNrLnJlcG9zaXRvcnkpLCAoZXJyLCBhdmF0YXJQYXRoKSA9PiB7XG4gICAgICBpZiAoIWVyciAmJiBhdmF0YXJQYXRoKSB7XG4gICAgICAgIHRoaXMucmVmcy5hdmF0YXIuc3JjID0gYGZpbGU6Ly8ke2F2YXRhclBhdGh9YFxuICAgICAgfVxuICAgIH0pXG5cbiAgICB0aGlzLmNsaWVudC5wYWNrYWdlKHRoaXMucGFjay5uYW1lLCAoZXJyLCBkYXRhKSA9PiB7XG4gICAgICAvLyBXZSBkb24ndCBuZWVkIHRvIGFjdHVhbGx5IGhhbmRsZSB0aGUgZXJyb3IgaGVyZSwgd2UgY2FuIGp1c3Qgc2tpcFxuICAgICAgLy8gc2hvd2luZyB0aGUgZG93bmxvYWQgY291bnQgaWYgdGhlcmUncyBhIHByb2JsZW0uXG4gICAgICBpZiAoIWVycikge1xuICAgICAgICBpZiAoZGF0YSA9PSBudWxsKSB7XG4gICAgICAgICAgZGF0YSA9IHt9XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2UgJiYgdGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2UudHlwZSA9PT0gJ2dpdCcpIHtcbiAgICAgICAgICB0aGlzLnJlZnMuZG93bmxvYWRJY29uLmNsYXNzTGlzdC5yZW1vdmUoJ2ljb24tY2xvdWQtZG93bmxvYWQnKVxuICAgICAgICAgIHRoaXMucmVmcy5kb3dubG9hZEljb24uY2xhc3NMaXN0LmFkZCgnaWNvbi1naXQtYnJhbmNoJylcbiAgICAgICAgICB0aGlzLnJlZnMuZG93bmxvYWRDb3VudC50ZXh0Q29udGVudCA9IHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlLnNoYS5zdWJzdHIoMCwgOClcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICB0aGlzLnJlZnMuc3RhcmdhemVyQ291bnQudGV4dENvbnRlbnQgPSBkYXRhLnN0YXJnYXplcnNfY291bnQgPyBkYXRhLnN0YXJnYXplcnNfY291bnQudG9Mb2NhbGVTdHJpbmcoKSA6ICcnXG4gICAgICAgICAgdGhpcy5yZWZzLmRvd25sb2FkQ291bnQudGV4dENvbnRlbnQgPSBkYXRhLmRvd25sb2FkcyA/IGRhdGEuZG93bmxvYWRzLnRvTG9jYWxlU3RyaW5nKCkgOiAnJ1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfSlcbiAgfVxuXG4gIHVwZGF0ZUludGVyZmFjZVN0YXRlICgpIHtcbiAgICB0aGlzLnJlZnMudmVyc2lvblZhbHVlLnRleHRDb250ZW50ID0gKHRoaXMuaW5zdGFsbGFibGVQYWNrID8gdGhpcy5pbnN0YWxsYWJsZVBhY2sudmVyc2lvbiA6IG51bGwpIHx8IHRoaXMucGFjay52ZXJzaW9uXG4gICAgaWYgKHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlICYmIHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlLnR5cGUgPT09ICdnaXQnKSB7XG4gICAgICB0aGlzLnJlZnMuZG93bmxvYWRDb3VudC50ZXh0Q29udGVudCA9IHRoaXMucGFjay5hcG1JbnN0YWxsU291cmNlLnNoYS5zdWJzdHIoMCwgOClcbiAgICB9XG5cbiAgICB0aGlzLnVwZGF0ZVNldHRpbmdzU3RhdGUoKVxuICAgIHRoaXMudXBkYXRlSW5zdGFsbGVkU3RhdGUoKVxuICAgIHRoaXMudXBkYXRlRGlzYWJsZWRTdGF0ZSgpXG4gICAgdGhpcy51cGRhdGVEZXByZWNhdGVkU3RhdGUoKVxuICB9XG5cbiAgdXBkYXRlU2V0dGluZ3NTdGF0ZSAoKSB7XG4gICAgaWYgKHRoaXMuaGFzU2V0dGluZ3MoKSAmJiAhdGhpcy5vblNldHRpbmdzVmlldykge1xuICAgICAgdGhpcy5yZWZzLnNldHRpbmdzQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMuc2V0dGluZ3NCdXR0b24uc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH1cbiAgfVxuXG4gIC8vIFNlY3Rpb246IGRpc2FibGVkIHN0YXRlIHVwZGF0ZXNcblxuICB1cGRhdGVEaXNhYmxlZFN0YXRlICgpIHtcbiAgICBpZiAodGhpcy5pc0Rpc2FibGVkKCkpIHtcbiAgICAgIHRoaXMuZGlzcGxheURpc2FibGVkU3RhdGUoKVxuICAgIH0gZWxzZSBpZiAodGhpcy5lbGVtZW50LmNsYXNzTGlzdC5jb250YWlucygnZGlzYWJsZWQnKSkge1xuICAgICAgdGhpcy5kaXNwbGF5RW5hYmxlZFN0YXRlKClcbiAgICB9XG4gIH1cblxuICBkaXNwbGF5RW5hYmxlZFN0YXRlICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuY2xhc3NMaXN0LnJlbW92ZSgnZGlzYWJsZWQnKVxuICAgIGlmICh0aGlzLnR5cGUgPT09ICd0aGVtZScpIHtcbiAgICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9XG4gICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24ucXVlcnlTZWxlY3RvcignLmRpc2FibGUtdGV4dCcpLnRleHRDb250ZW50ID0gJ0Rpc2FibGUnXG4gICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24uY2xhc3NMaXN0LmFkZCgnaWNvbi1wbGF5YmFjay1wYXVzZScpXG4gICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24uY2xhc3NMaXN0LnJlbW92ZSgnaWNvbi1wbGF5YmFjay1wbGF5JylcbiAgICB0aGlzLnJlZnMuc3RhdHVzSW5kaWNhdG9yLmNsYXNzTGlzdC5yZW1vdmUoJ2lzLWRpc2FibGVkJylcbiAgfVxuXG4gIGRpc3BsYXlEaXNhYmxlZFN0YXRlICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuY2xhc3NMaXN0LmFkZCgnZGlzYWJsZWQnKVxuICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLnF1ZXJ5U2VsZWN0b3IoJy5kaXNhYmxlLXRleHQnKS50ZXh0Q29udGVudCA9ICdFbmFibGUnXG4gICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24uY2xhc3NMaXN0LmFkZCgnaWNvbi1wbGF5YmFjay1wbGF5JylcbiAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKCdpY29uLXBsYXliYWNrLXBhdXNlJylcbiAgICB0aGlzLnJlZnMuc3RhdHVzSW5kaWNhdG9yLmNsYXNzTGlzdC5hZGQoJ2lzLWRpc2FibGVkJylcbiAgICBpZiAodGhpcy5pc0RlcHJlY2F0ZWQoKSkge1xuICAgICAgdGhpcy5yZWZzLmVuYWJsZW1lbnRCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICB9XG4gIH1cblxuICAvLyBTZWN0aW9uOiBpbnN0YWxsZWQgc3RhdGUgdXBkYXRlc1xuXG4gIHVwZGF0ZUluc3RhbGxlZFN0YXRlICgpIHtcbiAgICBpZiAodGhpcy5pc0luc3RhbGxlZCgpKSB7XG4gICAgICB0aGlzLmRpc3BsYXlJbnN0YWxsZWRTdGF0ZSgpXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuZGlzcGxheU5vdEluc3RhbGxlZFN0YXRlKClcbiAgICB9XG4gIH1cblxuICBkaXNwbGF5SW5zdGFsbGVkU3RhdGUgKCkge1xuICAgIGlmICh0aGlzLm5ld1ZlcnNpb24gfHwgdGhpcy5uZXdTaGEpIHtcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICAgIGlmICh0aGlzLm5ld1ZlcnNpb24pIHtcbiAgICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi50ZXh0Q29udGVudCA9IGBVcGRhdGUgdG8gJHt0aGlzLm5ld1ZlcnNpb259YFxuICAgICAgfSBlbHNlIGlmICh0aGlzLm5ld1NoYSkge1xuICAgICAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uLnRleHRDb250ZW50ID0gYFVwZGF0ZSB0byAke3RoaXMubmV3U2hhLnN1YnN0cigwLCA4KX1gXG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuXG4gICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB0aGlzLnJlZnMucGFja2FnZUFjdGlvbkJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgIHRoaXMucmVmcy51bmluc3RhbGxCdXR0b24uc3R5bGUuZGlzcGxheSA9ICcnXG4gIH1cblxuICBkaXNwbGF5Tm90SW5zdGFsbGVkU3RhdGUgKCkge1xuICAgIHRoaXMucmVmcy51bmluc3RhbGxCdXR0b24uc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIGNvbnN0IGF0b21WZXJzaW9uID0gdGhpcy5wYWNrYWdlTWFuYWdlci5ub3JtYWxpemVWZXJzaW9uKGF0b20uZ2V0VmVyc2lvbigpKVxuICAgIGlmICghdGhpcy5wYWNrYWdlTWFuYWdlci5zYXRpc2ZpZXNWZXJzaW9uKGF0b21WZXJzaW9uLCB0aGlzLnBhY2spKSB7XG4gICAgICB0aGlzLmhhc0NvbXBhdGlibGVWZXJzaW9uID0gZmFsc2VcbiAgICAgIHRoaXMuc2V0Tm90SW5zdGFsbGVkU3RhdGVCdXR0b25zKClcbiAgICAgIHRoaXMubG9jYXRlQ29tcGF0aWJsZVBhY2thZ2VWZXJzaW9uKCgpID0+IHsgdGhpcy5zZXROb3RJbnN0YWxsZWRTdGF0ZUJ1dHRvbnMoKSB9KVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnNldE5vdEluc3RhbGxlZFN0YXRlQnV0dG9ucygpXG4gICAgfVxuICB9XG5cbiAgc2V0Tm90SW5zdGFsbGVkU3RhdGVCdXR0b25zICgpIHtcbiAgICBpZiAoIXRoaXMuaGFzQ29tcGF0aWJsZVZlcnNpb24pIHtcbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9IGVsc2UgaWYgKHRoaXMubmV3VmVyc2lvbiB8fCB0aGlzLm5ld1NoYSkge1xuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbkdyb3VwLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgIH1cbiAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIHRoaXMucmVmcy5wYWNrYWdlQWN0aW9uQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICB9XG5cbiAgLy8gU2VjdGlvbjogZGVwcmVjYXRlZCBzdGF0ZSB1cGRhdGVzXG5cbiAgdXBkYXRlRGVwcmVjYXRlZFN0YXRlICgpIHtcbiAgICBpZiAodGhpcy5pc0RlcHJlY2F0ZWQoKSkge1xuICAgICAgdGhpcy5kaXNwbGF5RGVwcmVjYXRlZFN0YXRlKClcbiAgICB9IGVsc2UgaWYgKHRoaXMuZWxlbWVudC5jbGFzc0xpc3QuY29udGFpbnMoJ2RlcHJlY2F0ZWQnKSkge1xuICAgICAgdGhpcy5kaXNwbGF5VW5kZXByZWNhdGVkU3RhdGUoKVxuICAgIH1cbiAgfVxuXG4gIGRpc3BsYXlTdGF0cyAob3B0aW9ucykge1xuICAgIGlmIChvcHRpb25zICYmIG9wdGlvbnMuc3RhdHMgJiYgb3B0aW9ucy5zdGF0cy5kb3dubG9hZHMpIHtcbiAgICAgIHRoaXMucmVmcy5wYWNrYWdlRG93bmxvYWRzLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMucGFja2FnZURvd25sb2Fkcy5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuXG4gICAgaWYgKG9wdGlvbnMgJiYgb3B0aW9ucy5zdGF0cyAmJiBvcHRpb25zLnN0YXRzLnN0YXJzKSB7XG4gICAgICB0aGlzLnJlZnMucGFja2FnZVN0YXJzLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMucGFja2FnZVN0YXJzLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9XG4gIH1cblxuICBkaXNwbGF5VW5kZXByZWNhdGVkU3RhdGUgKCkge1xuICAgIHRoaXMuZWxlbWVudC5jbGFzc0xpc3QucmVtb3ZlKCdkZXByZWNhdGVkJylcbiAgICB0aGlzLnJlZnMucGFja2FnZU1lc3NhZ2UuY2xhc3NMaXN0LnJlbW92ZSgndGV4dC13YXJuaW5nJylcbiAgICB0aGlzLnJlZnMucGFja2FnZU1lc3NhZ2UudGV4dENvbnRlbnQgPSAnJ1xuICB9XG5cbiAgZGlzcGxheURlcHJlY2F0ZWRTdGF0ZSAoKSB7XG4gICAgdGhpcy5lbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2RlcHJlY2F0ZWQnKVxuICAgIHRoaXMucmVmcy5zZXR0aW5nc0J1dHRvbi5kaXNhYmxlZCA9IHRydWVcblxuICAgIGNvbnN0IGluZm8gPSB0aGlzLmdldERlcHJlY2F0ZWRQYWNrYWdlTWV0YWRhdGEoKVxuICAgIHRoaXMucmVmcy5wYWNrYWdlTWVzc2FnZS5jbGFzc0xpc3QuYWRkKCd0ZXh0LXdhcm5pbmcnKVxuXG4gICAgbGV0IG1lc3NhZ2UgPSBudWxsXG4gICAgaWYgKGluZm8gJiYgaW5mby5oYXNEZXByZWNhdGlvbnMpIHtcbiAgICAgIG1lc3NhZ2UgPSB0aGlzLmdldERlcHJlY2F0aW9uTWVzc2FnZSh0aGlzLm5ld1ZlcnNpb24pXG4gICAgfSBlbHNlIGlmIChpbmZvICYmIGluZm8uaGFzQWx0ZXJuYXRpdmUgJiYgaW5mby5hbHRlcm5hdGl2ZSA9PT0gJ2NvcmUnKSB7XG4gICAgICBtZXNzYWdlID0gaW5mby5tZXNzYWdlICE9IG51bGwgPyBpbmZvLm1lc3NhZ2UgOiBgVGhlIGZlYXR1cmVzIGluIFxcYCR7dGhpcy5wYWNrLm5hbWV9XFxgIGhhdmUgYmVlbiBhZGRlZCB0byBjb3JlLmBcbiAgICAgIG1lc3NhZ2UgKz0gJyBQbGVhc2UgdW5pbnN0YWxsIHRoaXMgcGFja2FnZS4nXG4gICAgICB0aGlzLnJlZnMuc2V0dGluZ3NCdXR0b24ucmVtb3ZlKClcbiAgICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLnJlbW92ZSgpXG4gICAgfSBlbHNlIGlmIChpbmZvICYmIGluZm8uaGFzQWx0ZXJuYXRpdmUgJiYgaW5mby5hbHRlcm5hdGl2ZSkge1xuICAgICAgY29uc3QgYWx0ID0gaW5mby5hbHRlcm5hdGl2ZVxuICAgICAgY29uc3QgaXNJbnN0YWxsZWQgPSB0aGlzLmlzSW5zdGFsbGVkKClcbiAgICAgIGlmIChpc0luc3RhbGxlZCAmJiB0aGlzLnBhY2thZ2VNYW5hZ2VyLmlzUGFja2FnZUluc3RhbGxlZChhbHQpKSB7XG4gICAgICAgIG1lc3NhZ2UgPSBgXFxgJHt0aGlzLnBhY2submFtZX1cXGAgaGFzIGJlZW4gcmVwbGFjZWQgYnkgXFxgJHthbHR9XFxgIHdoaWNoIGlzIGFscmVhZHkgaW5zdGFsbGVkLiBQbGVhc2UgdW5pbnN0YWxsIHRoaXMgcGFja2FnZS5gXG4gICAgICAgIHRoaXMucmVmcy5zZXR0aW5nc0J1dHRvbi5yZW1vdmUoKVxuICAgICAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5yZW1vdmUoKVxuICAgICAgfSBlbHNlIGlmIChpc0luc3RhbGxlZCkge1xuICAgICAgICBtZXNzYWdlID0gYFxcYCR7dGhpcy5wYWNrLm5hbWV9XFxgIGhhcyBiZWVuIHJlcGxhY2VkIGJ5IFtcXGAke2FsdH1cXGBdKGF0b206Ly9jb25maWcvaW5zdGFsbC9wYWNrYWdlOiR7YWx0fSkuYFxuICAgICAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uLnRleHRDb250ZW50ID0gYEluc3RhbGwgJHthbHR9YFxuICAgICAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICcnXG4gICAgICAgIHRoaXMucmVmcy5wYWNrYWdlQWN0aW9uQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICcnXG4gICAgICAgIHRoaXMucmVmcy5zZXR0aW5nc0J1dHRvbi5yZW1vdmUoKVxuICAgICAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5yZW1vdmUoKVxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgbWVzc2FnZSA9IGBcXGAke3RoaXMucGFjay5uYW1lfVxcYCBoYXMgYmVlbiByZXBsYWNlZCBieSBbXFxgJHthbHR9XFxgXShhdG9tOi8vY29uZmlnL2luc3RhbGwvcGFja2FnZToke2FsdH0pLmBcbiAgICAgICAgdGhpcy5yZWZzLmluc3RhbGxCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgICAgIHRoaXMucmVmcy5pbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b25Hcm91cC5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgICAgIHRoaXMucmVmcy5wYWNrYWdlQWN0aW9uQnV0dG9uR3JvdXAuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgfVxuICAgIH1cblxuICAgIGlmIChtZXNzYWdlICE9IG51bGwpIHtcbiAgICAgIGlmIChtYXJrZWQgPT0gbnVsbCkge1xuICAgICAgICBtYXJrZWQgPSByZXF1aXJlKCdtYXJrZWQnKVxuICAgICAgfVxuXG4gICAgICB0aGlzLnJlZnMucGFja2FnZU1lc3NhZ2UuaW5uZXJIVE1MID0gbWFya2VkKG1lc3NhZ2UpXG4gICAgfVxuICB9XG5cbiAgZGlzcGxheUdpdFBhY2thZ2VJbnN0YWxsSW5mb3JtYXRpb24gKCkge1xuICAgIHRoaXMucmVmcy5tZXRhVXNlckNvbnRhaW5lci5yZW1vdmUoKVxuICAgIHRoaXMucmVmcy5zdGF0c0NvbnRhaW5lci5yZW1vdmUoKVxuICAgIGNvbnN0IHtnaXRVcmxJbmZvfSA9IHRoaXMucGFja1xuICAgIGlmIChnaXRVcmxJbmZvLmRlZmF1bHQgPT09ICdzaG9ydGN1dCcpIHtcbiAgICAgIHRoaXMucmVmcy5wYWNrYWdlRGVzY3JpcHRpb24udGV4dENvbnRlbnQgPSBnaXRVcmxJbmZvLmh0dHBzKClcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5yZWZzLnBhY2thZ2VEZXNjcmlwdGlvbi50ZXh0Q29udGVudCA9IGdpdFVybEluZm8udG9TdHJpbmcoKVxuICAgIH1cbiAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKCdpY29uLWNsb3VkLWRvd25sb2FkJylcbiAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdpY29uLWdpdC1jb21taXQnKVxuICAgIHRoaXMucmVmcy51cGRhdGVCdXR0b24uY2xhc3NMaXN0LnJlbW92ZSgnaWNvbi1jbG91ZC1kb3dubG9hZCcpXG4gICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdpY29uLWdpdC1jb21taXQnKVxuICB9XG5cbiAgZGlzcGxheUF2YWlsYWJsZVVwZGF0ZSAobmV3VmVyc2lvbikge1xuICAgIHRoaXMubmV3VmVyc2lvbiA9IG5ld1ZlcnNpb25cbiAgICB0aGlzLnVwZGF0ZUludGVyZmFjZVN0YXRlKClcbiAgfVxuXG4gIGdldERlcHJlY2F0aW9uTWVzc2FnZSAobmV3VmVyc2lvbikge1xuICAgIGNvbnN0IGluZm8gPSB0aGlzLmdldERlcHJlY2F0ZWRQYWNrYWdlTWV0YWRhdGEoKVxuICAgIGlmICghaW5mbyB8fCAhaW5mby5oYXNEZXByZWNhdGlvbnMpIHtcbiAgICAgIHJldHVyblxuICAgIH1cblxuICAgIGlmIChuZXdWZXJzaW9uKSB7XG4gICAgICBpZiAodGhpcy5pc0RlcHJlY2F0ZWQobmV3VmVyc2lvbikpIHtcbiAgICAgICAgcmV0dXJuIGBBbiB1cGRhdGUgdG8gXFxgdiR7bmV3VmVyc2lvbn1cXGAgaXMgYXZhaWxhYmxlIGJ1dCBzdGlsbCBjb250YWlucyBkZXByZWNhdGlvbnMuYFxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIGBBbiB1cGRhdGUgdG8gXFxgdiR7bmV3VmVyc2lvbn1cXGAgaXMgYXZhaWxhYmxlIHdpdGhvdXQgZGVwcmVjYXRpb25zLmBcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgaWYgKHRoaXMuaXNJbnN0YWxsZWQoKSkge1xuICAgICAgICByZXR1cm4gaW5mby5tZXNzYWdlICE9IG51bGwgPyBpbmZvLm1lc3NhZ2UgOiAnVGhpcyBwYWNrYWdlIGhhcyBub3QgYmVlbiBsb2FkZWQgZHVlIHRvIHVzaW5nIGRlcHJlY2F0ZWQgQVBJcy4gVGhlcmUgaXMgbm8gdXBkYXRlIGF2YWlsYWJsZS4nXG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gJ1RoaXMgcGFja2FnZSBoYXMgZGVwcmVjYXRpb25zIGFuZCBpcyBub3QgaW5zdGFsbGFibGUuJ1xuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIGhhbmRsZVBhY2thZ2VFdmVudHMgKCkge1xuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20ucGFja2FnZXMub25EaWREZWFjdGl2YXRlUGFja2FnZSgocGFjaykgPT4ge1xuICAgICAgaWYgKHBhY2submFtZSA9PT0gdGhpcy5wYWNrLm5hbWUpIHtcbiAgICAgICAgdGhpcy51cGRhdGVEaXNhYmxlZFN0YXRlKClcbiAgICAgIH1cbiAgICB9KSlcblxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20ucGFja2FnZXMub25EaWRBY3RpdmF0ZVBhY2thZ2UoKHBhY2spID0+IHtcbiAgICAgIGlmIChwYWNrLm5hbWUgPT09IHRoaXMucGFjay5uYW1lKSB7XG4gICAgICAgIHRoaXMudXBkYXRlRGlzYWJsZWRTdGF0ZSgpXG4gICAgICB9XG4gICAgfSkpXG5cbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLmNvbmZpZy5vbkRpZENoYW5nZSgnY29yZS5kaXNhYmxlZFBhY2thZ2VzJywgKCkgPT4ge1xuICAgICAgdGhpcy51cGRhdGVEaXNhYmxlZFN0YXRlKClcbiAgICB9KSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtaW5zdGFsbGluZyB0aGVtZS1pbnN0YWxsaW5nJywgKCkgPT4ge1xuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEJ1dHRvbi5kaXNhYmxlZCA9IHRydWVcbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uLmNsYXNzTGlzdC5hZGQoJ2lzLWluc3RhbGxpbmcnKVxuICAgIH0pXG5cbiAgICB0aGlzLnN1YnNjcmliZVRvUGFja2FnZUV2ZW50KCdwYWNrYWdlLXVwZGF0aW5nIHRoZW1lLXVwZGF0aW5nJywgKCkgPT4ge1xuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdpcy1pbnN0YWxsaW5nJylcbiAgICB9KVxuXG4gICAgdGhpcy5zdWJzY3JpYmVUb1BhY2thZ2VFdmVudCgncGFja2FnZS1pbnN0YWxsaW5nLWFsdGVybmF0aXZlJywgKCkgPT4ge1xuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuICAgICAgdGhpcy5yZWZzLmluc3RhbGxBbHRlcm5hdGl2ZUJ1dHRvbi5jbGFzc0xpc3QuYWRkKCdpcy1pbnN0YWxsaW5nJylcbiAgICB9KVxuXG4gICAgdGhpcy5zdWJzY3JpYmVUb1BhY2thZ2VFdmVudCgncGFja2FnZS11bmluc3RhbGxpbmcgdGhlbWUtdW5pbnN0YWxsaW5nJywgKCkgPT4ge1xuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgICB0aGlzLnJlZnMuZW5hYmxlbWVudEJ1dHRvbi5kaXNhYmxlZCA9IHRydWVcbiAgICAgIHRoaXMucmVmcy51bmluc3RhbGxCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG4gICAgICB0aGlzLnJlZnMudW5pbnN0YWxsQnV0dG9uLmNsYXNzTGlzdC5hZGQoJ2lzLXVuaW5zdGFsbGluZycpXG4gICAgfSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtaW5zdGFsbGVkIHBhY2thZ2UtaW5zdGFsbC1mYWlsZWQgdGhlbWUtaW5zdGFsbGVkIHRoZW1lLWluc3RhbGwtZmFpbGVkJywgKCkgPT4ge1xuICAgICAgY29uc3QgbG9hZGVkUGFjayA9IGF0b20ucGFja2FnZXMuZ2V0TG9hZGVkUGFja2FnZSh0aGlzLnBhY2submFtZSlcbiAgICAgIGNvbnN0IHZlcnNpb24gPSBsb2FkZWRQYWNrICYmIGxvYWRlZFBhY2subWV0YWRhdGEgPyBsb2FkZWRQYWNrLm1ldGFkYXRhLnZlcnNpb24gOiBudWxsXG4gICAgICBpZiAodmVyc2lvbikge1xuICAgICAgICB0aGlzLnBhY2sudmVyc2lvbiA9IHZlcnNpb25cbiAgICAgIH1cbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoJ2lzLWluc3RhbGxpbmcnKVxuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgfSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtdXBkYXRlZCB0aGVtZS11cGRhdGVkJywgKCkgPT4ge1xuICAgICAgY29uc3QgbG9hZGVkUGFjayA9IGF0b20ucGFja2FnZXMuZ2V0TG9hZGVkUGFja2FnZSh0aGlzLnBhY2submFtZSlcbiAgICAgIGNvbnN0IG1ldGFkYXRhID0gbG9hZGVkUGFjayA/IGxvYWRlZFBhY2subWV0YWRhdGEgOiBudWxsXG4gICAgICBpZiAobWV0YWRhdGEgJiYgbWV0YWRhdGEudmVyc2lvbikge1xuICAgICAgICB0aGlzLnBhY2sudmVyc2lvbiA9IG1ldGFkYXRhLnZlcnNpb25cbiAgICAgIH1cblxuICAgICAgaWYgKG1ldGFkYXRhICYmIG1ldGFkYXRhLmFwbUluc3RhbGxTb3VyY2UpIHtcbiAgICAgICAgdGhpcy5wYWNrLmFwbUluc3RhbGxTb3VyY2UgPSBtZXRhZGF0YS5hcG1JbnN0YWxsU291cmNlXG4gICAgICB9XG5cbiAgICAgIHRoaXMubmV3VmVyc2lvbiA9IG51bGxcbiAgICAgIHRoaXMubmV3U2hhID0gbnVsbFxuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoJ2lzLWluc3RhbGxpbmcnKVxuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgfSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtdXBkYXRlLWZhaWxlZCB0aGVtZS11cGRhdGUtZmFpbGVkJywgKCkgPT4ge1xuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLnJlZnMudXBkYXRlQnV0dG9uLmNsYXNzTGlzdC5yZW1vdmUoJ2lzLWluc3RhbGxpbmcnKVxuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgfSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtdW5pbnN0YWxsZWQgcGFja2FnZS11bmluc3RhbGwtZmFpbGVkIHRoZW1lLXVuaW5zdGFsbGVkIHRoZW1lLXVuaW5zdGFsbC1mYWlsZWQnLCAoKSA9PiB7XG4gICAgICB0aGlzLm5ld1ZlcnNpb24gPSBudWxsXG4gICAgICB0aGlzLm5ld1NoYSA9IG51bGxcbiAgICAgIHRoaXMucmVmcy5lbmFibGVtZW50QnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICAgIHRoaXMucmVmcy51bmluc3RhbGxCdXR0b24uZGlzYWJsZWQgPSBmYWxzZVxuICAgICAgdGhpcy5yZWZzLnVuaW5zdGFsbEJ1dHRvbi5jbGFzc0xpc3QucmVtb3ZlKCdpcy11bmluc3RhbGxpbmcnKVxuICAgICAgdGhpcy51cGRhdGVJbnRlcmZhY2VTdGF0ZSgpXG4gICAgfSlcblxuICAgIHRoaXMuc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQoJ3BhY2thZ2UtaW5zdGFsbGVkLWFsdGVybmF0aXZlIHBhY2thZ2UtaW5zdGFsbC1hbHRlcm5hdGl2ZS1mYWlsZWQnLCAoKSA9PiB7XG4gICAgICB0aGlzLnJlZnMuaW5zdGFsbEFsdGVybmF0aXZlQnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICAgIHRoaXMucmVmcy5pbnN0YWxsQWx0ZXJuYXRpdmVCdXR0b24uY2xhc3NMaXN0LnJlbW92ZSgnaXMtaW5zdGFsbGluZycpXG4gICAgICB0aGlzLnVwZGF0ZUludGVyZmFjZVN0YXRlKClcbiAgICB9KVxuICB9XG5cbiAgaXNJbnN0YWxsZWQgKCkge1xuICAgIHJldHVybiB0aGlzLnBhY2thZ2VNYW5hZ2VyLmlzUGFja2FnZUluc3RhbGxlZCh0aGlzLnBhY2submFtZSlcbiAgfVxuXG4gIGlzRGlzYWJsZWQgKCkge1xuICAgIHJldHVybiBhdG9tLnBhY2thZ2VzLmlzUGFja2FnZURpc2FibGVkKHRoaXMucGFjay5uYW1lKVxuICB9XG5cbiAgaXNEZXByZWNhdGVkICh2ZXJzaW9uKSB7XG4gICAgY29uc3QgcGFja1ZlcnNpb24gPSB2ZXJzaW9uICE9IG51bGwgPyB2ZXJzaW9uIDogdGhpcy5wYWNrLnZlcnNpb25cbiAgICByZXR1cm4gYXRvbS5wYWNrYWdlcy5pc0RlcHJlY2F0ZWRQYWNrYWdlKHRoaXMucGFjay5uYW1lLCBwYWNrVmVyc2lvbilcbiAgfVxuXG4gIGdldERlcHJlY2F0ZWRQYWNrYWdlTWV0YWRhdGEgKCkge1xuICAgIHJldHVybiBhdG9tLnBhY2thZ2VzLmdldERlcHJlY2F0ZWRQYWNrYWdlTWV0YWRhdGEodGhpcy5wYWNrLm5hbWUpXG4gIH1cblxuICBoYXNTZXR0aW5ncyAoKSB7XG4gICAgcmV0dXJuIHRoaXMucGFja2FnZU1hbmFnZXIucGFja2FnZUhhc1NldHRpbmdzKHRoaXMucGFjay5uYW1lKVxuICB9XG5cbiAgc3Vic2NyaWJlVG9QYWNrYWdlRXZlbnQgKGV2ZW50LCBjYWxsYmFjaykge1xuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKHRoaXMucGFja2FnZU1hbmFnZXIub24oZXZlbnQsICh7cGFjaywgZXJyb3J9KSA9PiB7XG4gICAgICBpZiAocGFjay5wYWNrICE9IG51bGwpIHtcbiAgICAgICAgcGFjayA9IHBhY2sucGFja1xuICAgICAgfVxuXG4gICAgICBjb25zdCBwYWNrYWdlTmFtZSA9IHBhY2submFtZVxuICAgICAgaWYgKHBhY2thZ2VOYW1lID09PSB0aGlzLnBhY2submFtZSkge1xuICAgICAgICBjYWxsYmFjayhwYWNrLCBlcnJvcilcbiAgICAgIH1cbiAgICB9KSlcbiAgfVxuXG4gIC8qXG4gIFNlY3Rpb246IE1ldGhvZHMgdGhhdCBzaG91bGQgYmUgb24gYSBQYWNrYWdlIG1vZGVsXG4gICovXG5cbiAgaW5zdGFsbCAoKSB7XG4gICAgdGhpcy5wYWNrYWdlTWFuYWdlci5pbnN0YWxsKHRoaXMuaW5zdGFsbGFibGVQYWNrICE9IG51bGwgPyB0aGlzLmluc3RhbGxhYmxlUGFjayA6IHRoaXMucGFjaywgKGVycm9yKSA9PiB7XG4gICAgICBpZiAoZXJyb3IgIT0gbnVsbCkge1xuICAgICAgICBjb25zb2xlLmVycm9yKGBJbnN0YWxsaW5nICR7dGhpcy50eXBlfSAke3RoaXMucGFjay5uYW1lfSBmYWlsZWRgLCBlcnJvci5zdGFjayAhPSBudWxsID8gZXJyb3Iuc3RhY2sgOiBlcnJvciwgZXJyb3Iuc3RkZXJyKVxuICAgICAgfSBlbHNlIHtcbiAgICAgICAgLy8gaWYgYSBwYWNrYWdlIHdhcyBkaXNhYmxlZCBiZWZvcmUgaW5zdGFsbGluZyBpdCwgcmUtZW5hYmxlIGl0XG4gICAgICAgIGlmICh0aGlzLmlzRGlzYWJsZWQoKSkge1xuICAgICAgICAgIGF0b20ucGFja2FnZXMuZW5hYmxlUGFja2FnZSh0aGlzLnBhY2submFtZSlcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pXG4gIH1cblxuICB1cGRhdGUgKCkge1xuICAgIGlmICghdGhpcy5uZXdWZXJzaW9uICYmICF0aGlzLm5ld1NoYSkge1xuICAgICAgcmV0dXJuIFByb21pc2UucmVzb2x2ZSgpXG4gICAgfVxuXG4gICAgY29uc3QgcGFjayA9IHRoaXMuaW5zdGFsbGFibGVQYWNrICE9IG51bGwgPyB0aGlzLmluc3RhbGxhYmxlUGFjayA6IHRoaXMucGFja1xuICAgIGNvbnN0IHZlcnNpb24gPSB0aGlzLm5ld1ZlcnNpb24gPyBgdiR7dGhpcy5uZXdWZXJzaW9ufWAgOiBgIyR7dGhpcy5uZXdTaGEuc3Vic3RyKDAsIDgpfWBcbiAgICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUsIHJlamVjdCkgPT4ge1xuICAgICAgdGhpcy5wYWNrYWdlTWFuYWdlci51cGRhdGUocGFjaywgdGhpcy5uZXdWZXJzaW9uLCBlcnJvciA9PiB7XG4gICAgICAgIGlmIChlcnJvciAhPSBudWxsKSB7XG4gICAgICAgICAgYXRvbS5hc3NlcnQoZmFsc2UsICdQYWNrYWdlIHVwZGF0ZSBmYWlsZWQnLCBhc3NlcnRpb25FcnJvciA9PiB7XG4gICAgICAgICAgICBhc3NlcnRpb25FcnJvci5tZXRhZGF0YSA9IHtcbiAgICAgICAgICAgICAgdHlwZTogdGhpcy50eXBlLFxuICAgICAgICAgICAgICBuYW1lOiBwYWNrLm5hbWUsXG4gICAgICAgICAgICAgIHZlcnNpb24sXG4gICAgICAgICAgICAgIGVycm9yTWVzc2FnZTogZXJyb3IubWVzc2FnZSxcbiAgICAgICAgICAgICAgZXJyb3JTdGFjazogZXJyb3Iuc3RhY2ssXG4gICAgICAgICAgICAgIGVycm9yU3RkZXJyOiBlcnJvci5zdGRlcnJcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9KVxuICAgICAgICAgIGNvbnNvbGUuZXJyb3IoYFVwZGF0aW5nICR7dGhpcy50eXBlfSAke3BhY2submFtZX0gdG8gJHt2ZXJzaW9ufSBmYWlsZWQ6XFxuYCwgZXJyb3IsIGVycm9yLnN0ZGVyciAhPSBudWxsID8gZXJyb3Iuc3RkZXJyIDogJycpXG4gICAgICAgICAgcmVqZWN0KGVycm9yKVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHJlc29sdmUoKVxuICAgICAgICB9XG4gICAgICB9KVxuICAgIH0pXG4gIH1cblxuICB1bmluc3RhbGwgKCkge1xuICAgIHRoaXMucGFja2FnZU1hbmFnZXIudW5pbnN0YWxsKHRoaXMucGFjaywgKGVycm9yKSA9PiB7XG4gICAgICBpZiAoZXJyb3IgIT0gbnVsbCkge1xuICAgICAgICBjb25zb2xlLmVycm9yKGBVbmluc3RhbGxpbmcgJHt0aGlzLnR5cGV9ICR7dGhpcy5wYWNrLm5hbWV9IGZhaWxlZGAsIGVycm9yLnN0YWNrICE9IG51bGwgPyBlcnJvci5zdGFjayA6IGVycm9yLCBlcnJvci5zdGRlcnIpXG4gICAgICB9XG4gICAgfSlcbiAgfVxuXG4gIGluc3RhbGxBbHRlcm5hdGl2ZSAoKSB7XG4gICAgY29uc3QgbWV0YWRhdGEgPSB0aGlzLmdldERlcHJlY2F0ZWRQYWNrYWdlTWV0YWRhdGEoKVxuICAgIGNvbnN0IGxvYWRlZFBhY2sgPSBhdG9tLnBhY2thZ2VzLmdldExvYWRlZFBhY2thZ2UobWV0YWRhdGEgPyBtZXRhZGF0YS5hbHRlcm5hdGl2ZSA6IG51bGwpXG4gICAgaWYgKCFtZXRhZGF0YSB8fCAhbWV0YWRhdGEuaGFzQWx0ZXJuYXRpdmUgfHwgbWV0YWRhdGEuYWx0ZXJuYXRpdmUgPT09ICdjb3JlJyB8fCBsb2FkZWRQYWNrKSB7XG4gICAgICByZXR1cm5cbiAgICB9XG5cbiAgICB0aGlzLnBhY2thZ2VNYW5hZ2VyLmluc3RhbGxBbHRlcm5hdGl2ZSh0aGlzLnBhY2ssIG1ldGFkYXRhLmFsdGVybmF0aXZlLCAoZXJyb3IsIHtwYWNrLCBhbHRlcm5hdGl2ZX0pID0+IHtcbiAgICAgIGlmIChlcnJvciAhPSBudWxsKSB7XG4gICAgICAgIGNvbnNvbGUuZXJyb3IoYEluc3RhbGxpbmcgYWx0ZXJuYXRpdmUgXFxgJHthbHRlcm5hdGl2ZX1cXGAgJHt0aGlzLnR5cGV9IGZvciAke3RoaXMucGFjay5uYW1lfSBmYWlsZWRgLCBlcnJvci5zdGFjayAhPSBudWxsID8gZXJyb3Iuc3RhY2sgOiBlcnJvciwgZXJyb3Iuc3RkZXJyKVxuICAgICAgfVxuICAgIH0pXG4gIH1cbn1cbiJdfQ==