(function() {
  var CompositeDisposable, Notification, NotificationElement, Notifications, NotificationsLog, StackTraceParser, fs, isCoreOrPackageStackTrace, ref;

  ref = require('atom'), Notification = ref.Notification, CompositeDisposable = ref.CompositeDisposable;

  fs = require('fs-plus');

  StackTraceParser = null;

  NotificationElement = require('./notification-element');

  NotificationsLog = require('./notifications-log');

  Notifications = {
    isInitialized: false,
    subscriptions: null,
    duplicateTimeDelay: 500,
    lastNotification: null,
    activate: function(state) {
      var CommandLogger, i, len, notification, ref1;
      CommandLogger = require('./command-logger');
      CommandLogger.start();
      this.subscriptions = new CompositeDisposable;
      ref1 = atom.notifications.getNotifications();
      for (i = 0, len = ref1.length; i < len; i++) {
        notification = ref1[i];
        this.addNotificationView(notification);
      }
      this.subscriptions.add(atom.notifications.onDidAddNotification((function(_this) {
        return function(notification) {
          return _this.addNotificationView(notification);
        };
      })(this)));
      this.subscriptions.add(atom.onWillThrowError(function(arg) {
        var line, match, message, options, originalError, preventDefault, url;
        message = arg.message, url = arg.url, line = arg.line, originalError = arg.originalError, preventDefault = arg.preventDefault;
        if (originalError.name === 'BufferedProcessError') {
          message = message.replace('Uncaught BufferedProcessError: ', '');
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (originalError.code === 'ENOENT' && !/\/atom/i.test(message) && (match = /spawn (.+) ENOENT/.exec(message))) {
          message = "'" + match[1] + "' could not be spawned.\nIs it installed and on your path?\nIf so please open an issue on the package spawning the process.";
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (!atom.inDevMode() || atom.config.get('notifications.showErrorsInDevMode')) {
          preventDefault();
          if (originalError.stack && !isCoreOrPackageStackTrace(originalError.stack)) {
            return;
          }
          options = {
            detail: url + ":" + line,
            stack: originalError.stack,
            dismissable: true
          };
          return atom.notifications.addFatalError(message, options);
        }
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'core:cancel', function() {
        var j, len1, ref2, results;
        ref2 = atom.notifications.getNotifications();
        results = [];
        for (j = 0, len1 = ref2.length; j < len1; j++) {
          notification = ref2[j];
          results.push(notification.dismiss());
        }
        return results;
      }));
      this.subscriptions.add(atom.config.observe('notifications.defaultTimeout', (function(_this) {
        return function(value) {
          return _this.visibilityDuration = value;
        };
      })(this)));
      if (atom.inDevMode()) {
        this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:trigger-error', function() {
          var error, options;
          try {
            return abc + 2;
          } catch (error1) {
            error = error1;
            options = {
              detail: error.stack.split('\n')[1],
              stack: error.stack,
              dismissable: true
            };
            return atom.notifications.addFatalError("Uncaught " + (error.stack.split('\n')[0]), options);
          }
        }));
      }
      if (this.notificationsLog != null) {
        this.addNotificationsLogSubscriptions();
      }
      this.subscriptions.add(atom.workspace.addOpener((function(_this) {
        return function(uri) {
          if (uri === NotificationsLog.prototype.getURI()) {
            return _this.createLog();
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:toggle-log', function() {
        return atom.workspace.toggle(NotificationsLog.prototype.getURI());
      }));
      return this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:clear-log', function() {
        var j, len1, ref2;
        ref2 = atom.notifications.getNotifications();
        for (j = 0, len1 = ref2.length; j < len1; j++) {
          notification = ref2[j];
          notification.options.dismissable = true;
          notification.dismissed = false;
          notification.dismiss();
        }
        return atom.notifications.clear();
      }));
    },
    deactivate: function() {
      var ref1, ref2, ref3;
      this.subscriptions.dispose();
      if ((ref1 = this.notificationsElement) != null) {
        ref1.remove();
      }
      if ((ref2 = this.notificationsPanel) != null) {
        ref2.destroy();
      }
      if ((ref3 = this.notificationsLog) != null) {
        ref3.destroy();
      }
      this.subscriptions = null;
      this.notificationsElement = null;
      this.notificationsPanel = null;
      return this.isInitialized = false;
    },
    initializeIfNotInitialized: function() {
      if (this.isInitialized) {
        return;
      }
      this.subscriptions.add(atom.views.addViewProvider(Notification, (function(_this) {
        return function(model) {
          return new NotificationElement(model, _this.visibilityDuration);
        };
      })(this)));
      this.notificationsElement = document.createElement('atom-notifications');
      atom.views.getView(atom.workspace).appendChild(this.notificationsElement);
      return this.isInitialized = true;
    },
    createLog: function(state) {
      this.notificationsLog = new NotificationsLog(this.duplicateTimeDelay, state != null ? state.typesHidden : void 0);
      if (this.subscriptions != null) {
        this.addNotificationsLogSubscriptions();
      }
      return this.notificationsLog;
    },
    addNotificationsLogSubscriptions: function() {
      this.subscriptions.add(this.notificationsLog.onDidDestroy((function(_this) {
        return function() {
          return _this.notificationsLog = null;
        };
      })(this)));
      return this.subscriptions.add(this.notificationsLog.onItemClick((function(_this) {
        return function(notification) {
          var view;
          view = atom.views.getView(notification);
          view.makeDismissable();
          if (!view.element.classList.contains('remove')) {
            return;
          }
          view.element.classList.remove('remove');
          _this.notificationsElement.appendChild(view.element);
          notification.dismissed = false;
          return notification.setDisplayed(true);
        };
      })(this)));
    },
    addNotificationView: function(notification) {
      var ref1, ref2, timeSpan;
      if (notification == null) {
        return;
      }
      this.initializeIfNotInitialized();
      if (notification.wasDisplayed()) {
        return;
      }
      if (this.lastNotification != null) {
        timeSpan = notification.getTimestamp() - this.lastNotification.getTimestamp();
        if (!(timeSpan < this.duplicateTimeDelay && notification.isEqual(this.lastNotification))) {
          this.notificationsElement.appendChild(atom.views.getView(notification).element);
          if ((ref1 = this.notificationsLog) != null) {
            ref1.addNotification(notification);
          }
        }
      } else {
        this.notificationsElement.appendChild(atom.views.getView(notification).element);
        if ((ref2 = this.notificationsLog) != null) {
          ref2.addNotification(notification);
        }
      }
      notification.setDisplayed(true);
      return this.lastNotification = notification;
    }
  };

  isCoreOrPackageStackTrace = function(stack) {
    var file, i, len, ref1;
    if (StackTraceParser == null) {
      StackTraceParser = require('stacktrace-parser');
    }
    ref1 = StackTraceParser.parse(stack);
    for (i = 0, len = ref1.length; i < len; i++) {
      file = ref1[i].file;
      if (file === '<embedded>' || fs.isAbsolute(file)) {
        return true;
      }
    }
    return false;
  };

  module.exports = Notifications;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
