"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _githubTabContainer = _interopRequireDefault(require("../containers/github-tab-container"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabItem extends _react["default"].Component {
  static buildURI() {
    return this.uriPattern;
  }

  constructor(props) {
    super(props);
    this.rootHolder = new _refHolder["default"]();
  }

  getTitle() {
    return 'GitHub';
  }

  getIconName() {
    return 'octoface';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  serialize() {
    return {
      deserializer: 'GithubDockItem',
      uri: this.getURI()
    };
  }

  render() {
    return _react["default"].createElement(_githubTabContainer["default"], _extends({}, this.props, {
      rootHolder: this.rootHolder
    }));
  }

  hasFocus() {
    return this.rootHolder.map(root => root.contains(this.props.documentActiveElement())).getOr(false);
  }

  restoreFocus() {// No-op
  }

}

exports["default"] = GitHubTabItem;

_defineProperty(GitHubTabItem, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  documentActiveElement: _propTypes["default"].func
});

_defineProperty(GitHubTabItem, "defaultProps", {
  documentActiveElement:
  /* istanbul ignore next */
  () => document.activeElement
});

_defineProperty(GitHubTabItem, "uriPattern", 'atom-github://dock-item/github');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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