/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.helper.MultiTypeInterfaceContainer;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.Type;

public class ComponentBase
extends WeakBase
implements XComponent {
    private static final boolean DEBUG = false;
    protected MultiTypeInterfaceContainer listenerContainer = new MultiTypeInterfaceContainer();
    protected boolean bInDispose = false;
    protected boolean bDisposed = false;
    static final Type EVT_LISTENER_TYPE = new Type(XEventListener.class);

    protected void preDisposing() {
    }

    protected void postDisposing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        boolean bDoDispose = false;
        ComponentBase componentBase = this;
        synchronized (componentBase) {
            if (!this.bInDispose && !this.bDisposed) {
                bDoDispose = true;
                this.bInDispose = true;
            }
        }
        if (bDoDispose) {
            try {
                this.preDisposing();
                this.listenerContainer.disposeAndClear(new EventObject(this));
                this.postDisposing();
            }
            finally {
                componentBase = this;
                synchronized (componentBase) {
                    this.bDisposed = true;
                    this.bInDispose = false;
                }
            }
        }
    }

    @Override
    public void removeEventListener(XEventListener xEventListener) {
        this.listenerContainer.removeInterface(EVT_LISTENER_TYPE, xEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(XEventListener listener) {
        boolean bDoDispose = false;
        ComponentBase componentBase = this;
        synchronized (componentBase) {
            if (this.bDisposed || this.bInDispose) {
                bDoDispose = true;
            } else {
                this.listenerContainer.addInterface(EVT_LISTENER_TYPE, listener);
            }
        }
        if (bDoDispose) {
            listener.disposing(new EventObject(this));
        }
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.bInDispose && !this.bDisposed) {
            this.dispose();
        }
        super.finalize();
    }
}

