/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.storage.implementations;

import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverSpi;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class KeyStoreResolver
extends StorageResolverSpi {
    private KeyStore keyStore = null;

    public KeyStoreResolver(KeyStore keyStore) throws StorageResolverException {
        this.keyStore = keyStore;
        try {
            keyStore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            throw new StorageResolverException("generic.EmptyMessage", keyStoreException);
        }
    }

    @Override
    public Iterator<Certificate> getIterator() {
        return new KeyStoreIterator(this.keyStore);
    }

    static class KeyStoreIterator
    implements Iterator<Certificate> {
        KeyStore keyStore = null;
        Enumeration<String> aliases = null;
        Certificate nextCert = null;

        public KeyStoreIterator(KeyStore keyStore) {
            try {
                this.keyStore = keyStore;
                this.aliases = this.keyStore.aliases();
            }
            catch (KeyStoreException keyStoreException) {
                this.aliases = new Enumeration<String>(){

                    @Override
                    public boolean hasMoreElements() {
                        return false;
                    }

                    @Override
                    public String nextElement() {
                        return null;
                    }
                };
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextCert == null) {
                this.nextCert = this.findNextCert();
            }
            return this.nextCert != null;
        }

        @Override
        public Certificate next() {
            if (this.nextCert == null) {
                this.nextCert = this.findNextCert();
                if (this.nextCert == null) {
                    throw new NoSuchElementException();
                }
            }
            Certificate certificate = this.nextCert;
            this.nextCert = null;
            return certificate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }

        private Certificate findNextCert() {
            while (this.aliases.hasMoreElements()) {
                String string = this.aliases.nextElement();
                try {
                    Certificate certificate = this.keyStore.getCertificate(string);
                    if (certificate == null) continue;
                    return certificate;
                }
                catch (KeyStoreException keyStoreException) {
                    return null;
                }
            }
            return null;
        }
    }
}

