/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Arrays;
import sun.security.provider.ByteArrayAccess;
import sun.security.provider.DigestBase;

public final class MD4
extends DigestBase {
    private int[] state = new int[4];
    private int[] x = new int[16];
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;
    private static final Provider md4Provider = new Provider("MD4Provider", 1.0, "MD4 MessageDigest"){
        private static final long serialVersionUID = -8850464997518327965L;
    };

    public static MessageDigest getInstance() {
        try {
            return MessageDigest.getInstance("MD4", md4Provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
    }

    public MD4() {
        super("MD4", 16, 64);
        this.resetHashes();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MD4 copy = (MD4)super.clone();
        copy.state = (int[])copy.state.clone();
        copy.x = new int[16];
        return copy;
    }

    @Override
    void implReset() {
        this.resetHashes();
        Arrays.fill(this.x, 0);
    }

    private void resetHashes() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
    }

    @Override
    void implDigest(byte[] out, int ofs) {
        long bitsProcessed = this.bytesProcessed << 3;
        int index = (int)this.bytesProcessed & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.engineUpdate(padding, 0, padLen);
        ByteArrayAccess.i2bLittle4((int)bitsProcessed, this.buffer, 56);
        ByteArrayAccess.i2bLittle4((int)(bitsProcessed >>> 32), this.buffer, 60);
        this.implCompress(this.buffer, 0);
        ByteArrayAccess.i2bLittle(this.state, 0, out, ofs, 16);
    }

    private static int FF(int a, int b, int c, int d, int x, int s) {
        return (a += (b & c | ~b & d) + x) << s | a >>> 32 - s;
    }

    private static int GG(int a, int b, int c, int d, int x, int s) {
        return (a += (b & c | b & d | c & d) + x + 1518500249) << s | a >>> 32 - s;
    }

    private static int HH(int a, int b, int c, int d, int x, int s) {
        return (a += (b ^ c ^ d) + x + 1859775393) << s | a >>> 32 - s;
    }

    @Override
    void implCompress(byte[] buf, int ofs) {
        ByteArrayAccess.b2iLittle64(buf, ofs, this.x);
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        a = MD4.FF(a, b, c, d, this.x[0], 3);
        d = MD4.FF(d, a, b, c, this.x[1], 7);
        c = MD4.FF(c, d, a, b, this.x[2], 11);
        b = MD4.FF(b, c, d, a, this.x[3], 19);
        a = MD4.FF(a, b, c, d, this.x[4], 3);
        d = MD4.FF(d, a, b, c, this.x[5], 7);
        c = MD4.FF(c, d, a, b, this.x[6], 11);
        b = MD4.FF(b, c, d, a, this.x[7], 19);
        a = MD4.FF(a, b, c, d, this.x[8], 3);
        d = MD4.FF(d, a, b, c, this.x[9], 7);
        c = MD4.FF(c, d, a, b, this.x[10], 11);
        b = MD4.FF(b, c, d, a, this.x[11], 19);
        a = MD4.FF(a, b, c, d, this.x[12], 3);
        d = MD4.FF(d, a, b, c, this.x[13], 7);
        c = MD4.FF(c, d, a, b, this.x[14], 11);
        b = MD4.FF(b, c, d, a, this.x[15], 19);
        a = MD4.GG(a, b, c, d, this.x[0], 3);
        d = MD4.GG(d, a, b, c, this.x[4], 5);
        c = MD4.GG(c, d, a, b, this.x[8], 9);
        b = MD4.GG(b, c, d, a, this.x[12], 13);
        a = MD4.GG(a, b, c, d, this.x[1], 3);
        d = MD4.GG(d, a, b, c, this.x[5], 5);
        c = MD4.GG(c, d, a, b, this.x[9], 9);
        b = MD4.GG(b, c, d, a, this.x[13], 13);
        a = MD4.GG(a, b, c, d, this.x[2], 3);
        d = MD4.GG(d, a, b, c, this.x[6], 5);
        c = MD4.GG(c, d, a, b, this.x[10], 9);
        b = MD4.GG(b, c, d, a, this.x[14], 13);
        a = MD4.GG(a, b, c, d, this.x[3], 3);
        d = MD4.GG(d, a, b, c, this.x[7], 5);
        c = MD4.GG(c, d, a, b, this.x[11], 9);
        b = MD4.GG(b, c, d, a, this.x[15], 13);
        a = MD4.HH(a, b, c, d, this.x[0], 3);
        d = MD4.HH(d, a, b, c, this.x[8], 9);
        c = MD4.HH(c, d, a, b, this.x[4], 11);
        b = MD4.HH(b, c, d, a, this.x[12], 15);
        a = MD4.HH(a, b, c, d, this.x[2], 3);
        d = MD4.HH(d, a, b, c, this.x[10], 9);
        c = MD4.HH(c, d, a, b, this.x[6], 11);
        b = MD4.HH(b, c, d, a, this.x[14], 15);
        a = MD4.HH(a, b, c, d, this.x[1], 3);
        d = MD4.HH(d, a, b, c, this.x[9], 9);
        c = MD4.HH(c, d, a, b, this.x[5], 11);
        b = MD4.HH(b, c, d, a, this.x[13], 15);
        a = MD4.HH(a, b, c, d, this.x[3], 3);
        d = MD4.HH(d, a, b, c, this.x[11], 9);
        c = MD4.HH(c, d, a, b, this.x[7], 11);
        b = MD4.HH(b, c, d, a, this.x[15], 15);
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                md4Provider.put("MessageDigest.MD4", "sun.security.provider.MD4");
                return null;
            }
        });
    }
}

