/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.LogicInstruction;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.sparc.SPARCFormat3AInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

public class SPARCLogicInstruction
extends SPARCFormat3AInstruction
implements LogicInstruction {
    private final int operation;

    public SPARCLogicInstruction(String name, int opcode, int operation, SPARCRegister rs1, ImmediateOrRegister operand2, SPARCRegister rd) {
        super(name, opcode, rs1, operand2, rd);
        this.operation = operation;
    }

    @Override
    protected String getDescription() {
        SPARCRegister G0 = SPARCRegisters.G0;
        if (this.opcode == 18 && this.rd == G0 && this.rd == this.operand2) {
            StringBuffer buf = new StringBuffer();
            buf.append("tst");
            buf.append(spaces);
            buf.append(this.getOperand2String());
            return buf.toString();
        }
        if (this.opcode == 7 && G0 == this.operand2) {
            StringBuffer buf = new StringBuffer();
            buf.append("not");
            buf.append(spaces);
            buf.append(this.rs1.toString());
            if (this.rs1 != this.rd) {
                buf.append(comma);
                buf.append(this.rd.toString());
            }
            return buf.toString();
        }
        if (this.opcode == 17 && this.rd == G0) {
            StringBuffer buf = new StringBuffer();
            buf.append("btst");
            buf.append(spaces);
            buf.append(this.getOperand2String());
            buf.append(comma);
            buf.append(this.rd.toString());
            return buf.toString();
        }
        if (this.rs1 == this.rd) {
            StringBuffer buf = new StringBuffer();
            switch (this.opcode) {
                case 2: {
                    buf.append("bset");
                    break;
                }
                case 5: {
                    buf.append("bclr");
                    break;
                }
                case 3: {
                    buf.append("btog");
                    break;
                }
                default: {
                    return super.getDescription();
                }
            }
            buf.append(spaces);
            buf.append(this.getOperand2String());
            buf.append(comma);
            buf.append(this.rd.toString());
            return buf.toString();
        }
        return super.getDescription();
    }

    @Override
    public Operand getLogicDestination() {
        return this.getDestinationRegister();
    }

    @Override
    public Operand[] getLogicSources() {
        return new Operand[]{this.rs1, this.operand2};
    }

    @Override
    public int getOperation() {
        return this.operation;
    }

    public boolean isLogic() {
        return true;
    }
}

