/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as tslib_1 from "tslib";
/**
 * @record
 */
export function IVisitor() { }
function IVisitor_tsickle_Closure_declarations() {
    /** @type {?} */
    IVisitor.prototype.visitTag;
    /** @type {?} */
    IVisitor.prototype.visitElement;
    /** @type {?} */
    IVisitor.prototype.visitText;
    /** @type {?} */
    IVisitor.prototype.visitDeclaration;
    /** @type {?} */
    IVisitor.prototype.visitDoctype;
}
var Visitor = /** @class */ (function () {
    function Visitor() {
    }
    /**
     * @param {?} tag
     * @return {?}
     */
    Visitor.prototype.visitTag = /**
     * @param {?} tag
     * @return {?}
     */
    function (tag) {
        var _this = this;
        var /** @type {?} */ strAttrs = this._serializeAttributes(tag.attrs);
        if (tag.children.length === 0) {
            return "<" + tag.name + strAttrs + "/>";
        }
        var /** @type {?} */ strChildren = tag.children.map(function (node) { return node.visit(_this); });
        return "<" + tag.name + strAttrs + ">" + strChildren.join("") + "</" + tag.name + ">";
    };
    /**
     * @param {?} text
     * @return {?}
     */
    Visitor.prototype.visitText = /**
     * @param {?} text
     * @return {?}
     */
    function (text) {
        return _escapeXml(text.value);
    };
    /**
     * @param {?} element
     * @return {?}
     */
    Visitor.prototype.visitElement = /**
     * @param {?} element
     * @return {?}
     */
    function (element) {
        var /** @type {?} */ attrs = {};
        element.attrs.forEach(function (attr) {
            attrs[attr.name] = attr.value;
        });
        var /** @type {?} */ tag = new Tag(element.name, attrs, /** @type {?} */ (element.children));
        return this.visitTag(tag);
    };
    /**
     * @param {?} decl
     * @return {?}
     */
    Visitor.prototype.visitDeclaration = /**
     * @param {?} decl
     * @return {?}
     */
    function (decl) {
        return "<?xml" + this._serializeAttributes(decl.attrs) + " ?>";
    };
    /**
     * @param {?} attrs
     * @return {?}
     */
    Visitor.prototype._serializeAttributes = /**
     * @param {?} attrs
     * @return {?}
     */
    function (attrs) {
        var /** @type {?} */ strAttrs = Object.keys(attrs)
            .map(function (name) { return name + "=\"" + _escapeXml(attrs[name]) + "\""; })
            .join(" ");
        return strAttrs.length > 0 ? " " + strAttrs : "";
    };
    /**
     * @param {?} doctype
     * @return {?}
     */
    Visitor.prototype.visitDoctype = /**
     * @param {?} doctype
     * @return {?}
     */
    function (doctype) {
        return "<!DOCTYPE " + doctype.rootTag + " [\n" + doctype.dtd + "\n]>";
    };
    return Visitor;
}());
var /** @type {?} */ _visitor = new Visitor();
/**
 * @param {?} nodes
 * @return {?}
 */
export function serialize(nodes) {
    return nodes.map(function (node) { return node.visit(_visitor); }).join("");
}
/**
 * @record
 */
export function Node() { }
function Node_tsickle_Closure_declarations() {
    /** @type {?} */
    Node.prototype.visit;
}
var Declaration = /** @class */ (function () {
    function Declaration(attrs) {
        this.attrs = attrs;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    Declaration.prototype.visit = /**
     * @param {?} visitor
     * @return {?}
     */
    function (visitor) {
        return visitor.visitDeclaration(this);
    };
    return Declaration;
}());
export { Declaration };
function Declaration_tsickle_Closure_declarations() {
    /** @type {?} */
    Declaration.prototype.attrs;
}
var Doctype = /** @class */ (function () {
    function Doctype(rootTag, dtd) {
        this.rootTag = rootTag;
        this.dtd = dtd;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    Doctype.prototype.visit = /**
     * @param {?} visitor
     * @return {?}
     */
    function (visitor) {
        return visitor.visitDoctype(this);
    };
    return Doctype;
}());
export { Doctype };
function Doctype_tsickle_Closure_declarations() {
    /** @type {?} */
    Doctype.prototype.rootTag;
    /** @type {?} */
    Doctype.prototype.dtd;
}
var Tag = /** @class */ (function () {
    function Tag(name, attrs, children) {
        if (attrs === void 0) { attrs = {}; }
        if (children === void 0) { children = []; }
        this.name = name;
        this.attrs = attrs;
        this.children = children;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    Tag.prototype.visit = /**
     * @param {?} visitor
     * @return {?}
     */
    function (visitor) {
        return visitor.visitTag(this);
    };
    return Tag;
}());
export { Tag };
function Tag_tsickle_Closure_declarations() {
    /** @type {?} */
    Tag.prototype.name;
    /** @type {?} */
    Tag.prototype.attrs;
    /** @type {?} */
    Tag.prototype.children;
}
var Text = /** @class */ (function () {
    function Text(value) {
        this.value = value;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    Text.prototype.visit = /**
     * @param {?} visitor
     * @return {?}
     */
    function (visitor) {
        return visitor.visitText(this);
    };
    return Text;
}());
export { Text };
function Text_tsickle_Closure_declarations() {
    /** @type {?} */
    Text.prototype.value;
}
var CR = /** @class */ (function (_super) {
    tslib_1.__extends(CR, _super);
    function CR(ws) {
        if (ws === void 0) { ws = 0; }
        return _super.call(this, "\n" + new Array(ws + 1).join(" ")) || this;
    }
    return CR;
}(Text));
export { CR };
var /** @type {?} */ _ESCAPED_CHARS = [
    [/&/g, "&amp;"],
    [/"/g, "&quot;"],
    [/'/g, "&apos;"],
    [/</g, "&lt;"],
    [/>/g, "&gt;"]
];
/**
 * @param {?} text
 * @return {?}
 */
function _escapeXml(text) {
    return _ESCAPED_CHARS.reduce(function (str, entry) { return str.replace(entry[0], entry[1]); }, text);
}

//# sourceMappingURL=data:application/json;base64,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