/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { LifecycleHooksFeature, renderComponent, whenRendered } from './component';
import { defineBase, defineComponent, defineDirective, defineNgModule, definePipe } from './definition';
import { getComponent, getHostElement, getRenderedText } from './discovery_utils';
import { InheritDefinitionFeature } from './features/inherit_definition_feature';
import { NgOnChangesFeature } from './features/ng_onchanges_feature';
import { ProvidersFeature } from './features/providers_feature';
export { ComponentFactory, ComponentFactoryResolver, ComponentRef, injectComponentFactoryResolver } from './component_ref';
export { getFactoryOf, getInheritedFactory } from './di';
// clang-format off
export { allocHostVars, bind, interpolation1, interpolation2, interpolation3, interpolation4, interpolation5, interpolation6, interpolation7, interpolation8, interpolationV, container, containerRefreshStart, containerRefreshEnd, nextContext, element, elementAttribute, elementClassProp, elementEnd, elementProperty, componentHostSyntheticProperty, elementStart, elementContainerStart, elementContainerEnd, elementStyling, elementHostAttrs, elementStylingMap, elementStyleProp, elementStylingApply, listener, store, load, namespaceHTML, namespaceMathML, namespaceSVG, projection, projectionDef, text, textBinding, template, reference, embeddedViewStart, embeddedViewEnd, detectChanges, markDirty, tick, directiveInject, injectAttribute, getCurrentView } from './instructions';
export { restoreView, enableBindings, disableBindings, } from './state';
export { i18n, i18nAttributes, i18nExp, i18nStart, i18nEnd, i18nApply, i18nPostprocess } from './i18n';
export { NgModuleFactory, NgModuleRef } from './ng_module_ref';
export { setClassMetadata, } from './metadata';
export { pipe, pipeBind1, pipeBind2, pipeBind3, pipeBind4, pipeBindV, } from './pipe';
export { QueryList, query, queryRefresh, } from './query';
export { registerContentQuery, loadQueryList, } from './instructions';
export { pureFunction0, pureFunction1, pureFunction2, pureFunction3, pureFunction4, pureFunction5, pureFunction6, pureFunction7, pureFunction8, pureFunctionV, } from './pure_function';
export { templateRefExtractor } from './view_engine_compatibility_prebound';
// clang-format on
export { NgOnChangesFeature, InheritDefinitionFeature, ProvidersFeature, LifecycleHooksFeature, defineComponent, defineDirective, defineNgModule, defineBase, definePipe, getHostElement, getComponent, getRenderedText, renderComponent, whenRendered, };
export { NO_CHANGE } from './tokens';
//# sourceMappingURL=data:application/json;base64,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