/*
 * Decompiled with CFR 0.152.
 */
package jdepend.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageComparator;
import jdepend.framework.PackageFilter;
import jdepend.framework.ParserListener;
import jdepend.swingui.AboutDialog;
import jdepend.swingui.AfferentNode;
import jdepend.swingui.DependTree;
import jdepend.swingui.DependTreeModel;
import jdepend.swingui.EfferentNode;
import jdepend.swingui.PackageNode;
import jdepend.swingui.StatusPanel;

public class JDepend
implements ParserListener {
    private jdepend.framework.JDepend analyzer = new jdepend.framework.JDepend();
    private JFrame frame;
    private StatusPanel statusPanel;
    private JTextField statusField;
    private JProgressBar progressBar;
    private DependTree afferentTree;
    private DependTree efferentTree;
    private Hashtable resourceStrings;
    private Hashtable actions;
    private static Font BOLD_FONT = new Font("dialog", 1, 12);

    public JDepend() {
        this.analyzer.addParseListener(this);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resourceStrings = new Hashtable();
        this.resourceStrings.put("menubar", "File");
        this.resourceStrings.put("File", "About Exit");
        this.actions = new Hashtable();
        this.actions.put("About", new AboutAction());
        this.actions.put("Exit", new ExitAction());
    }

    public void addDirectory(String name) throws IOException {
        this.analyzer.addDirectory(name);
    }

    public void setFilter(PackageFilter filter) {
        this.analyzer.setFilter(filter);
    }

    public void setComponents(String components) {
        this.analyzer.setComponents(components);
    }

    public void analyze() {
        this.display();
        this.startProgressMonitor(this.analyzer.countClasses());
        ArrayList packages = new ArrayList(this.analyzer.analyze());
        Collections.sort(packages, new PackageComparator(PackageComparator.byName()));
        this.stopProgressMonitor();
        this.updateTree(packages);
    }

    @Override
    public void onParsedJavaClass(JavaClass jClass) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDepend.this.getProgressBar().setValue(JDepend.this.getProgressBar().getValue() + 1);
            }
        });
    }

    private void display() {
        this.frame = this.createUI();
        this.frame.setVisible(true);
    }

    private void updateTree(ArrayList packages) {
        JavaPackage jPackage = new JavaPackage("root");
        jPackage.setAfferents(packages);
        jPackage.setEfferents(packages);
        AfferentNode ah = new AfferentNode(null, jPackage);
        this.getAfferentTree().setModel(new DependTreeModel(ah));
        EfferentNode eh = new EfferentNode(null, jPackage);
        this.getEfferentTree().setModel(new DependTreeModel(eh));
    }

    private void startProgressMonitor(final int maxValue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDepend.this.getProgressBar().setMinimum(0);
                JDepend.this.getProgressBar().setMaximum(maxValue);
                JDepend.this.getStatusPanel().setStatusComponent(JDepend.this.getProgressBar());
            }
        });
    }

    private void stopProgressMonitor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDepend.this.getStatusPanel().setStatusComponent(JDepend.this.getStatusField());
                int classCount = JDepend.this.analyzer.countClasses();
                int packageCount = JDepend.this.analyzer.countPackages();
                JDepend.this.showStatusMessage("Analyzed " + packageCount + " packages (" + classCount + " classes).");
            }
        });
    }

    private JFrame createUI() {
        JFrame frame = this.createFrame("JDepend");
        JMenuBar menuBar = this.createMenubar();
        frame.setJMenuBar(menuBar);
        JPanel treePanel = this.createTreePanel();
        StatusPanel statusPanel = this.getStatusPanel();
        frame.getContentPane().add("Center", treePanel);
        frame.getContentPane().add("South", statusPanel);
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 700;
        int height = 500;
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        frame.setBounds(x, y, width, height);
        frame.setSize(width, height);
        return frame;
    }

    private JFrame createFrame(String title) {
        JFrame frame = new JFrame(title);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.setBackground(SystemColor.control);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                new ExitAction().actionPerformed(null);
            }
        });
        return frame;
    }

    private JPanel createTreePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(this.getEfferentTree());
        panel.add(this.getAfferentTree());
        return panel;
    }

    private StatusPanel createStatusPanel() {
        StatusPanel panel = new StatusPanel();
        panel.setStatusComponent(this.getStatusField());
        return panel;
    }

    private JProgressBar createProgressBar() {
        JProgressBar bar = new JProgressBar();
        bar.setStringPainted(true);
        return bar;
    }

    private JTextField createStatusField() {
        JTextField statusField = new JTextField();
        statusField.setFont(BOLD_FONT);
        statusField.setEditable(false);
        statusField.setForeground(Color.black);
        statusField.setBorder(BorderFactory.createBevelBorder(1));
        Insets insets = new Insets(5, 5, 5, 5);
        statusField.setMargin(insets);
        return statusField;
    }

    private JMenuBar createMenubar() {
        JMenuBar menuBar = new JMenuBar();
        String[] menuKeys = this.tokenize((String)this.resourceStrings.get("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            menuBar.add(m);
        }
        return menuBar;
    }

    private JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize((String)this.resourceStrings.get(key));
        JMenu menu = new JMenu(key);
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i]);
            menu.add(mi);
        }
        char mnemonic = key.charAt(0);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    private JMenuItem createMenuItem(String key) {
        JMenuItem mi = new JMenuItem(key);
        char mnemonic = key.charAt(0);
        mi.setMnemonic(mnemonic);
        char accelerator = key.charAt(0);
        mi.setAccelerator(KeyStroke.getKeyStroke((int)accelerator, 2));
        String actionString = key;
        mi.setActionCommand(actionString);
        Action a = this.getActionForCommand(actionString);
        if (a != null) {
            mi.addActionListener(a);
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        return mi;
    }

    private void showStatusMessage(String message) {
        this.getStatusField().setFont(BOLD_FONT);
        this.getStatusField().setForeground(Color.black);
        this.getStatusField().setText(" " + message);
    }

    private void showStatusError(String message) {
        this.getStatusField().setFont(BOLD_FONT);
        this.getStatusField().setForeground(Color.red);
        this.getStatusField().setText(" " + message);
    }

    private DependTree getAfferentTree() {
        if (this.afferentTree == null) {
            this.afferentTree = new DependTree();
            this.afferentTree.addTreeSelectionListener(new TreeListener());
        }
        return this.afferentTree;
    }

    private DependTree getEfferentTree() {
        if (this.efferentTree == null) {
            this.efferentTree = new DependTree();
            this.efferentTree.addTreeSelectionListener(new TreeListener());
        }
        return this.efferentTree;
    }

    private StatusPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = this.createStatusPanel();
        }
        return this.statusPanel;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = this.createProgressBar();
        }
        return this.progressBar;
    }

    private JTextField getStatusField() {
        if (this.statusField == null) {
            this.statusField = this.createStatusField();
        }
        return this.statusField;
    }

    private Action getActionForCommand(String command) {
        return (Action)this.actions.get(command);
    }

    private String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    private void postStatusMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDepend.this.showStatusMessage(message);
            }
        });
    }

    private void postStatusError(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDepend.this.showStatusError(message);
            }
        });
    }

    private void usage(String message) {
        if (message != null) {
            System.err.println("\n" + message);
        }
        String baseUsage = "\nJDepend ";
        System.err.println("");
        System.err.println("usage: ");
        System.err.println(baseUsage + "-components <components> <directory> [directory2 [directory 3] ...]");
        System.exit(1);
    }

    private void instanceMain(String[] args) {
        if (args.length < 1) {
            this.usage("Must specify at least one directory.");
        }
        int directoryCount = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-components")) {
                    if (args.length <= i + 1) {
                        this.usage("Components not specified.");
                    }
                    this.setComponents(args[++i]);
                    continue;
                }
                this.usage("Invalid argument: " + args[i]);
                continue;
            }
            try {
                this.addDirectory(args[i]);
                ++directoryCount;
                continue;
            }
            catch (IOException ioe) {
                this.usage("Directory does not exist: " + args[i]);
            }
        }
        if (directoryCount == 0) {
            this.usage("Must specify at least one directory.");
        }
        this.analyze();
    }

    public static void main(String[] args) {
        new JDepend().instanceMain(args);
    }

    private class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDepend.this.frame.dispose();
            System.exit(0);
        }
    }

    private class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog d = new AboutDialog(JDepend.this.frame);
            d.setModal(true);
            d.setLocation(300, 300);
            d.show();
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent te) {
            TreePath path = te.getNewLeadSelectionPath();
            if (path != null) {
                PackageNode node = (PackageNode)path.getLastPathComponent();
                JDepend.this.showStatusMessage(node.toMetricsString());
            }
        }
    }
}

