/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.openide.util.NbBundle;

public final class CategoryResult
implements Runnable {
    static final int MAX_RESULTS = 7;
    static final int ALL_MAX_RESULTS = 30;
    private final boolean allResults;
    private final Object LOCK = new Object();
    private final ProviderModel.Category category;
    private final List<ResultsModel.ItemResult> items;
    private boolean obsolete;
    private int previousSize;
    private boolean moreResults = false;

    public CategoryResult(ProviderModel.Category category, boolean bl) {
        this.category = category;
        this.allResults = bl;
        this.items = new ArrayList<ResultsModel.ItemResult>(bl ? 30 : 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItem(ResultsModel.ItemResult itemResult) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.obsolete) {
                return false;
            }
            if (this.items.size() >= (this.allResults ? 30 : 7)) {
                if (!this.allResults) {
                    this.moreResults = true;
                }
                return false;
            }
            this.items.add(itemResult);
        }
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultsModel.ItemResult> getItems() {
        ArrayList<ResultsModel.ItemResult> arrayList = null;
        Object object = this.LOCK;
        synchronized (object) {
            arrayList = new ArrayList<ResultsModel.ItemResult>(this.items);
            if (this.moreResults) {
                arrayList.add(new ResultsModel.ItemResult(this, null, this, NbBundle.getMessage(this.getClass(), (String)"LBL_MoreResults")));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstItem(ResultsModel.ItemResult itemResult) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.items.size() > 0 && this.items.get(0).equals(itemResult)) {
                return true;
            }
        }
        return false;
    }

    public ProviderModel.Category getCategory() {
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObsolete(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            this.obsolete = bl;
        }
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        boolean bl = false;
        Object object = this.LOCK;
        synchronized (object) {
            n = this.items.size();
            bl = !this.obsolete && this.items.size() <= (this.allResults ? 30 : 7);
        }
        if (!bl) {
            return;
        }
        if (n > this.previousSize) {
            this.previousSize = n;
            ResultsModel.getInstance().categoryChanged(this);
        }
    }
}

