/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;

abstract class AbstractAsyncTypeReturnsNull
extends BugChecker
implements BugChecker.ReturnTreeMatcher {
    private final Matcher<MethodTree> implementsAsyncTypeMethod;

    AbstractAsyncTypeReturnsNull(Class<?> asyncClass) {
        this.implementsAsyncTypeMethod = AbstractAsyncTypeReturnsNull.overridesMethodOfClass(asyncClass);
    }

    public final Description matchReturn(ReturnTree tree, VisitorState state) {
        TreePath path;
        if (tree.getExpression() == null || tree.getExpression().getKind() != Tree.Kind.NULL_LITERAL) {
            return Description.NO_MATCH;
        }
        for (path = state.getPath(); path != null && path.getLeaf() instanceof StatementTree; path = path.getParentPath()) {
        }
        if (path == null || !(path.getLeaf() instanceof MethodTree)) {
            return Description.NO_MATCH;
        }
        if (!this.implementsAsyncTypeMethod.matches((Tree)((MethodTree)path.getLeaf()), state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace((Tree)tree.getExpression(), "immediateFuture(null)").addStaticImport(Futures.class.getName() + ".immediateFuture").build());
    }

    private static Matcher<MethodTree> overridesMethodOfClass(final Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return new Matcher<MethodTree>(){

            public boolean matches(MethodTree tree, VisitorState state) {
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
                if (symbol == null) {
                    return false;
                }
                for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes())) {
                    if (superMethod.owner == null || !superMethod.owner.getQualifiedName().contentEquals(clazz.getName())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

