"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const node_1 = require("@angular-devkit/core/node");
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
/**
 * @deprecated
 */
class TestProjectHost extends node_1.NodeJsSyncHost {
    constructor(_templateRoot) {
        super();
        this._templateRoot = _templateRoot;
        this._currentRoot = null;
        this._scopedSyncHost = null;
    }
    root() {
        if (this._currentRoot === null) {
            throw new Error('TestProjectHost must be initialized before being used.');
        }
        return this._currentRoot;
    }
    scopedSync() {
        if (this._currentRoot === null || this._scopedSyncHost === null) {
            throw new Error('TestProjectHost must be initialized before being used.');
        }
        return this._scopedSyncHost;
    }
    initialize() {
        const recursiveList = (path) => this.list(path).pipe(
        // Emit each fragment individually.
        operators_1.concatMap(fragments => rxjs_1.from(fragments)), 
        // Join the path with fragment.
        operators_1.map(fragment => core_1.join(path, fragment)), 
        // Emit directory content paths instead of the directory path.
        operators_1.mergeMap(path => this.isDirectory(path).pipe(operators_1.concatMap(isDir => isDir ? recursiveList(path) : rxjs_1.of(path)))));
        // Find a unique folder that we can write to to use as current root.
        return this.findUniqueFolderPath().pipe(
        // Save the path and create a scoped host for it.
        operators_1.tap(newFolderPath => {
            this._currentRoot = newFolderPath;
            this._scopedSyncHost = new core_1.virtualFs.SyncDelegateHost(new core_1.virtualFs.ScopedHost(this, this.root()));
        }), 
        // List all files in root.
        operators_1.concatMap(() => recursiveList(this._templateRoot)), 
        // Copy them over to the current root.
        operators_1.concatMap(from => {
            const to = core_1.join(this.root(), core_1.relative(this._templateRoot, from));
            return this.read(from).pipe(operators_1.concatMap(buffer => this.write(to, buffer)));
        }), operators_1.map(() => { }));
    }
    restore() {
        if (this._currentRoot === null) {
            return rxjs_1.EMPTY;
        }
        // Delete the current root and clear the variables.
        // Wait 50ms and retry up to 10 times, to give time for file locks to clear.
        return this.exists(this.root()).pipe(operators_1.delay(50), operators_1.concatMap(exists => exists ? this.delete(this.root()) : rxjs_1.EMPTY), operators_1.retry(10), operators_1.finalize(() => {
            this._currentRoot = null;
            this._scopedSyncHost = null;
        }));
    }
    writeMultipleFiles(files) {
        Object.keys(files).forEach(fileName => {
            let content = files[fileName];
            if (typeof content == 'string') {
                content = core_1.virtualFs.stringToFileBuffer(content);
            }
            else if (content instanceof Buffer) {
                content = content.buffer.slice(content.byteOffset, content.byteOffset + content.byteLength);
            }
            this.scopedSync().write(core_1.normalize(fileName), content);
        });
    }
    replaceInFile(path, match, replacement) {
        const content = core_1.virtualFs.fileBufferToString(this.scopedSync().read(core_1.normalize(path)));
        this.scopedSync().write(core_1.normalize(path), core_1.virtualFs.stringToFileBuffer(content.replace(match, replacement)));
    }
    appendToFile(path, str) {
        const content = core_1.virtualFs.fileBufferToString(this.scopedSync().read(core_1.normalize(path)));
        this.scopedSync().write(core_1.normalize(path), core_1.virtualFs.stringToFileBuffer(content.concat(str)));
    }
    fileMatchExists(dir, regex) {
        const [fileName] = this.scopedSync().list(core_1.normalize(dir)).filter(name => name.match(regex));
        return fileName || undefined;
    }
    copyFile(from, to) {
        const content = this.scopedSync().read(core_1.normalize(from));
        this.scopedSync().write(core_1.normalize(to), content);
    }
    findUniqueFolderPath() {
        // 11 character alphanumeric string.
        const randomString = Math.random().toString(36).slice(2);
        const newFolderName = `test-project-host-${core_1.basename(this._templateRoot)}-${randomString}`;
        const newFolderPath = core_1.join(core_1.dirname(this._templateRoot), newFolderName);
        return this.exists(newFolderPath).pipe(operators_1.concatMap(exists => exists ? this.findUniqueFolderPath() : rxjs_1.of(newFolderPath)));
    }
}
exports.TestProjectHost = TestProjectHost;
//# sourceMappingURL=data:application/json;base64,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