/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.jps.JpsProxy;
import org.netbeans.lib.profiler.jps.RunningVM;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.swing.ActionPopupButton;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.attach.dialog.Bundle;
import org.netbeans.modules.profiler.attach.spi.AttachStepsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class AttachDialog
extends AttachWizard {
    private AttachStepsProvider currentProvider;
    private Panel panel;
    private static final String ATTACH_WIZARD_HELPCTX = "AttachDialog.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("AttachDialog.HelpCtx");

    @Override
    public boolean configured(AttachSettings attachSettings) {
        if (attachSettings == null) {
            return false;
        }
        if (attachSettings.isRemote()) {
            String string = attachSettings.getHost();
            return string != null && !string.trim().isEmpty();
        }
        if (attachSettings.isDirect()) {
            return true;
        }
        int n = attachSettings.getPid();
        String string = attachSettings.getProcessName();
        if (n == -1 || string == null) {
            return false;
        }
        assert (!SwingUtilities.isEventDispatchThread());
        RunningVM[] runningVMArray = JpsProxy.getRunningVMs();
        if (runningVMArray == null || runningVMArray.length == 0) {
            return false;
        }
        ArrayList<RunningVM> arrayList = new ArrayList<RunningVM>();
        for (RunningVM runningVM : runningVMArray) {
            if (!AttachDialog.getProcessName(runningVM.getMainClass()).equals(string)) continue;
            arrayList.add(runningVM);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        if (attachSettings.isAutoSelectProcess() && arrayList.size() == 1) {
            attachSettings.setPid(((RunningVM)arrayList.get(0)).getPid());
            return true;
        }
        for (RunningVM runningVM : arrayList) {
            if (runningVM.getPid() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public AttachSettings configure(AttachSettings attachSettings, boolean bl) {
        AttachSettings attachSettings2;
        if (attachSettings == null) {
            attachSettings = new AttachSettings();
        }
        if (attachSettings.getTargetType().isEmpty()) {
            attachSettings.setDirect(false);
            attachSettings.setDynamic16(true);
            attachSettings.setRemote(false);
        }
        attachSettings.setTargetType(Bundle.AttachDialog_JavaApplication());
        attachSettings.setServerType(Bundle.AttachDialog_JavaApplication());
        this.panel = new Panel();
        this.panel.setup(attachSettings);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, Bundle.AttachDialog_Caption());
        if (!bl) {
            dialogDescriptor.setValid(false);
            this.panel.setDisplayer(dialogDescriptor);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        AttachSettings attachSettings3 = attachSettings2 = dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION ? this.panel.getSettings() : null;
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        this.currentProvider = null;
        this.panel = null;
        return attachSettings2;
    }

    private String steps(AttachSettings attachSettings) {
        Collection collection = Lookup.getDefault().lookupAll(AttachStepsProvider.class);
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        for (AttachStepsProvider attachStepsProvider : collection) {
            String string = attachStepsProvider.getSteps(attachSettings);
            if (string == null) continue;
            this.currentProvider = attachStepsProvider;
            this.currentProvider.addChangeListener(this.panel);
            return string;
        }
        this.currentProvider = null;
        return Bundle.AttachDialog_NoSteps();
    }

    private static String getProcessName(String string) {
        string = string == null ? null : string.trim();
        return string == null || string.isEmpty() ? Bundle.AttachDialog_UnknownProcess() : string;
    }

    private static String escapedText(String string, String string2) {
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.isEmpty()) {
            return "&lt;" + string2 + "&gt;";
        }
        return string;
    }

    private static void configureScrollBar(final JScrollBar jScrollBar) {
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jScrollBar.setEnabled(jScrollBar.getVisibleAmount() < jScrollBar.getMaximum());
            }
        });
    }

    private static void showDetails(RunningVM runningVM) {
        HTMLTextArea hTMLTextArea = new HTMLTextArea();
        JScrollPane jScrollPane = new JScrollPane((Component)hTMLTextArea, 22, 32);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setPreferredSize(new Dimension(500, 260));
        AttachDialog.configureScrollBar(jScrollPane.getVerticalScrollBar());
        AttachDialog.configureScrollBar(jScrollPane.getHorizontalScrollBar());
        hTMLTextArea.setText(AttachDialog.getDetails(runningVM));
        hTMLTextArea.setCaretPosition(0);
        HelpCtx helpCtx = new HelpCtx("ProcessDetails.HelpCtx");
        JButton jButton = new JButton(Bundle.AttachDialog_BtnClose());
        jButton.setDefaultCapable(true);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jScrollPane, Bundle.AttachDialog_DetailsCaption(AttachDialog.getProcessName(runningVM.getMainClass())), true, new Object[]{jButton}, (Object)jButton, 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
    }

    private static String getDetails(RunningVM runningVM) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table cellspacing=\"3\" cellpadding=\"0\" width=\"400\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.AttachDialog_RowPid());
        stringBuilder.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td width=\"100%\">");
        stringBuilder.append(runningVM.getPid());
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.AttachDialog_RowMainClass());
        stringBuilder.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td width=\"100%\">");
        stringBuilder.append(AttachDialog.escapedText(runningVM.getMainClass(), Bundle.AttachDialog_DetailsUnknown()));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.AttachDialog_RowArguments());
        stringBuilder.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td width=\"100%\">");
        stringBuilder.append(AttachDialog.escapedText(runningVM.getMainArgs(), Bundle.AttachDialog_DetailsNone()));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.AttachDialog_RowJvmArguments());
        stringBuilder.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td width=\"100%\">");
        stringBuilder.append(AttachDialog.escapedText(runningVM.getVMArgs(), Bundle.AttachDialog_DetailsNone()));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.AttachDialog_RowJvmFlags());
        stringBuilder.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td width=\"100%\">");
        stringBuilder.append(AttachDialog.escapedText(runningVM.getVMFlags(), Bundle.AttachDialog_DetailsNone()));
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private class ProcessesModel
    extends AbstractTableModel {
        private RunningVM[] vms;
        private boolean refreshing;
        private boolean firstRefresh = true;

        private ProcessesModel() {
        }

        void refresh() {
            this.refreshing = true;
            this.fireTableDataChanged();
            new RequestProcessor("Processes refresher").post(new Runnable(){

                @Override
                public void run() {
                    final RunningVM[] runningVMArray = JpsProxy.getRunningVMs();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProcessesModel.access$1602(ProcessesModel.this, runningVMArray);
                            ProcessesModel.this.refreshing = false;
                            ProcessesModel.this.fireTableDataChanged();
                            ProcessesModel.this.firstRefresh = false;
                        }
                    });
                }
            }, 500);
        }

        boolean isRefreshing() {
            return this.refreshing;
        }

        boolean isFirstRefresh() {
            return !this.refreshing && this.firstRefresh;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Bundle.AttachDialog_ColumnName();
            }
            if (n == 1) {
                return Bundle.AttachDialog_ColumnPid();
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 1) {
                return Integer.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.vms == null ? 0 : this.vms.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return AttachDialog.getProcessName(this.vms[n].getMainClass());
            }
            if (n2 == 1) {
                return this.vms[n].getPid();
            }
            if (n2 == -1) {
                return this.vms[n];
            }
            return null;
        }

        static /* synthetic */ RunningVM[] access$1602(ProcessesModel processesModel, RunningVM[] runningVMArray) {
            processesModel.vms = runningVMArray;
            return runningVMArray;
        }
    }

    private class Panel
    extends JPanel
    implements HelpCtx.Provider,
    ChangeListener {
        private static final int VISIBLE_ROWS = 9;
        private ActionPopupButton modeButton;
        private JTextField hostname;
        private ActionPopupButton os;
        private HTMLTextArea steps;
        private JCheckBox autoSelect;
        private DialogDescriptor displayer;
        private AttachSettings as;
        private String selectedName;
        private int selectedPid = -1;
        private boolean updatingUI = false;

        Panel() {
            this.initComponents();
        }

        void setDisplayer(DialogDescriptor dialogDescriptor) {
            this.displayer = dialogDescriptor;
        }

        void setup(AttachSettings attachSettings) {
            this.as = new AttachSettings();
            attachSettings.copyInto(this.as);
            this.updatingUI = true;
            if (attachSettings.isRemote()) {
                this.modeButton.selectAction(3);
            } else if (attachSettings.isDirect()) {
                this.modeButton.selectAction(2);
            } else {
                this.modeButton.selectAction(0);
            }
            this.modeButton.getSelectedAction().actionPerformed(null);
            this.hostname.setText(attachSettings.getHost());
            String string = attachSettings.getHostOS();
            for (Action action : this.os.getActions()) {
                if (action == null || !action.getValue("Name").equals(string)) continue;
                this.os.selectAction(action);
                break;
            }
            this.selectedName = attachSettings.getProcessName();
            this.selectedPid = attachSettings.getPid();
            this.autoSelect.setSelected(attachSettings.isAutoSelectProcess());
            this.updateAutoSelect();
            this.updatingUI = false;
            this.updateSteps();
        }

        AttachSettings getSettings() {
            int n = this.modeButton.getSelectedIndex();
            this.as.setRemote(n == 3);
            if (this.as.isRemote()) {
                this.as.setDirect(true);
                this.as.setDynamic16(false);
                this.as.setHost(this.hostname.getText().trim());
                this.as.setHostOS(this.os.getSelectedAction().getValue("Name").toString());
            } else {
                this.as.setDirect(n == 2);
                this.as.setDynamic16(n == 0);
                this.as.setHost("");
                this.as.setHostOS(null);
                this.as.setProcessName(this.selectedName);
                this.as.setPid(this.selectedPid);
                this.as.setAutoSelectProcess(this.autoSelect.isSelected());
            }
            return this.as;
        }

        private void initComponents() {
            final JLabel jLabel = new JLabel("", 10);
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.AttachDialog_SelectProcess());
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
            final ProcessesModel processesModel = new ProcessesModel();
            final ProfilerTable profilerTable = new ProfilerTable(processesModel, true, true, null){

                public String getToolTipText(MouseEvent mouseEvent) {
                    int n = this.rowAtPoint(mouseEvent.getPoint());
                    if (n == -1) {
                        return null;
                    }
                    n = this.convertRowIndexToModel(n);
                    return "<html>" + AttachDialog.getDetails((RunningVM)processesModel.getValueAt(n, -1)) + "</html>";
                }

                public Point getToolTipLocation(MouseEvent mouseEvent) {
                    int n = this.rowAtPoint(mouseEvent.getPoint());
                    if (n == -1) {
                        return null;
                    }
                    Rectangle rectangle = this.getCellRect(n, 0, false);
                    return new Point(mouseEvent.getX() + 15, rectangle.y + rectangle.height + 2);
                }
            };
            jLabel.setLabelFor((Component)profilerTable);
            profilerTable.setMainColumn(0);
            profilerTable.setFitWidthColumn(0);
            profilerTable.setDefaultSortOrder(SortOrder.ASCENDING);
            profilerTable.setSortColumn(0);
            profilerTable.setColumnToolTips(new String[]{Bundle.AttachDialog_ProcessNameTtp(), Bundle.AttachDialog_ProcessIdTtp()});
            LabelRenderer labelRenderer = new LabelRenderer();
            profilerTable.setColumnRenderer(0, (ProfilerRenderer)labelRenderer);
            LabelRenderer labelRenderer2 = new LabelRenderer();
            labelRenderer2.setHorizontalAlignment(11);
            profilerTable.setColumnRenderer(1, (ProfilerRenderer)labelRenderer2);
            labelRenderer2.setValue((Object)profilerTable.getColumnName(1), -1);
            int n = labelRenderer2.getPreferredSize().width;
            labelRenderer2.setValue((Object)"9999999", -1);
            n = Math.max(n, labelRenderer2.getPreferredSize().width);
            profilerTable.setDefaultColumnWidth(1, n + 10);
            Dimension dimension = profilerTable.getPreferredSize();
            dimension.height = profilerTable.getRowHeight() * 9;
            dimension.height += profilerTable.getTableHeader().getPreferredSize().height;
            profilerTable.setPreferredScrollableViewportSize(dimension);
            ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(profilerTable, true, null);
            final JButton jButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    processesModel.refresh();
                }
            };
            jButton.setToolTipText(Bundle.AttachDialog_ReloadProcesses());
            processesModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    boolean bl = !processesModel.isRefreshing();
                    profilerTable.setEnabled(bl);
                    jButton.setEnabled(bl);
                    Mnemonics.setLocalizedText((JLabel)jLabel, (String)(bl ? Bundle.AttachDialog_SelectProcess() : Bundle.AttachDialog_SelectProcessReload()));
                    if (processesModel.isFirstRefresh() && Panel.this.selectedName != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int n = profilerTable.convertColumnIndexToView(0);
                                int n2 = profilerTable.convertColumnIndexToView(1);
                                for (int i = 0; i < profilerTable.getRowCount(); ++i) {
                                    if (!Panel.this.selectedName.equals(profilerTable.getValueAt(i, n)) || Panel.this.selectedPid != (Integer)profilerTable.getValueAt(i, n2)) continue;
                                    profilerTable.selectRow(i, true);
                                    return;
                                }
                                if (!Panel.this.autoSelect.isSelected()) {
                                    Panel.this.selectedName = null;
                                }
                                Panel.this.selectedPid = -1;
                                Panel.this.updateAutoSelect();
                            }
                        });
                    }
                }
            });
            final JButton jButton2 = new JButton(Icons.getIcon((String)"GeneralIcons.Info")){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    AttachDialog.showDetails((RunningVM)profilerTable.getSelectedValue(-1));
                }
            };
            jButton2.setToolTipText(Bundle.AttachDialog_ShowDetails());
            this.autoSelect = new JCheckBox(){
                private final RowFilter rowFilter = new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        return Panel.this.selectedName == null || Panel.this.selectedName.equals(entry.getValue(0));
                    }
                };

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    super.fireItemStateChanged(itemEvent);
                    if (this.isSelected()) {
                        profilerTable.addRowFilter(this.rowFilter);
                    } else {
                        profilerTable.removeRowFilter(this.rowFilter);
                    }
                    Panel.this.updateAutoSelect();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.autoSelect, (String)Bundle.AttachDialog_ConnectToSelected());
            this.autoSelect.setEnabled(false);
            profilerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (profilerTable.getSelectedRow() == -1) {
                        Panel.this.selectedPid = -1;
                    } else {
                        Panel.this.selectedPid = (Integer)profilerTable.getSelectedValue(1);
                        Panel.this.selectedName = AttachDialog.getProcessName(profilerTable.getSelectedValue(0).toString());
                    }
                    Panel.this.updateDetails(jButton2);
                    Panel.this.updateAutoSelect();
                    Panel.this.updateDisplayer();
                }
            });
            FilteringToolbar filteringToolbar = new FilteringToolbar(Bundle.AttachDialog_FilterProcesses()){
                private GenericFilter _filter;
                private final RowFilter rowFilter;
                {
                    super(string);
                    this.rowFilter = new RowFilter(){

                        public boolean include(RowFilter.Entry entry) {
                            return _filter.passes(entry.getValue(0).toString());
                        }
                    };
                }

                protected void filterChanged() {
                    GenericFilter genericFilter = this._filter = this.isAll() ? null : this.getFilter();
                    if (this._filter != null) {
                        profilerTable.addRowFilter(this.rowFilter);
                    } else {
                        profilerTable.removeRowFilter(this.rowFilter);
                    }
                }
            };
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.addSeparator();
            filteringToolbar.add(Box.createHorizontalStrut(1));
            filteringToolbar.add((Component)jButton);
            filteringToolbar.add(Box.createHorizontalStrut(2));
            filteringToolbar.add((Component)jButton2);
            filteringToolbar.add(Box.createHorizontalStrut(3));
            filteringToolbar.add((Component)this.autoSelect);
            final JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)profilerTableContainer, "Center");
            jPanel.add((Component)filteringToolbar, "South");
            JLabel jLabel2 = new JLabel("", 10);
            Mnemonics.setLocalizedText((JLabel)jLabel2, (String)Bundle.AttachDialog_Steps());
            this.steps = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    if (AttachDialog.this.currentProvider != null) {
                        final String string = uRL.toString();
                        final AttachSettings attachSettings = new AttachSettings();
                        Panel.this.getSettings().copyInto(attachSettings);
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                AttachDialog.this.currentProvider.handleAction(string, attachSettings);
                            }
                        });
                    }
                }
            };
            jLabel2.setLabelFor((Component)this.steps);
            JScrollPane jScrollPane = new JScrollPane((Component)this.steps);
            final JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
            jPanel2.add((Component)jLabel2, "North");
            jPanel2.add((Component)jScrollPane, "Center");
            final JPanel jPanel3 = new JPanel(new GridBagLayout());
            final JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)jPanel, "Center");
            this.setLayout(new GridBagLayout());
            JLabel jLabel3 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel3, (String)Bundle.AttachDialog_Profile());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 0, 0);
            this.add((Component)jLabel3, gridBagConstraints);
            class ModeAction
            extends AbstractAction {
                private final boolean remote;
                private final boolean hasSteps;

                ModeAction(String string, boolean bl, boolean bl2) {
                    super(string);
                    this.remote = bl;
                    this.hasSteps = bl2;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jPanel4.removeAll();
                    jPanel3.setVisible(this.remote);
                    if (this.hasSteps) {
                        Panel.this.updateSteps();
                    }
                    jPanel4.add((Component)(this.hasSteps ? jPanel2 : jPanel), "Center");
                    jPanel4.invalidate();
                    jPanel4.revalidate();
                    jPanel4.repaint();
                    Panel.this.updateDisplayer();
                }
            }
            this.modeButton = new ActionPopupButton(new Action[]{new ModeAction(Bundle.AttachDialog_LocalRunningProcess(), false, false), null, new ModeAction(Bundle.AttachDialog_LocalStartedProcess(), false, true), new ModeAction(Bundle.AttachDialog_RemoteStartedProcess(), true, true)});
            this.modeButton.setPopupAlign(3);
            jLabel3.setLabelFor((Component)this.modeButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(10, 5, 0, 10);
            this.add((Component)this.modeButton, gridBagConstraints);
            JLabel jLabel4 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel4, (String)Bundle.AttachDialog_Hostname());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel3.add((Component)jLabel4, gridBagConstraints);
            this.hostname = new JTextField();
            jLabel4.setLabelFor(this.hostname);
            this.hostname.setText("https://netbeans.org/features/index.html");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 20);
            jPanel3.add((Component)this.hostname, gridBagConstraints);
            JLabel jLabel5 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel5, (String)Bundle.AttachDialog_OsJvm());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel3.add((Component)jLabel5, gridBagConstraints);
            class OsAction
            extends AbstractAction {
                OsAction(String string) {
                    super(string);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.updateSteps();
                }
            }
            this.os = new ActionPopupButton(new Action[]{new OsAction(IntegrationUtils.PLATFORM_WINDOWS_OS), new OsAction(IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS), new OsAction(IntegrationUtils.PLATFORM_WINDOWS_CVM), null, new OsAction(IntegrationUtils.PLATFORM_LINUX_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_AMD64_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_ARM_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_ARM_VFP_HFLT_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_CVM), null, new OsAction(IntegrationUtils.PLATFORM_MAC_OS), null, new OsAction(IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS), new OsAction(IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS), new OsAction(IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS), new OsAction(IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS)});
            jLabel5.setLabelFor((Component)this.os);
            this.os.setPopupAlign(3);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel3.add((Component)this.os, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 10, 0, 10);
            this.add((Component)jPanel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(20, 10, 10, 10);
            this.add((Component)jPanel4, gridBagConstraints);
            this.setPreferredSize(this.getPreferredSize());
            this.hostname.setText("");
            processesModel.refresh();
            this.updateDetails(jButton2);
            this.updateAutoSelect();
        }

        private void updateSteps() {
            if (this.updatingUI) {
                return;
            }
            this.steps.setText(AttachDialog.this.steps(this.getSettings()));
            this.steps.setCaretPosition(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Panel.this.steps.setCaretPosition(0);
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Panel.this.updateSteps();
                }
            });
        }

        private void updateDetails(JButton jButton) {
            jButton.setEnabled(this.selectedPid != -1);
        }

        private void updateAutoSelect() {
            if (!this.autoSelect.isSelected() && this.selectedPid == -1) {
                this.selectedName = null;
            }
            this.autoSelect.setEnabled(this.autoSelect.isSelected() || this.selectedPid != -1);
            Mnemonics.setLocalizedText((AbstractButton)this.autoSelect, (String)(this.selectedName == null ? Bundle.AttachDialog_ConnectToSelected() : Bundle.AttachDialog_ConnectToProcess(this.selectedName)));
        }

        private void updateDisplayer() {
            if (this.displayer == null) {
                return;
            }
            if (this.modeButton.getSelectedIndex() != 0) {
                this.displayer.setValid(true);
                return;
            }
            this.displayer.setValid(this.selectedPid != -1);
        }
    }
}

