/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuWindow;
import sun.util.logging.PlatformLogger;

public class XMenuPeer
extends XMenuItemPeer
implements MenuPeer {
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XMenuPeer");
    XMenuWindow menuWindow;

    XMenuPeer(Menu menu) {
        super(menu);
    }

    @Override
    void setContainer(XBaseMenuWindow xBaseMenuWindow) {
        super.setContainer(xBaseMenuWindow);
        this.menuWindow = new XMenuWindow(this);
    }

    @Override
    public void dispose() {
        if (this.menuWindow != null) {
            this.menuWindow.dispose();
        }
        super.dispose();
    }

    @Override
    public void setFont(Font font) {
        this.resetTextMetrics();
        XMenuWindow xMenuWindow = this.getMenuWindow();
        if (xMenuWindow != null) {
            xMenuWindow.setItemsFont(font);
        }
        this.repaintIfShowing();
    }

    @Override
    public void addSeparator() {
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("addSeparator is not implemented");
        }
    }

    @Override
    public void addItem(MenuItem menuItem) {
        XMenuWindow xMenuWindow = this.getMenuWindow();
        if (xMenuWindow != null) {
            xMenuWindow.addItem(menuItem);
        } else if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Attempt to use XMenuWindowPeer without window");
        }
    }

    @Override
    public void delItem(int n) {
        XMenuWindow xMenuWindow = this.getMenuWindow();
        if (xMenuWindow != null) {
            xMenuWindow.delItem(n);
        } else if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Attempt to use XMenuWindowPeer without window");
        }
    }

    Vector getTargetItems() {
        return AWTAccessor.getMenuAccessor().getItems((Menu)this.getTarget());
    }

    @Override
    boolean isSeparator() {
        return false;
    }

    @Override
    String getShortcutText() {
        return null;
    }

    XMenuWindow getMenuWindow() {
        return this.menuWindow;
    }
}

