/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XdbeSwapInfo
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    @Override
    public int getDataSize() {
        return XdbeSwapInfo.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XdbeSwapInfo(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XdbeSwapInfo() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XdbeSwapInfo.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_swap_window() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_swap_window(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public int get_swap_action() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_swap_action(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    @Override
    String getName() {
        return "XdbeSwapInfo";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(80);
        ret.append("swap_window = ").append(this.get_swap_window()).append(", ");
        ret.append("swap_action = ").append(this.get_swap_action()).append(", ");
        return ret.toString();
    }
}

