/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.util.JAXPUtils;

public class IvyReport
extends IvyTask {
    private File todir;
    private String organisation;
    private String module;
    private String conf;
    private boolean graph = true;
    private boolean dot = false;
    private boolean xml = false;
    private boolean xsl = true;
    private File xslFile;
    private String outputpattern;
    private String xslext = "html";
    private List params = new ArrayList();
    private String resolveId;
    private ModuleRevisionId mRevId;

    public File getTodir() {
        return this.todir;
    }

    public void setTodir(File file) {
        this.todir = file;
    }

    public void setCache(File file) {
        this.cacheAttributeNotSupported();
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String string) {
        this.conf = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean bl) {
        this.graph = bl;
    }

    public File getXslfile() {
        return this.xslFile;
    }

    public void setXslfile(File file) {
        this.xslFile = file;
    }

    public String getOutputpattern() {
        return this.outputpattern;
    }

    public void setOutputpattern(String string) {
        this.outputpattern = string;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public void setResolveId(String string) {
        this.resolveId = string;
    }

    @Override
    public void doExecute() throws BuildException {
        String[] stringArray;
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        this.conf = this.getProperty(this.conf, ivySettings, "ivy.resolved.configurations", this.resolveId);
        if ("*".equals(this.conf)) {
            this.conf = this.getProperty(ivySettings, "ivy.resolved.configurations", this.resolveId);
        }
        if (this.conf == null) {
            throw new BuildException("no conf provided for ivy report task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        if (this.todir == null && (stringArray = this.getProperty(ivySettings, "ivy.report.todir")) != null) {
            this.todir = this.getProject().resolveFile((String)stringArray);
        }
        if (this.todir != null && this.todir.exists()) {
            this.todir.mkdirs();
        }
        this.outputpattern = this.getProperty(this.outputpattern, ivySettings, "ivy.report.output.pattern");
        if (this.outputpattern == null) {
            this.outputpattern = "[organisation]-[module]-[conf].[ext]";
        }
        if (this.todir != null && this.todir.exists() && !this.todir.isDirectory()) {
            throw new BuildException("destination directory should be a directory !");
        }
        if (this.resolveId == null) {
            this.organisation = this.getProperty(this.organisation, ivySettings, "ivy.organisation", this.resolveId);
            this.module = this.getProperty(this.module, ivySettings, "ivy.module", this.resolveId);
            if (this.organisation == null) {
                throw new BuildException("no organisation provided for ivy report task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
            }
            if (this.module == null) {
                throw new BuildException("no module name provided for ivy report task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
            }
            this.resolveId = ResolveOptions.getDefaultResolveId(new ModuleId(this.organisation, this.module));
        }
        try {
            stringArray = this.splitConfs(this.conf);
            if (this.xsl) {
                this.genreport(stringArray);
            }
            if (this.xml) {
                this.genxml(stringArray);
            }
            if (this.graph) {
                this.genStyled(stringArray, this.getStylePath("ivy-report-graph.xsl"), "graphml");
            }
            if (this.dot) {
                this.genStyled(stringArray, this.getStylePath("ivy-report-dot.xsl"), "dot");
            }
        }
        catch (IOException iOException) {
            throw new BuildException("impossible to generate report: " + iOException, (Throwable)iOException);
        }
    }

    private void genxml(String[] stringArray) throws IOException {
        ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = resolutionCacheManager.getConfigurationResolveReportInCache(this.resolveId, stringArray[i]);
            File file2 = this.todir != null ? new File(this.todir, this.getOutputPattern(stringArray[i], "xml")) : this.getProject().resolveFile(this.getOutputPattern(stringArray[i], "xml"));
            FileUtil.copy(file, file2, null);
        }
    }

    private void genreport(String[] stringArray) throws IOException {
        File file;
        this.genStyled(stringArray, this.getReportStylePath(), this.xslext);
        if (this.xslFile == null && !(file = this.todir != null ? new File(this.todir, "ivy-report.css") : this.getProject().resolveFile("ivy-report.css")).exists()) {
            Message.debug("copying report css to " + file.getAbsolutePath());
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), file, null);
        }
    }

    private File getReportStylePath() throws IOException {
        if (this.xslFile != null) {
            return this.xslFile;
        }
        ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
        File file = new File(resolutionCacheManager.getResolutionCacheRoot(), "ivy-report.xsl");
        if (!file.exists()) {
            Message.debug("copying ivy-report.xsl to " + file.getAbsolutePath());
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.xsl"), file, null);
        }
        return file;
    }

    private String getOutputPattern(String string, String string2) {
        if (this.mRevId == null) {
            ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
            XmlReportParser xmlReportParser = new XmlReportParser();
            File file = resolutionCacheManager.getConfigurationResolveReportInCache(this.resolveId, string);
            try {
                xmlReportParser.parse(file);
            }
            catch (ParseException parseException) {
                throw new BuildException("Error occurred while parsing reportfile '" + file.getAbsolutePath() + "'", (Throwable)parseException);
            }
            this.mRevId = xmlReportParser.getResolvedModule();
        }
        return IvyPatternHelper.substitute(this.outputpattern, this.mRevId.getOrganisation(), this.mRevId.getName(), this.mRevId.getRevision(), "", "", string2, string, this.mRevId.getQualifiedExtraAttributes(), null);
    }

    private void genStyled(String[] stringArray, File file, String string) throws IOException {
        ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
        File file2 = this.todir != null ? this.todir : this.getProject().getBaseDir();
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            StreamSource streamSource = new StreamSource(inputStream, JAXPUtils.getSystemId((File)file));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            transformer.setParameter("confs", this.conf);
            transformer.setParameter("extension", this.xslext);
            for (Object object : this.params) {
                transformer.setParameter(object.getName(), object.getExpression());
            }
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                object = resolutionCacheManager.getConfigurationResolveReportInCache(this.resolveId, stringArray[i]);
                File file3 = new File(file2, this.getOutputPattern(stringArray[i], string));
                this.log("Processing " + object + " to " + file3);
                File file4 = file3.getParentFile();
                if (!file4.exists() && !file4.mkdirs()) {
                    throw new BuildException("Unable to create directory: " + file4.getAbsolutePath());
                }
                InputStream inputStream2 = null;
                OutputStream outputStream = null;
                try {
                    inputStream2 = new BufferedInputStream(new FileInputStream((File)object));
                    outputStream = new BufferedOutputStream(new FileOutputStream(file3));
                    StreamResult streamResult = new StreamResult(outputStream);
                    StreamSource streamSource2 = new StreamSource(inputStream2, JAXPUtils.getSystemId((File)file));
                    transformer.transform(streamSource2, streamResult);
                    continue;
                }
                catch (TransformerException transformerException) {
                    throw new BuildException((Throwable)transformerException);
                }
                finally {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new BuildException((Throwable)transformerConfigurationException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File getStylePath(String string) throws IOException {
        ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
        File file = new File(resolutionCacheManager.getResolutionCacheRoot(), string);
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream(string), file, null);
        return file;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean bl) {
        this.xml = bl;
    }

    public boolean isXsl() {
        return this.xsl;
    }

    public void setXsl(boolean bl) {
        this.xsl = bl;
    }

    public String getXslext() {
        return this.xslext;
    }

    public void setXslext(String string) {
        this.xslext = string;
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param param = new XSLTProcess.Param();
        this.params.add(param);
        return param;
    }

    public boolean isDot() {
        return this.dot;
    }

    public void setDot(boolean bl) {
        this.dot = bl;
    }
}

