/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.update;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.update.UpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultUpdateService
implements UpdateService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUpdateService.class);
    private static final String CURRENT_VERSION_KEY = "currentVersion";
    private Object jsonSource;

    @Inject
    DefaultUpdateService(@Named(value="updatesUrl") Object jsonSource) {
        this.jsonSource = jsonSource;
    }

    @Override
    public String getLatestVersion() {
        try {
            return JSON.std.mapFrom(this.jsonSource).getOrDefault(CURRENT_VERSION_KEY, "").toString();
        }
        catch (IOException e) {
            LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to find the latest available version."), (Throwable)e);
            return "";
        }
    }
}

