/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.Map;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.SetMetadataParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.PdfMetadataKey;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocumentInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMetadataTask
extends BaseTask<SetMetadataParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SetMetadataTask.class);
    private PDDocumentHandler documentHandler = null;
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(SetMetadataParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(SetMetadataParameters parameters) throws TaskException {
        this.executionContext().assertTaskNotCancelled();
        ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).progressUndetermined();
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
        this.documentHandler.setCreatorOnPDDocument();
        File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        LOG.debug("Setting metadata on temporary document.");
        PDDocumentInformation actualMeta = this.documentHandler.getUnderlyingPDDocument().getDocumentInformation();
        for (Map.Entry meta : parameters.entrySet()) {
            LOG.trace("'{}' -> '{}'", (Object)((PdfMetadataKey)meta.getKey()).getKey(), meta.getValue());
            actualMeta.setCustomMetadataValue(((PdfMetadataKey)meta.getKey()).getKey(), (String)meta.getValue());
        }
        this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
        this.documentHandler.setCompress(parameters.isCompress());
        this.documentHandler.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Metadata set on {}", (Object)parameters.getOutput());
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.documentHandler);
    }
}

