/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.PdfAlternateMixer;
import org.sejda.model.exception.TaskException;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.AlternateMixMultipleInputParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternateMixTask
extends BaseTask<AlternateMixMultipleInputParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(AlternateMixTask.class);
    private PdfAlternateMixer mixer = null;
    private SingleOutputWriter outputWriter;

    public void before(AlternateMixMultipleInputParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.mixer = new PdfAlternateMixer();
        this.outputWriter = OutputWriters.newSingleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(AlternateMixMultipleInputParameters parameters) throws TaskException {
        LOG.debug("Starting alternate mix of {} input documents", (Object)parameters.getInputList().size());
        this.mixer.mix(parameters.getInputList(), this.executionContext());
        this.mixer.setVersionOnPDDocument(parameters.getVersion());
        this.mixer.setCompress(parameters.isCompress());
        File tmpFile = IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        this.mixer.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.mixer);
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Alternate mix of {} files completed", (Object)parameters.getInputList().size());
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly((Closeable)this.mixer);
    }
}

